/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.InsertHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InsertHeaderTest {
    private final InsertHeader<SourceRecord> xform = new InsertHeader();

    private Map<String, ?> config(String header, String valueLiteral) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("header", header);
        result.put("value.literal", valueLiteral);
        return result;
    }

    @Test
    public void insertionWithExistingOtherHeader() {
        this.xform.configure(this.config("inserted", "inserted-value"));
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("existing", "existing-value");
        Headers expect = headers.duplicate().addString("inserted", "inserted-value");
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expect, (Object)xformed.headers());
    }

    @Test
    public void insertionWithExistingSameHeader() {
        this.xform.configure(this.config("existing", "inserted-value"));
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("existing", "preexisting-value");
        Headers expect = headers.duplicate().addString("existing", "inserted-value");
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expect, (Object)xformed.headers());
    }

    @Test
    public void insertionWithByteHeader() {
        this.xform.configure(this.config("inserted", "1"));
        ConnectHeaders headers = new ConnectHeaders();
        headers.addString("existing", "existing-value");
        Headers expect = headers.duplicate().addByte("inserted", (byte)1);
        SourceRecord original = this.sourceRecord(headers);
        SourceRecord xformed = (SourceRecord)this.xform.apply((ConnectRecord)original);
        this.assertNonHeaders(original, xformed);
        Assertions.assertEquals((Object)expect, (Object)xformed.headers());
    }

    @Test
    public void configRejectsNullHeaderKey() {
        Assertions.assertThrows(ConfigException.class, () -> this.xform.configure(this.config(null, "1")));
    }

    @Test
    public void configRejectsNullHeaderValue() {
        Assertions.assertThrows(ConfigException.class, () -> this.xform.configure(this.config("inserted", null)));
    }

    private void assertNonHeaders(SourceRecord original, SourceRecord xformed) {
        Assertions.assertEquals((Object)original.sourcePartition(), (Object)xformed.sourcePartition());
        Assertions.assertEquals((Object)original.sourceOffset(), (Object)xformed.sourceOffset());
        Assertions.assertEquals((Object)original.topic(), (Object)xformed.topic());
        Assertions.assertEquals((Integer)original.kafkaPartition(), (Integer)xformed.kafkaPartition());
        Assertions.assertEquals((Object)original.keySchema(), (Object)xformed.keySchema());
        Assertions.assertEquals((Object)original.key(), (Object)xformed.key());
        Assertions.assertEquals((Object)original.valueSchema(), (Object)xformed.valueSchema());
        Assertions.assertEquals((Object)original.value(), (Object)xformed.value());
        Assertions.assertEquals((Long)original.timestamp(), (Long)xformed.timestamp());
    }

    private SourceRecord sourceRecord(ConnectHeaders headers) {
        Map<String, String> sourcePartition = Collections.singletonMap("foo", "bar");
        Map<String, String> sourceOffset = Collections.singletonMap("baz", "quxx");
        String topic = "topic";
        Integer partition = 0;
        Schema keySchema = null;
        String key = "key";
        Schema valueSchema = null;
        String value = "value";
        Long timestamp = 0L;
        return new SourceRecord(sourcePartition, sourceOffset, topic, partition, keySchema, (Object)key, valueSchema, (Object)value, timestamp, (Iterable)headers);
    }

    @Test
    public void testInsertHeaderVersionRetrievedFromAppInfoParser() {
        Assertions.assertEquals((Object)AppInfoParser.getVersion(), (Object)this.xform.version());
    }
}

