/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.connect.mirror.DefaultReplicationPolicy;
import org.apache.kafka.connect.mirror.IdentityReplicationPolicy;
import org.apache.kafka.connect.mirror.MirrorClient;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorClientTest {
    @Test
    public void testIsHeartbeatTopic() {
        FakeMirrorClient client = new FakeMirrorClient();
        Assertions.assertTrue((boolean)client.isHeartbeatTopic("heartbeats"));
        Assertions.assertTrue((boolean)client.isHeartbeatTopic("source1.heartbeats"));
        Assertions.assertTrue((boolean)client.isHeartbeatTopic("source2.source1.heartbeats"));
        Assertions.assertFalse((boolean)client.isHeartbeatTopic("heartbeats!"));
        Assertions.assertFalse((boolean)client.isHeartbeatTopic("!heartbeats"));
        Assertions.assertFalse((boolean)client.isHeartbeatTopic("source1heartbeats"));
        Assertions.assertFalse((boolean)client.isHeartbeatTopic("source1-heartbeats"));
    }

    @Test
    public void testIsCheckpointTopic() {
        FakeMirrorClient client = new FakeMirrorClient();
        Assertions.assertTrue((boolean)client.isCheckpointTopic("source1.checkpoints.internal"));
        Assertions.assertFalse((boolean)client.isCheckpointTopic("checkpoints.internal"));
        Assertions.assertFalse((boolean)client.isCheckpointTopic("checkpoints-internal"));
        Assertions.assertFalse((boolean)client.isCheckpointTopic("checkpoints.internal!"));
        Assertions.assertFalse((boolean)client.isCheckpointTopic("!checkpoints.internal"));
        Assertions.assertFalse((boolean)client.isCheckpointTopic("source1checkpointsinternal"));
    }

    @Test
    public void countHopsForTopicTest() {
        FakeMirrorClient client = new FakeMirrorClient();
        Assertions.assertEquals((int)-1, (int)client.countHopsForTopic("topic", "source"));
        Assertions.assertEquals((int)-1, (int)client.countHopsForTopic("source", "source"));
        Assertions.assertEquals((int)-1, (int)client.countHopsForTopic("sourcetopic", "source"));
        Assertions.assertEquals((int)-1, (int)client.countHopsForTopic("source1.topic", "source2"));
        Assertions.assertEquals((int)1, (int)client.countHopsForTopic("source1.topic", "source1"));
        Assertions.assertEquals((int)1, (int)client.countHopsForTopic("source2.source1.topic", "source2"));
        Assertions.assertEquals((int)2, (int)client.countHopsForTopic("source2.source1.topic", "source1"));
        Assertions.assertEquals((int)3, (int)client.countHopsForTopic("source3.source2.source1.topic", "source1"));
        Assertions.assertEquals((int)-1, (int)client.countHopsForTopic("source3.source2.source1.topic", "source4"));
    }

    @Test
    public void heartbeatTopicsTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "heartbeats", "source1.heartbeats", "source2.source1.heartbeats", "source3.heartbeats"));
        Set heartbeatTopics = client.heartbeatTopics();
        Assertions.assertEquals((Object)heartbeatTopics, new HashSet<String>(Arrays.asList("heartbeats", "source1.heartbeats", "source2.source1.heartbeats", "source3.heartbeats")));
    }

    @Test
    public void checkpointsTopicsTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "checkpoints.internal", "source1.checkpoints.internal", "source2.source1.checkpoints.internal", "source3.checkpoints.internal"));
        Set checkpointTopics = client.checkpointTopics();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("source1.checkpoints.internal", "source2.source1.checkpoints.internal", "source3.checkpoints.internal")), (Object)checkpointTopics);
    }

    @Test
    public void replicationHopsTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "heartbeats", "source1.heartbeats", "source1.source2.heartbeats", "source3.heartbeats"));
        Assertions.assertEquals((int)1, (int)client.replicationHops("source1"));
        Assertions.assertEquals((int)2, (int)client.replicationHops("source2"));
        Assertions.assertEquals((int)1, (int)client.replicationHops("source3"));
        Assertions.assertEquals((int)-1, (int)client.replicationHops("source4"));
    }

    @Test
    public void upstreamClustersTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "heartbeats", "source1.heartbeats", "source1.source2.heartbeats", "source3.source4.source5.heartbeats"));
        Set sources = client.upstreamClusters();
        Assertions.assertTrue((boolean)sources.contains("source1"));
        Assertions.assertTrue((boolean)sources.contains("source2"));
        Assertions.assertTrue((boolean)sources.contains("source3"));
        Assertions.assertTrue((boolean)sources.contains("source4"));
        Assertions.assertTrue((boolean)sources.contains("source5"));
        Assertions.assertFalse((boolean)sources.contains("sourceX"));
        Assertions.assertFalse((boolean)sources.contains(""));
        Assertions.assertFalse((boolean)sources.contains(null));
    }

    @Test
    public void testIdentityReplicationUpstreamClusters() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(this.identityReplicationPolicy("source"), Arrays.asList("topic1", "topic2", "heartbeats", "source1.heartbeats", "source1.source2.heartbeats", "source3.source4.source5.heartbeats"));
        Set sources = client.upstreamClusters();
        Assertions.assertTrue((boolean)sources.contains("source1"));
        Assertions.assertTrue((boolean)sources.contains("source2"));
        Assertions.assertTrue((boolean)sources.contains("source3"));
        Assertions.assertTrue((boolean)sources.contains("source4"));
        Assertions.assertTrue((boolean)sources.contains("source5"));
        Assertions.assertFalse((boolean)sources.contains(""));
        Assertions.assertFalse((boolean)sources.contains(null));
        Assertions.assertEquals((int)5, (int)sources.size());
    }

    @Test
    public void remoteTopicsTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "topic3", "source1.topic4", "source1.source2.topic5", "source3.source4.source5.topic6"));
        Set remoteTopics = client.remoteTopics();
        Assertions.assertFalse((boolean)remoteTopics.contains("topic1"));
        Assertions.assertFalse((boolean)remoteTopics.contains("topic2"));
        Assertions.assertFalse((boolean)remoteTopics.contains("topic3"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source1.topic4"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source1.source2.topic5"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source3.source4.source5.topic6"));
    }

    @Test
    public void testIdentityReplicationRemoteTopics() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(this.identityReplicationPolicy("source"), Arrays.asList("topic1", "topic2", "topic3", "heartbeats", "backup.heartbeats"));
        Set remoteTopics = client.remoteTopics();
        Assertions.assertTrue((boolean)remoteTopics.contains("topic1"));
        Assertions.assertTrue((boolean)remoteTopics.contains("topic2"));
        Assertions.assertTrue((boolean)remoteTopics.contains("topic3"));
        Assertions.assertFalse((boolean)remoteTopics.contains("heartbeats"));
        Assertions.assertTrue((boolean)remoteTopics.contains("backup.heartbeats"));
    }

    @Test
    public void remoteTopicsSeparatorTest() throws InterruptedException {
        FakeMirrorClient client = new FakeMirrorClient(Arrays.asList("topic1", "topic2", "topic3", "source1__topic4", "source1__source2__topic5", "source3__source4__source5__topic6"));
        ((Configurable)client.replicationPolicy()).configure(Collections.singletonMap("replication.policy.separator", "__"));
        Set remoteTopics = client.remoteTopics();
        Assertions.assertFalse((boolean)remoteTopics.contains("topic1"));
        Assertions.assertFalse((boolean)remoteTopics.contains("topic2"));
        Assertions.assertFalse((boolean)remoteTopics.contains("topic3"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source1__topic4"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source1__source2__topic5"));
        Assertions.assertTrue((boolean)remoteTopics.contains("source3__source4__source5__topic6"));
    }

    @Test
    public void testIdentityReplicationTopicSource() {
        FakeMirrorClient client = new FakeMirrorClient(this.identityReplicationPolicy("primary"), Collections.emptyList());
        Assertions.assertEquals((Object)"topic1", (Object)client.replicationPolicy().formatRemoteTopic("primary", "topic1"));
        Assertions.assertEquals((Object)"primary", (Object)client.replicationPolicy().topicSource("topic1"));
        Assertions.assertEquals((Object)"backup.heartbeats", (Object)client.replicationPolicy().formatRemoteTopic("backup", "heartbeats"));
        Assertions.assertEquals((Object)"backup", (Object)client.replicationPolicy().topicSource("backup.heartbeats"));
    }

    private ReplicationPolicy identityReplicationPolicy(String source) {
        IdentityReplicationPolicy policy = new IdentityReplicationPolicy();
        policy.configure(Collections.singletonMap("source.cluster.alias", source));
        return policy;
    }

    private static class FakeMirrorClient
    extends MirrorClient {
        List<String> topics;

        FakeMirrorClient(List<String> topics) {
            this((ReplicationPolicy)new DefaultReplicationPolicy(), topics);
        }

        FakeMirrorClient(ReplicationPolicy replicationPolicy, List<String> topics) {
            super(null, replicationPolicy, null);
            this.topics = topics;
        }

        FakeMirrorClient() {
            this(Collections.emptyList());
        }

        protected Set<String> listTopics() {
            return new HashSet<String>(this.topics);
        }
    }
}

