/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplicationPolicy
implements ReplicationPolicy,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicationPolicy.class);
    public static final String SEPARATOR_CONFIG = "replication.policy.separator";
    public static final String SEPARATOR_DEFAULT = ".";
    public static final String INTERNAL_TOPIC_SEPARATOR_ENABLED_CONFIG = "replication.policy.internal.topic.separator.enabled";
    public static final Boolean INTERNAL_TOPIC_SEPARATOR_ENABLED_DEFAULT = true;
    private String separator = ".";
    private Pattern separatorPattern = Pattern.compile(Pattern.quote("."));
    private boolean isInternalTopicSeparatorEnabled = true;

    public void configure(Map<String, ?> props) {
        if (props.containsKey(SEPARATOR_CONFIG)) {
            this.separator = (String)props.get(SEPARATOR_CONFIG);
            log.info("Using custom remote topic separator: '{}'", (Object)this.separator);
            this.separatorPattern = Pattern.compile(Pattern.quote(this.separator));
            if (props.containsKey(INTERNAL_TOPIC_SEPARATOR_ENABLED_CONFIG)) {
                this.isInternalTopicSeparatorEnabled = Boolean.parseBoolean(props.get(INTERNAL_TOPIC_SEPARATOR_ENABLED_CONFIG).toString());
                if (!this.isInternalTopicSeparatorEnabled) {
                    log.warn("Disabling custom topic separator for internal topics; will use '.' instead of '{}'", (Object)this.separator);
                }
            }
        }
    }

    @Override
    public String formatRemoteTopic(String sourceClusterAlias, String fullTopic) {
        String topic = fullTopic.startsWith("/") ? fullTopic.split(":")[1] : fullTopic;
        return sourceClusterAlias + this.separator + topic;
    }

    @Override
    public String topicSource(String topic) {
        String[] parts = this.separatorPattern.split(topic);
        if (parts.length < 2) {
            return null;
        }
        return parts[0];
    }

    @Override
    public String upstreamTopic(String topic) {
        String source = this.topicSource(topic);
        if (source == null) {
            return null;
        }
        return topic.substring(source.length() + this.separator.length());
    }

    private String internalSeparator() {
        return this.isInternalTopicSeparatorEnabled ? this.separator : SEPARATOR_DEFAULT;
    }

    private String internalSuffix() {
        return this.internalSeparator() + "internal";
    }

    private String checkpointsTopicSuffix() {
        return this.internalSeparator() + "checkpoints" + this.internalSuffix();
    }

    @Override
    public String offsetSyncsTopic(String clusterAlias) {
        return "mm2-offset-syncs" + this.internalSeparator() + clusterAlias + this.internalSuffix();
    }

    @Override
    public String checkpointsTopic(String clusterAlias) {
        return clusterAlias + this.checkpointsTopicSuffix();
    }

    @Override
    public boolean isCheckpointsTopic(String topic) {
        return topic.endsWith(this.checkpointsTopicSuffix());
    }

    @Override
    public boolean isMM2InternalTopic(String topic) {
        return topic.endsWith(this.internalSuffix());
    }
}

