/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.mirror.DefaultReplicationPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReplicationPolicyTest {
    private static final DefaultReplicationPolicy DEFAULT_REPLICATION_POLICY = new DefaultReplicationPolicy();

    @BeforeEach
    public void setUp() {
        DEFAULT_REPLICATION_POLICY.configure(Collections.emptyMap());
    }

    @Test
    public void testInternalTopic() {
        Assertions.assertTrue((boolean)DEFAULT_REPLICATION_POLICY.isInternalTopic("__consumer_offsets"));
        Assertions.assertTrue((boolean)DEFAULT_REPLICATION_POLICY.isInternalTopic(".hiddentopic"));
        Assertions.assertTrue((boolean)DEFAULT_REPLICATION_POLICY.isInternalTopic("mm2-offsets.CLUSTER.internal"));
        Assertions.assertTrue((boolean)DEFAULT_REPLICATION_POLICY.isInternalTopic("mm2-offsets-CLUSTER-internal"));
        Assertions.assertFalse((boolean)DEFAULT_REPLICATION_POLICY.isInternalTopic("mm2-offsets_CLUSTER_internal"));
    }

    @Test
    public void offsetSyncsTopic_shouldBeEffectedByInternalTopicSeparatorEnabled() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("replication.policy.separator", "__");
        config.put("replication.policy.internal.topic.separator.enabled", false);
        DEFAULT_REPLICATION_POLICY.configure(config);
        Assertions.assertEquals((Object)"mm2-offset-syncs.CLUSTER.internal", (Object)DEFAULT_REPLICATION_POLICY.offsetSyncsTopic("CLUSTER"));
        config.put("replication.policy.internal.topic.separator.enabled", true);
        DEFAULT_REPLICATION_POLICY.configure(config);
        Assertions.assertEquals((Object)"mm2-offset-syncs__CLUSTER__internal", (Object)DEFAULT_REPLICATION_POLICY.offsetSyncsTopic("CLUSTER"));
    }

    @Test
    public void checkpointsTopic_shouldBeEffectedByInternalTopicSeparatorEnabled() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("replication.policy.separator", "__");
        config.put("replication.policy.internal.topic.separator.enabled", false);
        DEFAULT_REPLICATION_POLICY.configure(config);
        Assertions.assertEquals((Object)"CLUSTER.checkpoints.internal", (Object)DEFAULT_REPLICATION_POLICY.checkpointsTopic("CLUSTER"));
        config.put("replication.policy.internal.topic.separator.enabled", true);
        DEFAULT_REPLICATION_POLICY.configure(config);
        Assertions.assertEquals((Object)"CLUSTER__checkpoints__internal", (Object)DEFAULT_REPLICATION_POLICY.checkpointsTopic("CLUSTER"));
    }

    @Test
    public void heartbeatsTopic_shouldNotBeEffectedByInternalTopicSeparatorConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("replication.policy.separator", "__");
        config.put("replication.policy.internal.topic.separator.enabled", true);
        Assertions.assertEquals((Object)"heartbeats", (Object)DEFAULT_REPLICATION_POLICY.heartbeatsTopic());
        config.put("replication.policy.internal.topic.separator.enabled", false);
        DEFAULT_REPLICATION_POLICY.configure(config);
        Assertions.assertEquals((Object)"heartbeats", (Object)DEFAULT_REPLICATION_POLICY.heartbeatsTopic());
    }
}

