/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.file.FileStreamSourceConnector;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.apache.kafka.connect.source.ConnectorTransactionBoundaries;
import org.apache.kafka.connect.source.ExactlyOnceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class FileStreamSourceConnectorTest {
    private static final String SINGLE_TOPIC = "test";
    private static final String FILENAME = "/somefilename";
    private FileStreamSourceConnector connector;
    private Map<String, String> sourceProperties;

    @BeforeEach
    public void setup() {
        this.connector = new FileStreamSourceConnector();
        ConnectorContext ctx = (ConnectorContext)Mockito.mock(ConnectorContext.class);
        this.connector.initialize(ctx);
        this.sourceProperties = new HashMap<String, String>();
        this.sourceProperties.put("topic", SINGLE_TOPIC);
        this.sourceProperties.put("file", FILENAME);
    }

    @Test
    public void testConnectorConfigValidation() {
        List configValues = this.connector.config().validate(this.sourceProperties);
        for (ConfigValue val : configValues) {
            Assertions.assertEquals((int)0, (int)val.errorMessages().size(), (String)("Config property errors: " + val.errorMessages()));
        }
    }

    @Test
    public void testExactlyOnceSupport() {
        this.sourceProperties.put("file", FILENAME);
        Assertions.assertEquals((Object)ExactlyOnceSupport.SUPPORTED, (Object)this.connector.exactlyOnceSupport(this.sourceProperties));
        this.sourceProperties.put("file", " ");
        Assertions.assertEquals((Object)ExactlyOnceSupport.UNSUPPORTED, (Object)this.connector.exactlyOnceSupport(this.sourceProperties));
        this.sourceProperties.remove("file");
        Assertions.assertEquals((Object)ExactlyOnceSupport.UNSUPPORTED, (Object)this.connector.exactlyOnceSupport(this.sourceProperties));
    }

    @Test
    public void testTransactionBoundaryDefinition() {
        Assertions.assertEquals((Object)ConnectorTransactionBoundaries.UNSUPPORTED, (Object)this.connector.canDefineTransactionBoundaries(this.sourceProperties));
    }

    @Test
    public void testSourceTasks() {
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assertions.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
        taskConfigs = this.connector.taskConfigs(2);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)FILENAME, ((Map)taskConfigs.get(0)).get("file"));
        Assertions.assertEquals((Object)SINGLE_TOPIC, ((Map)taskConfigs.get(0)).get("topic"));
    }

    @Test
    public void testSourceTasksStdin() {
        this.sourceProperties.remove("file");
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertNull(((Map)taskConfigs.get(0)).get("file"));
    }

    @Test
    public void testTaskClass() {
        this.connector.start(this.sourceProperties);
        Assertions.assertEquals(FileStreamSourceTask.class, (Object)this.connector.taskClass());
    }

    @Test
    public void testConnectorConfigsPropagateToTaskConfigs() {
        this.sourceProperties.put("transforms", "insert");
        this.connector.start(this.sourceProperties);
        List taskConfigs = this.connector.taskConfigs(1);
        Assertions.assertEquals((int)1, (int)taskConfigs.size());
        Assertions.assertEquals((Object)"insert", ((Map)taskConfigs.get(0)).get("transforms"));
    }

    @Test
    public void testValidConfigsAndDefaults() {
        AbstractConfig config = new AbstractConfig(FileStreamSourceConnector.CONFIG_DEF, this.sourceProperties);
        Assertions.assertEquals((Object)SINGLE_TOPIC, (Object)config.getString("topic"));
        Assertions.assertEquals((int)2000, (Integer)config.getInt("batch.size"));
    }

    @Test
    public void testMissingTopic() {
        this.sourceProperties.remove("topic");
        Assertions.assertThrows(ConfigException.class, () -> new AbstractConfig(FileStreamSourceConnector.CONFIG_DEF, this.sourceProperties));
    }

    @Test
    public void testBlankTopic() {
        this.sourceProperties.put("topic", "   ");
        Assertions.assertThrows(ConfigException.class, () -> new AbstractConfig(FileStreamSourceConnector.CONFIG_DEF, this.sourceProperties));
    }

    @Test
    public void testInvalidBatchSize() {
        this.sourceProperties.put("batch.size", "abcd");
        Assertions.assertThrows(ConfigException.class, () -> new AbstractConfig(FileStreamSourceConnector.CONFIG_DEF, this.sourceProperties));
    }

    @Test
    public void testAlterOffsetsStdin() {
        this.sourceProperties.remove("file");
        Map<Map<String, String>, Map<String, Long>> offsets = Collections.singletonMap(Collections.singletonMap("filename", FILENAME), Collections.singletonMap("position", 0L));
        Assertions.assertThrows(ConnectException.class, () -> this.connector.alterOffsets(this.sourceProperties, offsets));
    }

    @Test
    public void testAlterOffsetsIncorrectPartitionKey() {
        Assertions.assertThrows(ConnectException.class, () -> this.connector.alterOffsets(this.sourceProperties, Collections.singletonMap(Collections.singletonMap("other_partition_key", FILENAME), Collections.singletonMap("position", 0L))));
        Assertions.assertThrows(ConnectException.class, () -> this.connector.alterOffsets(this.sourceProperties, Collections.singletonMap(null, Collections.singletonMap("position", 0L))));
    }

    @Test
    public void testAlterOffsetsMultiplePartitions() {
        HashMap<Map<String, String>, Map<String, Long>> offsets = new HashMap<Map<String, String>, Map<String, Long>>();
        offsets.put(Collections.singletonMap("filename", FILENAME), Collections.singletonMap("position", 0L));
        offsets.put(Collections.singletonMap("filename", "/someotherfilename"), null);
        Assertions.assertTrue((boolean)this.connector.alterOffsets(this.sourceProperties, offsets));
    }

    @Test
    public void testAlterOffsetsIncorrectOffsetKey() {
        Map<Map<String, String>, Map<String, Long>> offsets = Collections.singletonMap(Collections.singletonMap("filename", FILENAME), Collections.singletonMap("other_offset_key", 0L));
        Assertions.assertThrows(ConnectException.class, () -> this.connector.alterOffsets(this.sourceProperties, offsets));
    }

    @Test
    public void testAlterOffsetsOffsetPositionValues() {
        Function<Object, Boolean> alterOffsets = offset -> this.connector.alterOffsets(this.sourceProperties, Collections.singletonMap(Collections.singletonMap("filename", FILENAME), Collections.singletonMap("position", offset)));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("nan"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(null));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(new Object()));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(3.14));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(-420));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("-420"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(10));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply("10"));
        Assertions.assertThrows(ConnectException.class, () -> alterOffsets.apply(-10L));
        Assertions.assertTrue(() -> (Boolean)alterOffsets.apply(10L));
    }

    @Test
    public void testSuccessfulAlterOffsets() {
        Map<Map<String, String>, Map<String, Long>> offsets = Collections.singletonMap(Collections.singletonMap("filename", FILENAME), Collections.singletonMap("position", 0L));
        Assertions.assertTrue((boolean)this.connector.alterOffsets(this.sourceProperties, offsets));
        Assertions.assertTrue((boolean)this.connector.alterOffsets(this.sourceProperties, new HashMap()));
    }

    @Test
    public void testAlterOffsetsTombstones() {
        Function<Map, Boolean> alterOffsets = partition -> this.connector.alterOffsets(this.sourceProperties, Collections.singletonMap(partition, null));
        Assertions.assertTrue((boolean)alterOffsets.apply(null));
        Assertions.assertTrue((boolean)alterOffsets.apply(Collections.emptyMap()));
        Assertions.assertTrue((boolean)alterOffsets.apply(Collections.singletonMap("filename", FILENAME)));
        Assertions.assertTrue((boolean)alterOffsets.apply(Collections.singletonMap("filename", "/someotherfilename")));
        Assertions.assertTrue((boolean)alterOffsets.apply(Collections.singletonMap("garbage_partition_key", "garbage_partition_value")));
    }
}

