/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.header;

import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeader;
import org.apache.kafka.connect.header.Header;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectHeaderTest {
    private String key;
    private ConnectHeader header;

    @BeforeEach
    public void beforeEach() {
        this.key = "key";
        this.withString("value");
    }

    protected Header withValue(Schema schema, Object value) {
        this.header = new ConnectHeader(this.key, new SchemaAndValue(schema, value));
        return this.header;
    }

    protected Header withString(String value) {
        return this.withValue(Schema.STRING_SCHEMA, value);
    }

    @Test
    public void shouldAllowNullValues() {
        this.withValue(Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void shouldAllowNullSchema() {
        this.withValue(null, null);
        Assertions.assertNull((Object)this.header.schema());
        Assertions.assertNull((Object)this.header.value());
        String value = "non-null value";
        this.withValue(null, value);
        Assertions.assertNull((Object)this.header.schema());
        Assertions.assertSame((Object)value, (Object)this.header.value());
    }

    @Test
    public void shouldAllowNonNullValue() {
        String value = "non-null value";
        this.withValue(Schema.STRING_SCHEMA, value);
        Assertions.assertSame((Object)Schema.STRING_SCHEMA, (Object)this.header.schema());
        Assertions.assertEquals((Object)value, (Object)this.header.value());
        this.withValue(Schema.BOOLEAN_SCHEMA, true);
        Assertions.assertSame((Object)Schema.BOOLEAN_SCHEMA, (Object)this.header.schema());
        Assertions.assertEquals((Object)true, (Object)this.header.value());
    }

    @Test
    public void shouldGetSchemaFromStruct() {
        Schema schema = SchemaBuilder.struct().field("foo", Schema.STRING_SCHEMA).field("bar", Schema.INT32_SCHEMA).build();
        Struct value = new Struct(schema);
        value.put("foo", (Object)"value");
        value.put("bar", (Object)100);
        this.withValue(null, value);
        Assertions.assertSame((Object)schema, (Object)this.header.schema());
        Assertions.assertSame((Object)value, (Object)this.header.value());
    }

    @Test
    public void shouldSatisfyEquals() {
        String value = "non-null value";
        Header h1 = this.withValue(Schema.STRING_SCHEMA, value);
        Assertions.assertSame((Object)Schema.STRING_SCHEMA, (Object)this.header.schema());
        Assertions.assertEquals((Object)value, (Object)this.header.value());
        Header h2 = this.withValue(Schema.STRING_SCHEMA, value);
        Assertions.assertEquals((Object)h1, (Object)h2);
        Assertions.assertEquals((int)h1.hashCode(), (int)h2.hashCode());
        Header h3 = this.withValue(Schema.INT8_SCHEMA, 100);
        Assertions.assertNotEquals((Object)h3, (Object)h2);
    }
}

