/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)MapRSecurityUtil.class.getName());
    private static String authMethod = "not-defined";
    private static String mapRHome = null;

    private MapRSecurityUtil() {
    }

    public static boolean isMapRSecurityEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "maprsasl".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("secure=true") && !MapRSecurityUtil.mapRClusterConfContains("kerberosEnable=true") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static boolean isKerberosEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "kerberos".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("kerberosEnable=true") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static boolean isAuthMethodSet() {
        return !"not-defined".equals(authMethod);
    }

    public static boolean isCustomSecurityEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "custom".equals(authMethod);
        }
        return MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static String getAuthMethod() {
        if (MapRSecurityUtil.isMapRSecurityEnabled()) {
            return "maprsasl";
        }
        if (MapRSecurityUtil.isKerberosEnabled()) {
            return "kerberos";
        }
        if (MapRSecurityUtil.isCustomSecurityEnabled()) {
            return "custom";
        }
        if (MapRSecurityUtil.isNoSecurity()) {
            return "none";
        }
        LOG.warn("Authentication method is not defined");
        return "";
    }

    public static boolean isNoSecurity() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "none".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("secure=false") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    private static boolean mapRClusterConfContains(String value) {
        String path = MapRSecurityUtil.getMapRHome() + "/conf/mapr-clusters.conf";
        if (MapRSecurityUtil.exists(path)) {
            return MapRSecurityUtil.readFile(path).contains(value);
        }
        LOG.warn(String.format("File %s does not exists", path));
        return false;
    }

    private static boolean isCustomSecureFlagExists() {
        return MapRSecurityUtil.exists(MapRSecurityUtil.getMapRHome() + "/conf/.customSecure");
    }

    public static String findMapRHome() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOG.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOG.warn("System property mapr.home.dir is null");
                maprHome = SystemUtils.IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOG.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }

    public static boolean isClusterAdminProcess() {
        String currentUser = System.getProperty("user.name");
        String clusterAdmin = MapRSecurityUtil.findAdminUser();
        if (currentUser != null && !currentUser.isBlank() && clusterAdmin != null && !clusterAdmin.isBlank()) {
            return currentUser.equals(clusterAdmin);
        }
        return false;
    }

    public static String findAdminUser() {
        String string;
        String pathToDaemonConf = MapRSecurityUtil.findMapRHome() + File.separator + "conf" + File.separator + "daemon.conf";
        FileInputStream is = new FileInputStream(pathToDaemonConf);
        try {
            Properties properties = new Properties();
            properties.load(is);
            string = properties.getProperty("mapr.daemon.user");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.info(e.toString());
                return "";
            }
        }
        ((InputStream)is).close();
        return string;
    }

    public static String findAdminGroup() {
        String string;
        String pathToDaemonConf = MapRSecurityUtil.findMapRHome() + File.separator + "conf" + File.separator + "daemon.conf";
        FileInputStream is = new FileInputStream(pathToDaemonConf);
        try {
            Properties properties = new Properties();
            properties.load(is);
            string = properties.getProperty("mapr.daemon.group");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.info(e.toString());
                return "";
            }
        }
        ((InputStream)is).close();
        return string;
    }

    public static String getMapRHome() {
        if (mapRHome == null) {
            mapRHome = MapRSecurityUtil.findMapRHome();
        }
        return mapRHome;
    }

    private static boolean exists(String filePath) {
        return new File(filePath).exists();
    }

    private static String readFile(String filePath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            LOG.error(e.toString());
        }
        return content;
    }
}

