/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.upgrade.acid;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.upgrade.acid.UpgradeTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUpgradeTool {
    private static final Logger LOG = LoggerFactory.getLogger(TestUpgradeTool.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestUpgradeTool.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TestName testName = new TestName();
    private HiveConf hiveConf;
    private Driver d;

    private String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    @Ignore
    public void testUpgrade() throws Exception {
        int[][] data = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        int[][] dataPart = new int[][]{{1, 2, 10}, {3, 4, 11}, {5, 6, 12}};
        this.runStatementOnDriver("drop table if exists TAcid");
        this.runStatementOnDriver("drop table if exists TAcidPart");
        this.runStatementOnDriver("drop table if exists TFlat");
        this.runStatementOnDriver("drop table if exists TFlatText");
        this.runStatementOnDriver("create table TAcid (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table TAcidPart (a int, b int) partitioned by (p tinyint)  clustered by (b) into 2 buckets  stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table TFlat (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("create table TFlatText (a int, b int) stored as textfile tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into TAcid" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("update TAcid set a = 1 where b = 2");
        this.runStatementOnDriver("insert into TFlat" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("insert into TFlatText" + TestUpgradeTool.makeValuesClause(data));
        this.runStatementOnDriver("insert into TAcidPart partition(p)" + TestUpgradeTool.makeValuesClause(dataPart));
        this.runStatementOnDriver("update TAcidPart set a = 1 where b = 2 and p = 10");
        String[] args = new String[]{"-location", this.getTestDataDir(), "-preUpgrade", "-execute"};
        UpgradeTool.callback = new UpgradeTool.Callback(){

            void onWaitForCompaction() throws MetaException {
                TestUpgradeTool.runWorker(TestUpgradeTool.this.hiveConf);
            }
        };
        UpgradeTool.pollIntervalMs = 1;
        UpgradeTool.hiveConf = this.hiveConf;
        UpgradeTool.main((String[])args);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)resp.getCompactsSize());
        for (ShowCompactResponseElement e : resp.getCompacts()) {
            Assert.assertEquals((String)e.toString(), (Object)"ready for cleaning", (Object)e.getState());
        }
        String[] args2 = new String[]{"-location", this.getTestDataDir(), "-postUpgrade"};
        UpgradeTool.main((String[])args2);
    }

    @Test
    @Ignore
    public void testPostUpgrade() throws Exception {
        int[][] dataPart = new int[][]{{1, 2, 10}, {3, 4, 11}, {5, 6, 12}};
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "dynamic");
        this.runStatementOnDriver("drop table if exists TAcid");
        this.runStatementOnDriver("drop table if exists TAcidPart");
        this.runStatementOnDriver("drop table if exists TFlat");
        this.runStatementOnDriver("drop table if exists TFlatText");
        this.runStatementOnDriver("create table TAcid (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table TAcidPart (a int, b int) partitioned by (p int)  clustered by (b) into 2 buckets  stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into TAcidPart partition(p)" + TestUpgradeTool.makeValuesClause(dataPart));
        Hive db = Hive.get((HiveConf)this.hiveConf);
        Table tacid = db.getTable("default", "tacid");
        Assert.assertEquals((String)"Expected TAcid to become full acid", (Object)false, (Object)AcidUtils.isAcidTable((Table)tacid));
        Table tacidpart = db.getTable("default", "tacidpart");
        Assert.assertEquals((String)"Expected TAcidPart to become full acid", (Object)false, (Object)AcidUtils.isAcidTable((Table)tacidpart));
        String[] args2 = new String[]{"-location", this.getTestDataDir(), "-postUpgrade", "-execute"};
        UpgradeTool.isTestMode = true;
        UpgradeTool.hiveConf = this.hiveConf;
        UpgradeTool.main((String[])args2);
        tacid = db.getTable("default", "tacid");
        Assert.assertEquals((String)"Expected TAcid to become full acid", (Object)true, (Object)AcidUtils.isAcidTable((Table)tacid));
        tacidpart = db.getTable("default", "tacidpart");
        Assert.assertEquals((String)"Expected TAcidPart to become full acid", (Object)true, (Object)AcidUtils.isAcidTable((Table)tacidpart));
    }

    private static void runWorker(HiveConf hiveConf) throws MetaException {
        AtomicBoolean stop = new AtomicBoolean(true);
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(hiveConf);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
    }

    private static String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder(" values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private List<String> runStatementOnDriver(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpInternal();
    }

    private void initHiveConf() {
        this.hiveConf = new HiveConf(this.getClass());
    }

    private void setUpInternal() throws Exception {
        this.initHiveConf();
        TxnDbUtil.cleanDb((HiveConf)this.hiveConf);
        FileUtils.deleteDirectory((File)new File(this.getTestDataDir()));
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.hiveConf.set("mapred.local.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "local");
        this.hiveConf.set("mapred.system.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "system");
        this.hiveConf.set("mapreduce.jobtracker.staging.root.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "staging");
        this.hiveConf.set("mapred.temp.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "temp");
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, this.getWarehouseDir());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEINPUTFORMAT, HiveInputFormat.class.getName());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVESTATSCOLAUTOGATHER, false);
        this.hiveConf.set("fs.defaultFS", "file:///");
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        TxnDbUtil.prepDb((HiveConf)this.hiveConf);
        File f = new File(this.getWarehouseDir());
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(this.getWarehouseDir()).mkdirs()) {
            throw new RuntimeException("Could not create " + this.getWarehouseDir());
        }
        SessionState ss = SessionState.start((HiveConf)this.hiveConf);
        ss.applyAuthorizationPolicy();
        this.d = new Driver(new QueryState(this.hiveConf), null);
        this.d.setMaxRows(10000);
    }

    private String getWarehouseDir() {
        return this.getTestDataDir() + "/warehouse";
    }

    @After
    public void tearDown() throws Exception {
        if (this.d != null) {
            this.d.close();
            this.d.destroy();
            this.d = null;
        }
    }
}

