/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmokeTest {
    private static final Logger LOG = LoggerFactory.getLogger(SmokeTest.class);
    private static final String dbName = "internal_smoke_test";
    private static final String tableName = "internal_smoke_test_table";
    private static final String partValue = "internal_smoke_test_val1";
    private static Configuration conf;

    private SmokeTest() {
    }

    private void runTest(IMetaStoreClient client) throws TException {
        LOG.info("Starting smoke test");
        File dbDir = new File(System.getProperty("java.io.tmpdir"), dbName);
        if (!dbDir.mkdir()) {
            throw new RuntimeException("Unable to create direcotory " + dbDir.getAbsolutePath());
        }
        dbDir.deleteOnExit();
        LOG.info("Going to create database internal_smoke_test");
        Database db = new DatabaseBuilder().setName(dbName).setLocation(dbDir.getAbsolutePath()).create(client, conf);
        LOG.info("Going to create table internal_smoke_test_table");
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("col1", "int")).addCol("col2", "timestamp")).addPartCol("pcol1", "string").create(client, conf);
        LOG.info("Going to create partition with value internal_smoke_test_val1");
        Partition part = new PartitionBuilder().inTable(table).addValue("val1").addToTable(client, conf);
        LOG.info("Going to list the partitions");
        List<Partition> parts = client.listPartitions(dbName, tableName, (short)-1);
        LOG.info("Fetched: { " + parts.toString() + "}");
        LOG.info("Going to drop database");
        client.dropDatabase(dbName, true, false, true);
        LOG.info("Completed smoke test");
    }

    public static void main(String[] args) throws Exception {
        SmokeTest test = new SmokeTest();
        conf = MetastoreConf.newMetastoreConf();
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        test.runTest(client);
    }
}

