/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestGetTableMeta
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "testpartdb";
    private static final String TABLE_NAME = "testparttable";
    private List<TableMeta> expectedMetas = null;

    public TestGetTableMeta(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase("testpartdb_one", true, true, true);
        this.client.dropDatabase("testpartdb_two", true, true, true);
        this.metaStore.cleanWarehouseDirs();
        this.expectedMetas = new ArrayList<TableMeta>();
        String dbName = "testpartdb_one";
        this.createDB(dbName);
        this.expectedMetas.add(this.createTestTable(dbName, "testparttable_one", TableType.EXTERNAL_TABLE));
        this.expectedMetas.add(this.createTestTable(dbName, TABLE_NAME, TableType.MANAGED_TABLE, "cmT"));
        this.expectedMetas.add(this.createTestTable(dbName, "vtestparttable", TableType.VIRTUAL_VIEW));
        dbName = "testpartdb_two";
        this.createDB(dbName);
        this.expectedMetas.add(this.createTestTable(dbName, "testparttable_one", TableType.MANAGED_TABLE));
        this.expectedMetas.add(this.createTestTable(dbName, "vtestparttable", TableType.MATERIALIZED_VIEW, ""));
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createTable(String dbName, String tableName, TableType type) throws Exception {
        TableBuilder builder = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).setType(type.name());
        Table table = builder.build(this.metaStore.getConf());
        if (type == TableType.MATERIALIZED_VIEW) {
            CreationMetadata cm = new CreationMetadata(MetaStoreUtils.getDefaultCatalog((Configuration)this.metaStore.getConf()), dbName, tableName, (Set)ImmutableSet.of());
            table.setCreationMetadata(cm);
        }
        if (type == TableType.EXTERNAL_TABLE) {
            table.getParameters().put("EXTERNAL", "true");
        }
        return table;
    }

    private TableMeta createTestTable(String dbName, String tableName, TableType type, String comment) throws Exception {
        Table table = this.createTable(dbName, tableName, type);
        table.getParameters().put("comment", comment);
        this.client.createTable(table);
        TableMeta tableMeta = new TableMeta(dbName, tableName, type.name());
        tableMeta.setComments(comment);
        return tableMeta;
    }

    private TableMeta createTestTable(String dbName, String tableName, TableType type) throws Exception {
        Table table = this.createTable(dbName, tableName, type);
        this.client.createTable(table);
        return new TableMeta(dbName, tableName, type.name());
    }

    private void assertTableMetas(int[] expected, List<TableMeta> actualTableMetas) {
        this.assertTableMetas(this.expectedMetas, actualTableMetas, expected);
    }

    private void assertTableMetas(List<TableMeta> actual, int ... expected) {
        this.assertTableMetas(this.expectedMetas, actual, expected);
    }

    private void assertTableMetas(List<TableMeta> fullExpected, List<TableMeta> actual, int ... expected) {
        Assert.assertEquals((String)("Expected " + expected.length + " but have " + actual.size() + " tableMeta(s)"), (long)expected.length, (long)actual.size());
        HashSet<TableMeta> metas = new HashSet<TableMeta>(actual);
        for (int i : expected) {
            Assert.assertTrue((String)("Missing " + fullExpected.get(i)), (boolean)metas.remove(fullExpected.get(i)));
        }
        Assert.assertTrue((String)("Unexpected tableMeta(s): " + metas), (boolean)metas.isEmpty());
    }

    @Test
    public void testGetTableMeta() throws Exception {
        List tableMetas = this.client.getTableMeta("asdf", "qwerty", (List)Lists.newArrayList((Object[])new String[]{"zxcv"}));
        this.assertTableMetas(new int[0], tableMetas);
        tableMetas = this.client.getTableMeta("testpartdb_two", "vtestparttable", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{4}, tableMetas);
        tableMetas = this.client.getTableMeta("*", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("***", "**", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("*one", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2}, tableMetas);
        tableMetas = this.client.getTableMeta("*one*", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2}, tableMetas);
        tableMetas = this.client.getTableMeta("testpartdb_two", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("testpartdb_two*", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("testpartdb*", "*", (List)Lists.newArrayList((Object[])new String[]{TableType.EXTERNAL_TABLE.name()}));
        this.assertTableMetas(new int[]{0}, tableMetas);
        tableMetas = this.client.getTableMeta("testpartdb*", "*", (List)Lists.newArrayList((Object[])new String[]{TableType.EXTERNAL_TABLE.name(), TableType.MATERIALIZED_VIEW.name()}));
        this.assertTableMetas(new int[]{0, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("*one", "*", (List)Lists.newArrayList((Object[])new String[]{"*TABLE"}));
        this.assertTableMetas(new int[0], tableMetas);
        tableMetas = this.client.getTableMeta("*one", "*", (List)Lists.newArrayList((Object[])new String[]{"*"}));
        this.assertTableMetas(new int[0], tableMetas);
    }

    @Test
    public void testGetTableMetaCaseSensitive() throws Exception {
        List tableMetas = this.client.getTableMeta("*tWo", "tEsT*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{3}, tableMetas);
        tableMetas = this.client.getTableMeta("*", "*", (List)Lists.newArrayList((Object[])new String[]{"mAnAGeD_tABlE"}));
        this.assertTableMetas(new int[0], tableMetas);
    }

    @Test
    public void testGetTableMetaNullOrEmptyDb() throws Exception {
        List tableMetas = this.client.getTableMeta(null, "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[0], tableMetas);
    }

    @Test
    public void testGetTableMetaNullOrEmptyTbl() throws Exception {
        List tableMetas = this.client.getTableMeta("*", null, (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("*", "", (List)Lists.newArrayList());
        this.assertTableMetas(new int[0], tableMetas);
    }

    @Test
    public void testGetTableMetaNullOrEmptyTypes() throws Exception {
        List tableMetas = this.client.getTableMeta("*", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
        tableMetas = this.client.getTableMeta("*", "*", (List)Lists.newArrayList((Object[])new String[]{""}));
        this.assertTableMetas(new int[0], tableMetas);
        tableMetas = this.client.getTableMeta("*", "*", null);
        this.assertTableMetas(new int[]{0, 1, 2, 3, 4}, tableMetas);
    }

    @Test
    public void testGetTableMetaNullNoDbNoTbl() throws Exception {
        this.client.dropDatabase("testpartdb_one", true, true, true);
        this.client.dropDatabase("testpartdb_two", true, true, true);
        List tableMetas = this.client.getTableMeta("*", "*", (List)Lists.newArrayList());
        this.assertTableMetas(new int[0], tableMetas);
    }

    @Test
    public void tablesInDifferentCatalog() throws TException {
        String catName = "get_table_meta_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "db9";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String[] tableNames = new String[]{"table_in_other_catalog_1", "table_in_other_catalog_2", "random_name"};
        ArrayList<TableMeta> expected = new ArrayList<TableMeta>(tableNames.length);
        for (int i = 0; i < tableNames.length; ++i) {
            this.client.createTable(((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("id", "int")).addCol("name", "string")).build(this.metaStore.getConf()));
            expected.add(new TableMeta(dbName, tableNames[i], TableType.MANAGED_TABLE.name()));
        }
        List<String> types = Collections.singletonList(TableType.MANAGED_TABLE.name());
        List actual = this.client.getTableMeta(catName, dbName, "*", types);
        this.assertTableMetas(expected, actual, 0, 1, 2);
        actual = this.client.getTableMeta(catName, "*", "table_*", types);
        this.assertTableMetas(expected, actual, 0, 1);
        actual = this.client.getTableMeta(dbName, "table_in_other_catalog_*", types);
        this.assertTableMetas(expected, actual, new int[0]);
    }

    @Test
    public void noSuchCatalog() throws TException {
        List tableMetas = this.client.getTableMeta("nosuchcatalog", "*", "*", (List)Lists.newArrayList());
        Assert.assertEquals((long)0L, (long)tableMetas.size());
    }

    @Test
    public void catalogPatternsDontWork() throws TException {
        List tableMetas = this.client.getTableMeta("h*", "*", "*", (List)Lists.newArrayList());
        Assert.assertEquals((long)0L, (long)tableMetas.size());
    }
}

