/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestCatalogCaching {
    private static final String CAT1_NAME = "cat1";
    private static final String CAT2_NAME = "cat2";
    private ObjectStore objectStore;
    private Configuration conf;
    private CachedStore cachedStore;

    @Before
    public void createObjectStore() throws MetaException, InvalidOperationException {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)new Warehouse(this.conf));
        Catalog cat1 = new CatalogBuilder().setName(CAT1_NAME).setLocation("/tmp/cat1").build();
        this.objectStore.createCatalog(cat1);
        Catalog cat2 = new CatalogBuilder().setName(CAT2_NAME).setLocation("/tmp/cat2").build();
        this.objectStore.createCatalog(cat2);
    }

    @After
    public void clearCatalogCache() throws MetaException, NoSuchObjectException {
        List catalogs = this.objectStore.getCatalogs();
        for (String catalog : catalogs) {
            this.objectStore.dropCatalog(catalog);
        }
    }

    @Test
    public void defaultHiveOnly() throws Exception {
        this.cachedStore = new CachedStore();
        this.cachedStore.setConf(this.conf);
        CachedStore.stopCacheUpdateService((long)1L);
        this.cachedStore.resetCatalogCache();
        CachedStore.prewarm((RawStore)this.objectStore);
        List cachedCatalogs = this.cachedStore.getCatalogs();
        Assert.assertEquals((long)1L, (long)cachedCatalogs.size());
        Assert.assertEquals((Object)"hive", cachedCatalogs.get(0));
    }

    @Test
    public void cacheAll() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        MetastoreConf.setVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOGS_TO_CACHE, (String)"");
        this.cachedStore = new CachedStore();
        this.cachedStore.setConf(newConf);
        CachedStore.stopCacheUpdateService((long)1L);
        this.objectStore.setConf(newConf);
        this.cachedStore.resetCatalogCache();
        CachedStore.prewarm((RawStore)this.objectStore);
        List cachedCatalogs = this.cachedStore.getCatalogs();
        Assert.assertEquals((long)3L, (long)cachedCatalogs.size());
        cachedCatalogs.sort(Comparator.naturalOrder());
        Assert.assertEquals((Object)CAT1_NAME, cachedCatalogs.get(0));
        Assert.assertEquals((Object)CAT2_NAME, cachedCatalogs.get(1));
        Assert.assertEquals((Object)"hive", cachedCatalogs.get(2));
    }

    @Test
    public void cacheSome() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        MetastoreConf.setVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOGS_TO_CACHE, (String)"cat1,cat2");
        this.cachedStore = new CachedStore();
        this.cachedStore.setConf(newConf);
        CachedStore.stopCacheUpdateService((long)1L);
        this.objectStore.setConf(newConf);
        this.cachedStore.resetCatalogCache();
        CachedStore.prewarm((RawStore)this.objectStore);
        List cachedCatalogs = this.cachedStore.getCatalogs();
        Assert.assertEquals((long)2L, (long)cachedCatalogs.size());
        cachedCatalogs.sort(Comparator.naturalOrder());
        Assert.assertEquals((Object)CAT1_NAME, cachedCatalogs.get(0));
        Assert.assertEquals((Object)CAT2_NAME, cachedCatalogs.get(1));
    }
}

