/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.BatchUpdateException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOException;
import javax.jdo.JDOUserException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MetastoreCheckinTest.class})
public class TestRetriesInRetryingHMSHandler {
    private static Configuration conf;
    private static final int RETRY_ATTEMPTS = 3;

    @BeforeClass
    public static void setup() throws IOException {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS, (long)3L);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_FORCE_RELOAD_CONF, (boolean)false);
    }

    @Test
    public void testRetryInit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)conf);
        ((IHMSHandler)Mockito.doThrow(JDOException.class).doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)2))).init();
    }

    @Test
    public void testNoRetryInit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)conf);
        ((IHMSHandler)Mockito.doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)1))).init();
    }

    @Test(expected=MetaException.class)
    public void testRetriesLimit() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)conf);
        ((IHMSHandler)Mockito.doThrow(JDOException.class).when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)3))).init();
    }

    @Test
    public void testWrappedMetaExceptionRetry() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)conf);
        MetaException me = new MetaException("Dummy exception");
        me.initCause((Throwable)new JDOException());
        InvocationTargetException ex = new InvocationTargetException(me);
        ((IHMSHandler)Mockito.doThrow((Throwable)me).doNothing().when((Object)mockBaseHandler)).init();
        RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)mockBaseHandler, (boolean)false);
        ((IHMSHandler)Mockito.verify((Object)mockBaseHandler, (VerificationMode)Mockito.times((int)2))).init();
    }

    @Test
    public void testGetRootCauseInMetaException() throws MetaException {
        IHMSHandler mockBaseHandler = (IHMSHandler)Mockito.mock(IHMSHandler.class);
        Mockito.when((Object)mockBaseHandler.getConf()).thenReturn((Object)conf);
        SQLIntegrityConstraintViolationException sqlException = new SQLIntegrityConstraintViolationException("Cannot delete or update a parent row");
        BatchUpdateException updateException = new BatchUpdateException(sqlException);
        NucleusDataStoreException nucleusException = new NucleusDataStoreException("Clear request failed: DELETE FROM `PARTITION_PARAMS` WHERE `PART_ID`=?", (Throwable)updateException);
        JDOUserException jdoException = new JDOUserException("One or more instances could not be deleted", (Throwable)nucleusException);
        MetaException me = new MetaException("Dummy exception");
        me.initCause((Throwable)jdoException);
        InvocationTargetException ex = new InvocationTargetException(me);
        ((IHMSHandler)Mockito.doThrow((Throwable)me).when((Object)mockBaseHandler)).getMS();
        IHMSHandler retryingHandler = RetryingHMSHandler.getProxy((Configuration)conf, (IHMSHandler)mockBaseHandler, (boolean)false);
        try {
            retryingHandler.getMS();
            Assert.fail((String)"should throw the mocked MetaException");
        }
        catch (MetaException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("java.sql.SQLIntegrityConstraintViolationException"));
        }
    }
}

