/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreSchemaFactory {
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
    }

    @Test
    public void testDefaultConfig() {
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)this.conf);
        Assert.assertNotNull((Object)metastoreSchemaInfo);
    }

    @Test
    public void testWithConfigSet() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEMA_INFO_CLASS, (String)MetaStoreSchemaInfo.class.getCanonicalName());
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)this.conf);
        Assert.assertNotNull((Object)metastoreSchemaInfo);
        Assert.assertTrue((String)"Unexpected instance type of the class MetaStoreSchemaInfo", (boolean)(metastoreSchemaInfo instanceof MetaStoreSchemaInfo));
    }

    @Test
    public void testConstructor() {
        String className = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEMA_INFO_CLASS, (String)MetaStoreSchemaInfo.class.getCanonicalName());
        Class clasz = null;
        try {
            clasz = this.conf.getClassByName(className);
            clasz.getConstructor(String.class, String.class);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidClassName() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEMA_INFO_CLASS, (String)"invalid.class.name");
        MetaStoreSchemaInfoFactory.get((Configuration)this.conf);
    }
}

