/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestHiveMetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(TestHiveMetaStore.class);
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    protected static boolean isThriftClient;
    private static final String TEST_DB1_NAME = "testdb1";
    private static final String TEST_DB2_NAME = "testdb2";
    private static final int DEFAULT_LIMIT_PARTITION_REQUEST = 100;

    protected abstract HiveMetaStoreClient createClient() throws Exception;

    @Before
    public void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        warehouse = new Warehouse(conf);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("hive.key1", "value1");
        conf.set("hive.key2", "http://www.example.com");
        conf.set("hive.key3", "");
        conf.set("hive.key4", "0");
        conf.set("datanucleus.autoCreateTables", "false");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL, (String)"no.such.class");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELETE_COLUMN_COMMENTS_FROM_PARTITION_OBJECT, (boolean)false);
    }

    @Test
    public void testNameMethods() {
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        spec.put("ds", "2008-07-01 14:13:12");
        spec.put("hr", "14");
        ArrayList vals = new ArrayList();
        vals.addAll(spec.values());
        String partName = "ds=2008-07-01 14%3A13%3A12/hr=14";
        try {
            List testVals = client.partitionNameToVals(partName);
            Assert.assertTrue((String)"Values from name are incorrect", (boolean)vals.equals(testVals));
            Map testSpec = client.partitionNameToSpec(partName);
            Assert.assertTrue((String)"Spec from name is incorrect", (boolean)spec.equals(testSpec));
            List emptyVals = client.partitionNameToVals("");
            Assert.assertTrue((String)"Values should be empty", (emptyVals.size() == 0 ? 1 : 0) != 0);
            Map emptySpec = client.partitionNameToSpec("");
            Assert.assertTrue((String)"Spec should be empty", (emptySpec.size() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testPartition() throws Exception {
        TestHiveMetaStore.partitionTester(client, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void partitionTester(HiveMetaStoreClient client, Configuration conf) throws Exception {
        try {
            String dbName = "compdb";
            String tblName = "comptbl";
            String typeName = "Person";
            List<String> vals = TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14");
            List<String> vals2 = TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15");
            List<String> vals3 = TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15");
            List<String> vals4 = TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151");
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
            Database db = client.getDatabase(dbName);
            Path dbPath = new Path(db.getLocationUri());
            FileSystem fs = FileSystem.get((URI)dbPath.toUri(), (Configuration)conf);
            client.dropType(typeName);
            Type typ1 = new Type();
            typ1.setName(typeName);
            typ1.setFields(new ArrayList(2));
            typ1.getFields().add(new FieldSchema("name", "string", ""));
            typ1.getFields().add(new FieldSchema("income", "int", ""));
            client.createType(typ1);
            List<String> skewedColValue = Collections.singletonList("1");
            Table tbl = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).setCols(typ1.getFields())).setNumBuckets(1)).addBucketCol("name")).addTableParam("test_param_1", "Use this for comments etc").addSerdeParam("serialization.format", "1")).addSkewedColName("name")).setSkewedColValues(Collections.singletonList(skewedColValue))).setSkewedColValueLocationMaps(Collections.singletonMap(skewedColValue, "location1"))).addPartCol("ds", "string").addPartCol("hr", "string").create((IMetaStoreClient)client, conf);
            if (isThriftClient) {
                tbl = client.getTable(dbName, tblName);
            }
            Partition part = TestHiveMetaStore.makePartitionObject(dbName, tblName, vals, tbl, "/part1");
            Partition part2 = TestHiveMetaStore.makePartitionObject(dbName, tblName, vals2, tbl, "/part2");
            Partition part3 = TestHiveMetaStore.makePartitionObject(dbName, tblName, vals3, tbl, "/part3");
            Partition part4 = TestHiveMetaStore.makePartitionObject(dbName, tblName, vals4, tbl, "/part4");
            boolean exceptionThrown = false;
            try {
                Partition partition = client.getPartition(dbName, tblName, vals);
            }
            catch (Exception e) {
                Assert.assertEquals((String)"partition should not have existed", NoSuchObjectException.class, e.getClass());
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"getPartition() should have thrown NoSuchObjectException", (boolean)exceptionThrown);
            Partition retp = client.add_partition(part);
            Assert.assertNotNull((String)("Unable to create partition " + part), (Object)retp);
            Partition retp2 = client.add_partition(part2);
            Assert.assertNotNull((String)("Unable to create partition " + part2), (Object)retp2);
            Partition retp3 = client.add_partition(part3);
            Assert.assertNotNull((String)("Unable to create partition " + part3), (Object)retp3);
            Partition retp4 = client.add_partition(part4);
            Assert.assertNotNull((String)("Unable to create partition " + part4), (Object)retp4);
            Partition part_get = client.getPartition(dbName, tblName, part.getValues());
            if (isThriftClient) {
                TestHiveMetaStore.adjust(client, part, dbName, tblName);
                TestHiveMetaStore.adjust(client, part2, dbName, tblName);
                TestHiveMetaStore.adjust(client, part3, dbName, tblName);
            }
            Assert.assertTrue((String)"Partitions are not same", (boolean)part.equals(part_get));
            List<String> vals6 = TestHiveMetaStore.makeVals("2016-02-22 00:00:00", "16");
            Partition part6 = TestHiveMetaStore.makePartitionObject(dbName, tblName, vals6, tbl, "/part5");
            part6.getSd().setCols(null);
            LOG.info("Creating partition will null field schema");
            client.add_partition(part6);
            LOG.info("Listing all partitions for table " + dbName + "." + tblName);
            List partitions = client.listPartitions(dbName, tblName, (short)-1);
            boolean foundPart = false;
            for (Partition p : partitions) {
                if (!p.getValues().equals(vals6)) continue;
                Assert.assertNull((Object)p.getSd().getCols());
                LOG.info("Found partition " + p + " having null field schema");
                foundPart = true;
            }
            Assert.assertTrue((boolean)foundPart);
            String partName = "ds=" + FileUtils.escapePathName((String)"2008-07-01 14:13:12") + "/hr=14";
            String part2Name = "ds=" + FileUtils.escapePathName((String)"2008-07-01 14:13:12") + "/hr=15";
            String part3Name = "ds=" + FileUtils.escapePathName((String)"2008-07-02 14:13:12") + "/hr=15";
            String part4Name = "ds=" + FileUtils.escapePathName((String)"2008-07-03 14:13:12") + "/hr=151";
            part_get = client.getPartition(dbName, tblName, partName);
            Assert.assertTrue((String)"Partitions are not the same", (boolean)part.equals(part_get));
            ArrayList<String> partialVals = new ArrayList<String>();
            partialVals.add(vals.get(0));
            HashSet<Partition> parts = new HashSet<Partition>();
            parts.add(part);
            parts.add(part2);
            List partial = client.listPartitions(dbName, tblName, partialVals, (short)-1);
            Assert.assertTrue((String)"Should have returned 2 partitions", (partial.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Not all parts returned", (boolean)partial.containsAll(parts));
            HashSet<CallSite> partNames = new HashSet<CallSite>();
            partNames.add((CallSite)((Object)partName));
            partNames.add((CallSite)((Object)part2Name));
            List partialNames = client.listPartitionNames(dbName, tblName, partialVals, (short)-1);
            Assert.assertTrue((String)"Should have returned 2 partition names", (partialNames.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Not all part names returned", (boolean)partialNames.containsAll(partNames));
            partNames.add((CallSite)((Object)part3Name));
            partNames.add((CallSite)((Object)part4Name));
            partialVals.clear();
            partialVals.add("");
            partialNames = client.listPartitionNames(dbName, tblName, partialVals, (short)-1);
            Assert.assertTrue((String)"Should have returned 5 partition names", (partialNames.size() == 5 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Not all part names returned", (boolean)partialNames.containsAll(partNames));
            parts.clear();
            parts.add(part2);
            parts.add(part3);
            partialVals.clear();
            partialVals.add("");
            partialVals.add(vals2.get(1));
            partial = client.listPartitions(dbName, tblName, partialVals, (short)-1);
            Assert.assertEquals((String)"Should have returned 2 partitions", (long)2L, (long)partial.size());
            Assert.assertTrue((String)"Not all parts returned", (boolean)partial.containsAll(parts));
            partNames.clear();
            partNames.add((CallSite)((Object)part2Name));
            partNames.add((CallSite)((Object)part3Name));
            partialNames = client.listPartitionNames(dbName, tblName, partialVals, (short)-1);
            Assert.assertEquals((String)"Should have returned 2 partition names", (long)2L, (long)partialNames.size());
            Assert.assertTrue((String)"Not all part names returned", (boolean)partialNames.containsAll(partNames));
            exceptionThrown = false;
            try {
                String badPartName = "ds=2008-07-01 14%3A13%3A12/hrs=14";
                client.getPartition(dbName, tblName, badPartName);
            }
            catch (NoSuchObjectException e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"Bad partition spec should have thrown an exception", (boolean)exceptionThrown);
            Path partPath = new Path(part.getSd().getLocation());
            Assert.assertTrue((boolean)fs.exists(partPath));
            client.dropPartition(dbName, tblName, part.getValues(), true);
            Assert.assertFalse((boolean)fs.exists(partPath));
            client.appendPartition(dbName, tblName, partName);
            Partition part5 = client.getPartition(dbName, tblName, part.getValues());
            Assert.assertTrue((String)"Append partition by name failed", (boolean)part5.getValues().equals(vals));
            Path part5Path = new Path(part5.getSd().getLocation());
            Assert.assertTrue((boolean)fs.exists(part5Path));
            Assert.assertTrue((String)"Drop partition by name failed", (boolean)client.dropPartition(dbName, tblName, partName, true));
            Assert.assertFalse((boolean)fs.exists(part5Path));
            retp = client.add_partition(part);
            Assert.assertNotNull((String)("Unable to create partition " + part), (Object)retp);
            List<String> mvals1 = TestHiveMetaStore.makeVals("2008-07-04 14:13:12", "14641");
            List<String> mvals2 = TestHiveMetaStore.makeVals("2008-07-04 14:13:12", "14642");
            List<String> mvals3 = TestHiveMetaStore.makeVals("2008-07-04 14:13:12", "14643");
            List<String> mvals4 = TestHiveMetaStore.makeVals("2008-07-04 14:13:12", "14643");
            List<String> mvals5 = TestHiveMetaStore.makeVals("2008-07-04 14:13:12", "14645");
            client.add_partitions(new ArrayList());
            Partition mpart1 = TestHiveMetaStore.makePartitionObject(dbName, tblName, mvals1, tbl, "/mpart1");
            Partition mpart2 = TestHiveMetaStore.makePartitionObject(dbName, tblName, mvals2, tbl, "/mpart2");
            Partition mpart3 = TestHiveMetaStore.makePartitionObject(dbName, tblName, mvals3, tbl, "/mpart3");
            client.add_partitions(Arrays.asList(mpart1, mpart2, mpart3));
            if (isThriftClient) {
                TestHiveMetaStore.adjust(client, mpart1, dbName, tblName);
                TestHiveMetaStore.adjust(client, mpart2, dbName, tblName);
                TestHiveMetaStore.adjust(client, mpart3, dbName, tblName);
            }
            TestHiveMetaStore.verifyPartitionsPublished(client, dbName, tblName, Arrays.asList(mvals1.get(0)), Arrays.asList(mpart1, mpart2, mpart3));
            Partition mpart4 = TestHiveMetaStore.makePartitionObject(dbName, tblName, mvals4, tbl, "/mpart4");
            Partition mpart5 = TestHiveMetaStore.makePartitionObject(dbName, tblName, mvals5, tbl, "/mpart5");
            Path mp5Path = new Path(mpart5.getSd().getLocation());
            warehouse.mkdirs(mp5Path);
            Assert.assertTrue((boolean)fs.exists(mp5Path));
            Exception savedException = null;
            try {
                client.add_partitions(Arrays.asList(mpart5, mpart4));
            }
            catch (Exception e) {
                try {
                    savedException = e;
                }
                catch (Throwable throwable) {
                    Assert.assertNotNull(savedException);
                    throw throwable;
                }
                Assert.assertNotNull((Object)savedException);
            }
            Assert.assertNotNull((Object)savedException);
            Assert.assertTrue((boolean)fs.exists(mp5Path));
            Assert.assertFalse((boolean)fs.exists(new Path(mpart4.getSd().getLocation())));
            client.add_partitions(Arrays.asList(mpart5));
            if (isThriftClient) {
                TestHiveMetaStore.adjust(client, mpart5, dbName, tblName);
            }
            TestHiveMetaStore.verifyPartitionsPublished(client, dbName, tblName, Arrays.asList(mvals1.get(0)), Arrays.asList(mpart1, mpart2, mpart3, mpart5));
            client.dropTable(dbName, tblName);
            client.dropType(typeName);
            tbl.setParameters(new HashMap());
            tbl.getParameters().put("EXTERNAL", "TRUE");
            client.createTable(tbl);
            retp = client.add_partition(part);
            Assert.assertTrue((boolean)fs.exists(partPath));
            client.dropPartition(dbName, tblName, part.getValues(), true);
            Assert.assertTrue((boolean)fs.exists(partPath));
            for (String tableName : client.getTables(dbName, "*")) {
                client.dropTable(dbName, tableName);
            }
            client.dropDatabase(dbName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testPartition() failed.");
            throw e;
        }
    }

    private static void verifyPartitionsPublished(HiveMetaStoreClient client, String dbName, String tblName, List<String> partialSpec, List<Partition> expectedPartitions) throws TException {
        List mpartial = client.listPartitions(dbName, tblName, partialSpec, (short)-1);
        Assert.assertEquals((String)("Should have returned " + expectedPartitions.size() + " partitions, returned " + mpartial.size()), (long)expectedPartitions.size(), (long)mpartial.size());
        Assert.assertTrue((String)"Not all parts returned", (boolean)mpartial.containsAll(expectedPartitions));
    }

    private static List<String> makeVals(String ds, String id) {
        ArrayList<String> vals4 = new ArrayList<String>(2);
        vals4 = new ArrayList(2);
        vals4.add(ds);
        vals4.add(id);
        return vals4;
    }

    private static Partition makePartitionObject(String dbName, String tblName, List<String> ptnVals, Table tbl, String ptnLocationSuffix) throws MetaException {
        Partition part4 = new Partition();
        part4.setDbName(dbName);
        part4.setTableName(tblName);
        part4.setValues(ptnVals);
        part4.setParameters(new HashMap());
        part4.setSd(tbl.getSd().deepCopy());
        part4.getSd().setSerdeInfo(tbl.getSd().getSerdeInfo().deepCopy());
        part4.getSd().setLocation(tbl.getSd().getLocation() + ptnLocationSuffix);
        MetaStoreUtils.updatePartitionStatsFast((Partition)part4, (Table)tbl, (Warehouse)warehouse, (boolean)false, (boolean)false, null, (boolean)true);
        return part4;
    }

    @Test
    public void testListPartitions() throws Throwable {
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        List partitions = client.listPartitions(dbName, tblName, (short)-1);
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() + " partitions"), (long)values.size(), (long)partitions.size());
        partitions = client.listPartitions(dbName, tblName, (short)(values.size() / 2));
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() / 2 + " partitions"), (long)(values.size() / 2), (long)partitions.size());
        partitions = client.listPartitions(dbName, tblName, (short)(values.size() * 2));
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() + " partitions"), (long)values.size(), (long)partitions.size());
        this.cleanUp(dbName, tblName, typeName);
    }

    @Test
    public void testListPartitionsWihtLimitEnabled() throws Throwable {
        short maxParts;
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (int i = 0; i < 101; ++i) {
            values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", Integer.toString(i)));
        }
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        try {
            maxParts = -1;
            List partitions = client.listPartitions(dbName, tblName, maxParts);
            Assert.fail((String)"should have thrown MetaException about partition limit");
        }
        catch (MetaException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            maxParts = 101;
            List partitions = client.listPartitions(dbName, tblName, maxParts);
            Assert.fail((String)"should have thrown MetaException about partition limit");
        }
        catch (MetaException e) {
            Assert.assertTrue((boolean)true);
        }
        maxParts = 50;
        List partitions = client.listPartitions(dbName, tblName, maxParts);
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)" should have returned 50 partitions", (long)maxParts, (long)partitions.size());
    }

    @Test
    public void testAlterTableCascade() throws Throwable {
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        Table tbl = client.getTable(dbName, tblName);
        List cols = tbl.getSd().getCols();
        cols.add(new FieldSchema("new_col", "string", ""));
        tbl.getSd().setCols(cols);
        client.alter_table(dbName, tblName, tbl, true);
        Table tbl2 = client.getTable(dbName, tblName);
        Assert.assertEquals((String)"Unexpected number of cols", (long)3L, (long)tbl2.getSd().getCols().size());
        Assert.assertEquals((String)"Unexpected column name", (Object)"new_col", (Object)((FieldSchema)tbl2.getSd().getCols().get(2)).getName());
        ArrayList<String> pvalues = new ArrayList<String>(2);
        pvalues.add("2008-07-01 14:13:12");
        pvalues.add("14");
        Partition partition = client.getPartition(dbName, tblName, pvalues);
        Assert.assertEquals((String)"Unexpected number of cols", (long)3L, (long)partition.getSd().getCols().size());
        Assert.assertEquals((String)"Unexpected column name", (Object)"new_col", (Object)((FieldSchema)partition.getSd().getCols().get(2)).getName());
        cols = tbl.getSd().getCols();
        cols.add(new FieldSchema("new_col2", "string", ""));
        tbl.getSd().setCols(cols);
        client.alter_table(dbName, tblName, tbl, false);
        tbl2 = client.getTable(dbName, tblName);
        Assert.assertEquals((String)"Unexpected number of cols", (long)4L, (long)tbl2.getSd().getCols().size());
        Assert.assertEquals((String)"Unexpected column name", (Object)"new_col2", (Object)((FieldSchema)tbl2.getSd().getCols().get(3)).getName());
        partition = client.getPartition(dbName, tblName, pvalues);
        Assert.assertEquals((String)"Unexpected number of cols", (long)3L, (long)partition.getSd().getCols().size());
    }

    @Test
    public void testListPartitionNames() throws Throwable {
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        List partitions = client.listPartitionNames(dbName, tblName, (short)-1);
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() + " partitions"), (long)values.size(), (long)partitions.size());
        partitions = client.listPartitionNames(dbName, tblName, (short)(values.size() / 2));
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() / 2 + " partitions"), (long)(values.size() / 2), (long)partitions.size());
        partitions = client.listPartitionNames(dbName, tblName, (short)(values.size() * 2));
        Assert.assertNotNull((String)"should have returned partitions", (Object)partitions);
        Assert.assertEquals((String)(" should have returned " + values.size() + " partitions"), (long)values.size(), (long)partitions.size());
        this.cleanUp(dbName, tblName, typeName);
    }

    @Test
    public void testDropTable() throws Throwable {
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        client.dropTable(dbName, tblName);
        client.dropType(typeName);
        boolean exceptionThrown = false;
        try {
            client.getTable(dbName, tblName);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"table should not have existed", NoSuchObjectException.class, e.getClass());
            exceptionThrown = true;
        }
        Assert.assertTrue((String)("Table " + tblName + " should have been dropped "), (boolean)exceptionThrown);
    }

    @Test
    public void testAlterViewParititon() throws Throwable {
        String dbName = "compdb";
        String tblName = "comptbl";
        String viewName = "compView";
        client.dropTable(dbName, tblName);
        TestHiveMetaStore.silentDropDatabase(dbName);
        new DatabaseBuilder().setName(dbName).setDescription("Alter Partition Test database").create((IMetaStoreClient)client, conf);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string")).addCol("income", "int")).create((IMetaStoreClient)client, conf);
        if (isThriftClient) {
            tbl = client.getTable(dbName, tblName);
        }
        ArrayList<FieldSchema> viewCols = new ArrayList<FieldSchema>(1);
        viewCols.add(new FieldSchema("income", "int", ""));
        ArrayList<FieldSchema> viewPartitionCols = new ArrayList<FieldSchema>(1);
        viewPartitionCols.add(new FieldSchema("name", "string", ""));
        Table view = new Table();
        view.setDbName(dbName);
        view.setTableName(viewName);
        view.setTableType(TableType.VIRTUAL_VIEW.name());
        view.setPartitionKeys(viewPartitionCols);
        view.setViewOriginalText("SELECT income, name FROM " + tblName);
        view.setViewExpandedText("SELECT `" + tblName + "`.`income`, `" + tblName + "`.`name` FROM `" + dbName + "`.`" + tblName + "`");
        view.setRewriteEnabled(false);
        StorageDescriptor viewSd = new StorageDescriptor();
        view.setSd(viewSd);
        viewSd.setCols(viewCols);
        viewSd.setCompressed(false);
        viewSd.setParameters(new HashMap());
        viewSd.setSerdeInfo(new SerDeInfo());
        viewSd.getSerdeInfo().setParameters(new HashMap());
        client.createTable(view);
        if (isThriftClient) {
            view = client.getTable(dbName, viewName);
        }
        ArrayList<String> vals = new ArrayList<String>(1);
        vals.add("abc");
        Partition part = new Partition();
        part.setDbName(dbName);
        part.setTableName(viewName);
        part.setValues(vals);
        part.setParameters(new HashMap());
        client.add_partition(part);
        Partition part2 = client.getPartition(dbName, viewName, part.getValues());
        part2.getParameters().put("a", "b");
        client.alter_partition(dbName, viewName, part2, null);
        Partition part3 = client.getPartition(dbName, viewName, part.getValues());
        Assert.assertEquals((String)"couldn't view alter partition", part3.getParameters().get("a"), (Object)"b");
        client.dropTable(dbName, viewName);
        client.dropTable(dbName, tblName);
        client.dropDatabase(dbName);
    }

    @Test
    public void testAlterPartition() throws Throwable {
        try {
            String dbName = "compdb";
            String tblName = "comptbl";
            ArrayList<String> vals = new ArrayList<String>(2);
            vals.add("2008-07-01");
            vals.add("14");
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).setDescription("Alter Partition Test database").create((IMetaStoreClient)client, conf);
            Table tbl = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string")).addCol("income", "int")).addTableParam("test_param_1", "Use this for comments etc").addBucketCol("name")).addSerdeParam("serialization.format", "1")).addPartCol("ds", "string").addPartCol("hr", "int").create((IMetaStoreClient)client, conf);
            if (isThriftClient) {
                tbl = client.getTable(dbName, tblName);
            }
            Partition part = new Partition();
            part.setDbName(dbName);
            part.setTableName(tblName);
            part.setValues(vals);
            part.setParameters(new HashMap());
            part.setSd(tbl.getSd());
            part.getSd().setSerdeInfo(tbl.getSd().getSerdeInfo());
            part.getSd().setLocation(tbl.getSd().getLocation() + "/part1");
            client.add_partition(part);
            Partition part2 = client.getPartition(dbName, tblName, part.getValues());
            part2.getParameters().put("retention", "10");
            part2.getSd().setNumBuckets(12);
            part2.getSd().getSerdeInfo().getParameters().put("abc", "1");
            client.alter_partition(dbName, tblName, part2, null);
            Partition part3 = client.getPartition(dbName, tblName, part.getValues());
            Assert.assertEquals((String)"couldn't alter partition", part3.getParameters().get("retention"), (Object)"10");
            Assert.assertEquals((String)"couldn't alter partition", part3.getSd().getSerdeInfo().getParameters().get("abc"), (Object)"1");
            Assert.assertEquals((String)"couldn't alter partition", (long)part3.getSd().getNumBuckets(), (long)12L);
            client.dropTable(dbName, tblName);
            client.dropDatabase(dbName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testPartition() failed.");
            throw e;
        }
    }

    @Test
    public void testRenamePartition() throws Throwable {
        try {
            String dbName = "compdb1";
            String tblName = "comptbl1";
            ArrayList<String> vals = new ArrayList<String>(2);
            vals.add("2011-07-11");
            vals.add("8");
            String part_path = "/ds=2011-07-11/hr=8";
            ArrayList<String> tmp_vals = new ArrayList<String>(2);
            tmp_vals.add("tmp_2011-07-11");
            tmp_vals.add("-8");
            String part2_path = "/ds=tmp_2011-07-11/hr=-8";
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).setDescription("Rename Partition Test database").create((IMetaStoreClient)client, conf);
            Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string")).addCol("income", "int")).addPartCol("ds", "string").addPartCol("hr", "int").create((IMetaStoreClient)client, conf);
            if (isThriftClient) {
                tbl = client.getTable(dbName, tblName);
            }
            Partition part = new Partition();
            part.setDbName(dbName);
            part.setTableName(tblName);
            part.setValues(vals);
            part.setParameters(new HashMap());
            part.setSd(tbl.getSd().deepCopy());
            part.getSd().setSerdeInfo(tbl.getSd().getSerdeInfo());
            part.getSd().setLocation(tbl.getSd().getLocation() + "/part1");
            part.getParameters().put("retention", "10");
            part.getSd().setNumBuckets(12);
            part.getSd().getSerdeInfo().getParameters().put("abc", "1");
            client.add_partition(part);
            part.setValues(tmp_vals);
            client.renamePartition(dbName, tblName, vals, part);
            boolean exceptionThrown = false;
            try {
                Partition partition = client.getPartition(dbName, tblName, vals);
            }
            catch (Exception e) {
                Assert.assertEquals((String)"partition should not have existed", NoSuchObjectException.class, e.getClass());
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"Expected NoSuchObjectException", (boolean)exceptionThrown);
            Partition part3 = client.getPartition(dbName, tblName, tmp_vals);
            Assert.assertEquals((String)"couldn't rename partition", part3.getParameters().get("retention"), (Object)"10");
            Assert.assertEquals((String)"couldn't rename partition", part3.getSd().getSerdeInfo().getParameters().get("abc"), (Object)"1");
            Assert.assertEquals((String)"couldn't rename partition", (long)part3.getSd().getNumBuckets(), (long)12L);
            Assert.assertEquals((String)"new partition sd matches", (Object)part3.getSd().getLocation(), (Object)(tbl.getSd().getLocation() + part2_path));
            part.setValues(vals);
            client.renamePartition(dbName, tblName, tmp_vals, part);
            exceptionThrown = false;
            try {
                Partition partition = client.getPartition(dbName, tblName, tmp_vals);
            }
            catch (Exception e) {
                Assert.assertEquals((String)"partition should not have existed", NoSuchObjectException.class, e.getClass());
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"Expected NoSuchObjectException", (boolean)exceptionThrown);
            part3 = client.getPartition(dbName, tblName, vals);
            Assert.assertEquals((String)"couldn't rename partition", part3.getParameters().get("retention"), (Object)"10");
            Assert.assertEquals((String)"couldn't rename partition", part3.getSd().getSerdeInfo().getParameters().get("abc"), (Object)"1");
            Assert.assertEquals((String)"couldn't rename partition", (long)part3.getSd().getNumBuckets(), (long)12L);
            Assert.assertEquals((String)"new partition sd matches", (Object)part3.getSd().getLocation(), (Object)(tbl.getSd().getLocation() + part_path));
            client.dropTable(dbName, tblName);
            client.dropDatabase(dbName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testRenamePartition() failed.");
            throw e;
        }
    }

    @Test
    public void testDatabase() throws Throwable {
        try {
            TestHiveMetaStore.silentDropDatabase(TEST_DB1_NAME);
            TestHiveMetaStore.silentDropDatabase(TEST_DB2_NAME);
            Database db = new DatabaseBuilder().setName(TEST_DB1_NAME).setOwnerName(SecurityUtils.getUser()).build(conf);
            Assert.assertEquals((Object)SecurityUtils.getUser(), (Object)db.getOwnerName());
            client.createDatabase(db);
            db = client.getDatabase(TEST_DB1_NAME);
            Assert.assertEquals((String)"name of returned db is different from that of inserted db", (Object)TEST_DB1_NAME, (Object)db.getName());
            Assert.assertEquals((String)"location of the returned db is different from that of inserted db", (Object)warehouse.getDatabasePath(db).toString(), (Object)db.getLocationUri());
            Assert.assertEquals((Object)db.getOwnerName(), (Object)SecurityUtils.getUser());
            Assert.assertEquals((Object)db.getOwnerType(), (Object)PrincipalType.USER);
            Assert.assertEquals((Object)"hive", (Object)db.getCatalogName());
            Database db2 = new DatabaseBuilder().setName(TEST_DB2_NAME).create((IMetaStoreClient)client, conf);
            db2 = client.getDatabase(TEST_DB2_NAME);
            Assert.assertEquals((String)"name of returned db is different from that of inserted db", (Object)TEST_DB2_NAME, (Object)db2.getName());
            Assert.assertEquals((String)"location of the returned db is different from that of inserted db", (Object)warehouse.getDatabasePath(db2).toString(), (Object)db2.getLocationUri());
            List dbs = client.getDatabases(".*");
            Assert.assertTrue((String)"first database is not testdb1", (boolean)dbs.contains(TEST_DB1_NAME));
            Assert.assertTrue((String)"second database is not testdb2", (boolean)dbs.contains(TEST_DB2_NAME));
            client.dropDatabase(TEST_DB1_NAME);
            client.dropDatabase(TEST_DB2_NAME);
            TestHiveMetaStore.silentDropDatabase(TEST_DB1_NAME);
            TestHiveMetaStore.silentDropDatabase(TEST_DB2_NAME);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testDatabase() failed.");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatabaseLocationWithPermissionProblems() throws Exception {
        if (System.getProperty("user.name").equals("root")) {
            System.err.println("Skipping test because you are running as root!");
            return;
        }
        TestHiveMetaStore.silentDropDatabase(TEST_DB1_NAME);
        String dbLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/test/_testDB_create_";
        FileSystem fs = FileSystem.get((URI)new Path(dbLocation).toUri(), (Configuration)conf);
        fs.mkdirs(new Path(MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/test"), new FsPermission(0));
        Database db = new DatabaseBuilder().setName(TEST_DB1_NAME).setLocation(dbLocation).build(conf);
        boolean createFailed = false;
        try {
            client.createDatabase(db);
        }
        catch (MetaException cantCreateDB) {
            createFailed = true;
        }
        finally {
            if (!createFailed) {
                try {
                    client.dropDatabase(TEST_DB1_NAME);
                }
                catch (Exception e) {
                    System.err.println("Failed to remove database in cleanup: " + e.getMessage());
                }
            }
            fs.setPermission(new Path(MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/test"), new FsPermission(755));
            fs.delete(new Path(MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/test"), true);
        }
        Assert.assertTrue((String)"Database creation succeeded even with permission problem", (boolean)createFailed);
    }

    @Test
    public void testDatabaseLocation() throws Throwable {
        try {
            TestHiveMetaStore.silentDropDatabase(TEST_DB1_NAME);
            String dbLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/_testDB_create_";
            new DatabaseBuilder().setName(TEST_DB1_NAME).setLocation(dbLocation).create((IMetaStoreClient)client, conf);
            Database db = client.getDatabase(TEST_DB1_NAME);
            Assert.assertEquals((String)"name of returned db is different from that of inserted db", (Object)TEST_DB1_NAME, (Object)db.getName());
            Assert.assertEquals((String)"location of the returned db is different from that of inserted db", (Object)warehouse.getDnsPath(new Path(dbLocation)).toString(), (Object)db.getLocationUri());
            client.dropDatabase(TEST_DB1_NAME);
            TestHiveMetaStore.silentDropDatabase(TEST_DB1_NAME);
            boolean objectNotExist = false;
            try {
                client.getDatabase(TEST_DB1_NAME);
            }
            catch (NoSuchObjectException e) {
                objectNotExist = true;
            }
            Assert.assertTrue((String)"Database testdb1 exists ", (boolean)objectNotExist);
            dbLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/_testDB_file_";
            FileSystem fs = FileSystem.get((URI)new Path(dbLocation).toUri(), (Configuration)conf);
            fs.createNewFile(new Path(dbLocation));
            fs.deleteOnExit(new Path(dbLocation));
            db = new DatabaseBuilder().setName(TEST_DB1_NAME).setLocation(dbLocation).build(conf);
            boolean createFailed = false;
            try {
                client.createDatabase(db);
            }
            catch (MetaException cantCreateDB) {
                System.err.println(cantCreateDB.getMessage());
                createFailed = true;
            }
            Assert.assertTrue((String)"Database creation succeeded even location exists and is a file", (boolean)createFailed);
            objectNotExist = false;
            try {
                client.getDatabase(TEST_DB1_NAME);
            }
            catch (NoSuchObjectException e) {
                objectNotExist = true;
            }
            Assert.assertTrue((String)"Database testdb1 exists when location is specified and is a file", (boolean)objectNotExist);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testDatabaseLocation() failed.");
            throw e;
        }
    }

    @Test
    public void testSimpleTypeApi() throws Exception {
        try {
            client.dropType("int");
            Type typ1 = new Type();
            typ1.setName("int");
            boolean ret = client.createType(typ1);
            Assert.assertTrue((String)"Unable to create type", (boolean)ret);
            Type typ1_2 = client.getType("int");
            Assert.assertNotNull((Object)typ1_2);
            Assert.assertEquals((Object)typ1.getName(), (Object)typ1_2.getName());
            ret = client.dropType("int");
            Assert.assertTrue((String)"unable to drop type integer", (boolean)ret);
            boolean exceptionThrown = false;
            try {
                client.getType("int");
            }
            catch (NoSuchObjectException e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"Expected NoSuchObjectException", (boolean)exceptionThrown);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testSimpleTypeApi() failed.");
            throw e;
        }
    }

    @Test
    public void testComplexTypeApi() throws Exception {
        try {
            client.dropType("Person");
            Type typ1 = new Type();
            typ1.setName("Person");
            typ1.setFields(new ArrayList(2));
            typ1.getFields().add(new FieldSchema("name", "string", ""));
            typ1.getFields().add(new FieldSchema("income", "int", ""));
            boolean ret = client.createType(typ1);
            Assert.assertTrue((String)"Unable to create type", (boolean)ret);
            Type typ1_2 = client.getType("Person");
            Assert.assertNotNull((String)"type Person not found", (Object)typ1_2);
            Assert.assertEquals((Object)typ1.getName(), (Object)typ1_2.getName());
            Assert.assertEquals((long)typ1.getFields().size(), (long)typ1_2.getFields().size());
            Assert.assertEquals(typ1.getFields().get(0), typ1_2.getFields().get(0));
            Assert.assertEquals(typ1.getFields().get(1), typ1_2.getFields().get(1));
            client.dropType("Family");
            Type fam = new Type();
            fam.setName("Family");
            fam.setFields(new ArrayList(2));
            fam.getFields().add(new FieldSchema("name", "string", ""));
            fam.getFields().add(new FieldSchema("members", ColumnType.getListType((String)typ1.getName()), ""));
            ret = client.createType(fam);
            Assert.assertTrue((String)("Unable to create type " + fam.getName()), (boolean)ret);
            Type fam2 = client.getType("Family");
            Assert.assertNotNull((String)"type Person not found", (Object)fam2);
            Assert.assertEquals((Object)fam.getName(), (Object)fam2.getName());
            Assert.assertEquals((long)fam.getFields().size(), (long)fam2.getFields().size());
            Assert.assertEquals(fam.getFields().get(0), fam2.getFields().get(0));
            Assert.assertEquals(fam.getFields().get(1), fam2.getFields().get(1));
            ret = client.dropType("Family");
            Assert.assertTrue((String)"unable to drop type Family", (boolean)ret);
            ret = client.dropType("Person");
            Assert.assertTrue((String)"unable to drop type Person", (boolean)ret);
            boolean exceptionThrown = false;
            try {
                client.getType("Person");
            }
            catch (NoSuchObjectException e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"Expected NoSuchObjectException", (boolean)exceptionThrown);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testComplexTypeApi() failed.");
            throw e;
        }
    }

    @Test
    public void testSimpleTable() throws Exception {
        try {
            String dbName = "simpdb";
            String tblName = "simptbl";
            String tblName2 = "simptbl2";
            String typeName = "Person";
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
            client.dropType(typeName);
            Type typ1 = new Type();
            typ1.setName(typeName);
            typ1.setFields(new ArrayList(2));
            typ1.getFields().add(new FieldSchema("name", "string", ""));
            typ1.getFields().add(new FieldSchema("income", "int", ""));
            client.createType(typ1);
            Table tbl = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).setCols(typ1.getFields())).setNumBuckets(1)).addBucketCol("name")).addStorageDescriptorParam("test_param_1", "Use this for comments etc")).create((IMetaStoreClient)client, conf);
            if (isThriftClient) {
                tbl = client.getTable(dbName, tblName);
            }
            Table tbl2 = client.getTable(dbName, tblName);
            Assert.assertNotNull((Object)tbl2);
            Assert.assertEquals((Object)tbl2.getDbName(), (Object)dbName);
            Assert.assertEquals((Object)tbl2.getTableName(), (Object)tblName);
            Assert.assertEquals((long)tbl2.getSd().getCols().size(), (long)typ1.getFields().size());
            Assert.assertEquals((Object)tbl2.getSd().isCompressed(), (Object)false);
            Assert.assertEquals((long)tbl2.getSd().getNumBuckets(), (long)1L);
            Assert.assertEquals((Object)tbl2.getSd().getLocation(), (Object)tbl.getSd().getLocation());
            Assert.assertNotNull((Object)tbl2.getSd().getSerdeInfo());
            tbl.getSd().getSerdeInfo().setParameters(new HashMap());
            tbl.getSd().getSerdeInfo().getParameters().put("serialization.format", "1");
            tbl2.setTableName(tblName2);
            tbl2.setParameters(new HashMap());
            tbl2.getParameters().put("EXTERNAL", "TRUE");
            tbl2.getSd().setLocation(tbl.getSd().getLocation() + "-2");
            List fieldSchemas = client.getFields(dbName, tblName);
            Assert.assertNotNull((Object)fieldSchemas);
            Assert.assertEquals((long)fieldSchemas.size(), (long)tbl.getSd().getCols().size());
            for (Object fs : tbl.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemas.contains(fs));
            }
            List fieldSchemasFull = client.getSchema(dbName, tblName);
            Assert.assertNotNull((Object)fieldSchemasFull);
            Assert.assertEquals((long)fieldSchemasFull.size(), (long)(tbl.getSd().getCols().size() + tbl.getPartitionKeys().size()));
            for (Object fs : tbl.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
            for (Object fs : tbl.getPartitionKeys()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
            client.createTable(tbl2);
            if (isThriftClient) {
                tbl2 = client.getTable(tbl2.getDbName(), tbl2.getTableName());
            }
            Table tbl3 = client.getTable(dbName, tblName2);
            Assert.assertNotNull((Object)tbl3);
            Assert.assertEquals((Object)tbl3.getDbName(), (Object)dbName);
            Assert.assertEquals((Object)tbl3.getTableName(), (Object)tblName2);
            Assert.assertEquals((long)tbl3.getSd().getCols().size(), (long)typ1.getFields().size());
            Assert.assertEquals((Object)tbl3.getSd().isCompressed(), (Object)false);
            Assert.assertEquals((long)tbl3.getSd().getNumBuckets(), (long)1L);
            Assert.assertEquals((Object)tbl3.getSd().getLocation(), (Object)tbl2.getSd().getLocation());
            Assert.assertEquals((Object)tbl3.getParameters(), (Object)tbl2.getParameters());
            fieldSchemas = client.getFields(dbName, tblName2);
            Assert.assertNotNull((Object)fieldSchemas);
            Assert.assertEquals((long)fieldSchemas.size(), (long)tbl2.getSd().getCols().size());
            for (FieldSchema fs : tbl2.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemas.contains(fs));
            }
            fieldSchemasFull = client.getSchema(dbName, tblName2);
            Assert.assertNotNull((Object)fieldSchemasFull);
            Assert.assertEquals((long)fieldSchemasFull.size(), (long)(tbl2.getSd().getCols().size() + tbl2.getPartitionKeys().size()));
            for (FieldSchema fs : tbl2.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
            for (FieldSchema fs : tbl2.getPartitionKeys()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
            Assert.assertEquals((Object)"Use this for comments etc", tbl2.getSd().getParameters().get("test_param_1"));
            Assert.assertEquals((Object)"name", tbl2.getSd().getBucketCols().get(0));
            Assert.assertTrue((String)"Partition key list is not empty", (tbl2.getPartitionKeys() == null || tbl2.getPartitionKeys().size() == 0 ? 1 : 0) != 0);
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add(tblName2);
            tableNames.add(tblName);
            tableNames.add(tblName2);
            List foundTables = client.getTableObjectsByName(dbName, tableNames);
            Assert.assertEquals((long)2L, (long)foundTables.size());
            for (Table t : foundTables) {
                if (t.getTableName().equals(tblName2)) {
                    Assert.assertEquals((Object)t.getSd().getLocation(), (Object)tbl2.getSd().getLocation());
                } else {
                    Assert.assertEquals((Object)t.getTableName(), (Object)tblName);
                    Assert.assertEquals((Object)t.getSd().getLocation(), (Object)tbl.getSd().getLocation());
                }
                Assert.assertEquals((long)t.getSd().getCols().size(), (long)typ1.getFields().size());
                Assert.assertEquals((Object)t.getSd().isCompressed(), (Object)false);
                Assert.assertEquals((long)((Table)foundTables.get(0)).getSd().getNumBuckets(), (long)1L);
                Assert.assertNotNull((Object)t.getSd().getSerdeInfo());
                Assert.assertEquals((Object)t.getDbName(), (Object)dbName);
            }
            tableNames.add(1, "table_that_doesnt_exist");
            foundTables = client.getTableObjectsByName(dbName, tableNames);
            Assert.assertEquals((long)foundTables.size(), (long)2L);
            InvalidOperationException ioe = null;
            try {
                foundTables = client.getTableObjectsByName(dbName, null);
            }
            catch (InvalidOperationException e) {
                ioe = e;
            }
            Assert.assertNotNull((Object)((Object)ioe));
            Assert.assertTrue((String)"Table not found", (boolean)ioe.getMessage().contains("null tables"));
            UnknownDBException udbe = null;
            try {
                foundTables = client.getTableObjectsByName("db_that_doesnt_exist", tableNames);
            }
            catch (UnknownDBException e) {
                udbe = e;
            }
            Assert.assertNotNull((Object)((Object)udbe));
            Assert.assertTrue((String)"DB not found", (boolean)udbe.getMessage().contains("not find database hive.db_that_doesnt_exist"));
            udbe = null;
            try {
                foundTables = client.getTableObjectsByName("", tableNames);
            }
            catch (UnknownDBException e) {
                udbe = e;
            }
            Assert.assertNotNull((Object)((Object)udbe));
            Assert.assertTrue((String)"DB not found", (boolean)udbe.getMessage().contains("is null or empty"));
            FileSystem fs = FileSystem.get((URI)new Path(tbl.getSd().getLocation()).toUri(), (Configuration)conf);
            client.dropTable(dbName, tblName);
            Assert.assertFalse((boolean)fs.exists(new Path(tbl.getSd().getLocation())));
            client.dropTable(dbName, tblName2);
            Assert.assertTrue((boolean)fs.exists(new Path(tbl2.getSd().getLocation())));
            client.dropType(typeName);
            client.dropDatabase(dbName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testSimpleTable() failed.");
            throw e;
        }
    }

    @Test
    public void testStatsFastTrivial() throws Throwable {
        String dbName = "tstatsfast";
        String tblName = "t1";
        String tblOwner = "statstester";
        String typeName = "Person";
        int lastAccessed = 12083;
        this.cleanUp(dbName, tblName, typeName);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
        values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
        values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
        this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
        ArrayList emptyColNames = new ArrayList();
        ArrayList emptyPartNames = new ArrayList();
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add("name");
        colNames.add("income");
        List partNames = client.listPartitionNames(dbName, tblName, (short)-1);
        Assert.assertEquals((long)0L, (long)emptyColNames.size());
        Assert.assertEquals((long)0L, (long)emptyPartNames.size());
        Assert.assertEquals((long)2L, (long)colNames.size());
        Assert.assertEquals((long)4L, (long)partNames.size());
        AggrStats aggrStatsEmpty = client.getAggrColStatsFor(dbName, tblName, emptyColNames, emptyPartNames);
        Assert.assertNotNull((Object)aggrStatsEmpty);
        Assert.assertEquals((long)0L, (long)aggrStatsEmpty.getPartsFound());
        Assert.assertNotNull((Object)aggrStatsEmpty.getColStats());
        assert (aggrStatsEmpty.getColStats().isEmpty());
        AggrStats aggrStatsOnlyParts = client.getAggrColStatsFor(dbName, tblName, emptyColNames, partNames);
        Assert.assertNotNull((Object)aggrStatsOnlyParts);
        Assert.assertEquals((long)0L, (long)aggrStatsOnlyParts.getPartsFound());
        Assert.assertNotNull((Object)aggrStatsOnlyParts.getColStats());
        assert (aggrStatsOnlyParts.getColStats().isEmpty());
        AggrStats aggrStatsOnlyCols = client.getAggrColStatsFor(dbName, tblName, colNames, emptyPartNames);
        Assert.assertNotNull((Object)aggrStatsOnlyCols);
        Assert.assertEquals((long)0L, (long)aggrStatsOnlyCols.getPartsFound());
        Assert.assertNotNull((Object)aggrStatsOnlyCols.getColStats());
        assert (aggrStatsOnlyCols.getColStats().isEmpty());
        AggrStats aggrStatsFull = client.getAggrColStatsFor(dbName, tblName, colNames, partNames);
        Assert.assertNotNull((Object)aggrStatsFull);
        Assert.assertEquals((long)0L, (long)aggrStatsFull.getPartsFound());
        Assert.assertNotNull((Object)aggrStatsFull.getColStats());
        assert (aggrStatsFull.getColStats().isEmpty());
    }

    @Test
    public void testColumnStatistics() throws Throwable {
        String dbName = "columnstatstestdb";
        String tblName = "tbl";
        String typeName = "Person";
        String tblOwner = "testowner";
        int lastAccessed = 6796;
        try {
            this.cleanUp(dbName, tblName, typeName);
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
            this.createTableForTestFilter(dbName, tblName, tblOwner, lastAccessed, true);
            String[] colName = new String[]{"income", "name"};
            double lowValue = 50000.21;
            double highValue = 1200000.4525;
            long numNulls = 3L;
            long numDVs = 22L;
            double avgColLen = 50.3;
            long maxColLen = 102L;
            String[] colType = new String[]{"double", "string"};
            boolean isTblLevel = true;
            String partName = null;
            ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
            ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tblName);
            statsDesc.setIsTblLevel(isTblLevel);
            statsDesc.setPartName(partName);
            ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
            statsObj.setColName(colName[0]);
            statsObj.setColType(colType[0]);
            ColumnStatisticsData statsData = new ColumnStatisticsData();
            DoubleColumnStatsData numericStats = new DoubleColumnStatsData();
            statsData.setDoubleStats(numericStats);
            statsData.getDoubleStats().setHighValue(highValue);
            statsData.getDoubleStats().setLowValue(lowValue);
            statsData.getDoubleStats().setNumDVs(numDVs);
            statsData.getDoubleStats().setNumNulls(numNulls);
            statsObj.setStatsData(statsData);
            statsObjs.add(statsObj);
            statsObj = new ColumnStatisticsObj();
            statsObj.setColName(colName[1]);
            statsObj.setColType(colType[1]);
            statsData = new ColumnStatisticsData();
            StringColumnStatsData stringStats = new StringColumnStatsData();
            statsData.setStringStats(stringStats);
            statsData.getStringStats().setAvgColLen(avgColLen);
            statsData.getStringStats().setMaxColLen(maxColLen);
            statsData.getStringStats().setNumDVs(numDVs);
            statsData.getStringStats().setNumNulls(numNulls);
            statsObj.setStatsData(statsData);
            statsObjs.add(statsObj);
            ColumnStatistics colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            client.updateTableColumnStatistics(colStats);
            ColumnStatisticsObj colStats2 = (ColumnStatisticsObj)client.getTableColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{colName[0]})).get(0);
            Assert.assertNotNull((Object)colStats2);
            Assert.assertEquals((Object)colStats2.getColName(), (Object)colName[0]);
            Assert.assertEquals((double)colStats2.getStatsData().getDoubleStats().getLowValue(), (double)lowValue, (double)0.01);
            Assert.assertEquals((double)colStats2.getStatsData().getDoubleStats().getHighValue(), (double)highValue, (double)0.01);
            Assert.assertEquals((long)colStats2.getStatsData().getDoubleStats().getNumNulls(), (long)numNulls);
            Assert.assertEquals((long)colStats2.getStatsData().getDoubleStats().getNumDVs(), (long)numDVs);
            boolean status = client.deleteTableColumnStatistics(dbName, tblName, null);
            Assert.assertTrue((boolean)status);
            Assert.assertTrue((boolean)client.getTableColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{colName[1]})).isEmpty());
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            client.updateTableColumnStatistics(colStats);
            colStats2 = (ColumnStatisticsObj)client.getTableColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{colName[0]})).get(0);
            this.cleanUp(dbName, tblName, typeName);
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "14"));
            values.add(TestHiveMetaStore.makeVals("2008-07-01 14:13:12", "15"));
            values.add(TestHiveMetaStore.makeVals("2008-07-02 14:13:12", "15"));
            values.add(TestHiveMetaStore.makeVals("2008-07-03 14:13:12", "151"));
            this.createMultiPartitionTableSchema(dbName, tblName, typeName, values);
            List partitions = client.listPartitionNames(dbName, tblName, (short)-1);
            partName = (String)partitions.get(0);
            isTblLevel = false;
            statsDesc = new ColumnStatisticsDesc();
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tblName);
            statsDesc.setPartName(partName);
            statsDesc.setIsTblLevel(isTblLevel);
            colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            client.updatePartitionColumnStatistics(colStats);
            colStats2 = (ColumnStatisticsObj)((List)client.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{partName}), (List)Lists.newArrayList((Object[])new String[]{colName[1]})).get(partName)).get(0);
            Assert.assertNotNull((Object)colStats2);
            Assert.assertEquals((Object)colStats.getStatsDesc().getPartName(), (Object)partName);
            Assert.assertEquals((Object)colStats2.getColName(), (Object)colName[1]);
            Assert.assertEquals((long)colStats2.getStatsData().getStringStats().getMaxColLen(), (long)maxColLen);
            Assert.assertEquals((double)colStats2.getStatsData().getStringStats().getAvgColLen(), (double)avgColLen, (double)0.01);
            Assert.assertEquals((long)colStats2.getStatsData().getStringStats().getNumNulls(), (long)numNulls);
            Assert.assertEquals((long)colStats2.getStatsData().getStringStats().getNumDVs(), (long)numDVs);
            client.deletePartitionColumnStatistics(dbName, tblName, partName, colName[1]);
            colStats2 = (ColumnStatisticsObj)((List)client.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{partName}), (List)Lists.newArrayList((Object[])new String[]{colName[0]})).get(partName)).get(0);
            Assert.assertTrue((boolean)client.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{partName}), (List)Lists.newArrayList((Object[])new String[]{colName[1]})).isEmpty());
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testColumnStatistics() failed.");
            throw e;
        }
        finally {
            this.cleanUp(dbName, tblName, typeName);
        }
    }

    @Test(expected=MetaException.class)
    public void testGetSchemaWithNoClassDefFoundError() throws TException {
        String dbName = "testDb";
        String tblName = "testTable";
        client.dropTable(dbName, tblName);
        TestHiveMetaStore.silentDropDatabase(dbName);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string", "")).setSerdeLib("no.such.class")).create((IMetaStoreClient)client, conf);
        client.getSchema(dbName, tblName);
    }

    @Test
    public void testAlterTable() throws Exception {
        String dbName = "alterdb";
        String invTblName = "alter-tbl";
        String tblName = "altertbl";
        try {
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
            ArrayList<FieldSchema> invCols = new ArrayList<FieldSchema>(2);
            invCols.add(new FieldSchema("n-ame", "string", ""));
            invCols.add(new FieldSchema("in.come", "int", ""));
            Table tbl = ((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(invTblName).setCols(invCols)).build(conf);
            boolean failed = false;
            try {
                client.createTable(tbl);
            }
            catch (InvalidObjectException ex) {
                failed = true;
            }
            if (!failed) {
                Assert.assertTrue((String)("Able to create table with invalid name: " + invTblName), (boolean)false);
            }
            ArrayList<FieldSchema> invColsInvType = new ArrayList<FieldSchema>(2);
            invColsInvType.add(new FieldSchema("name", "string", ""));
            invColsInvType.add(new FieldSchema("income", "xyz", ""));
            tbl.setTableName(tblName);
            tbl.getSd().setCols(invColsInvType);
            boolean failChecker = false;
            try {
                client.createTable(tbl);
            }
            catch (InvalidObjectException ex) {
                failChecker = true;
            }
            if (!failChecker) {
                Assert.assertTrue((String)("Able to create table with invalid column type: " + invTblName), (boolean)false);
            }
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(2);
            cols.add(new FieldSchema("name", "string", ""));
            cols.add(new FieldSchema("income", "int", ""));
            tbl.setTableName(tblName);
            tbl.getSd().setCols(cols);
            client.createTable(tbl);
            if (isThriftClient) {
                tbl = client.getTable(tbl.getDbName(), tbl.getTableName());
            }
            Table tbl2 = client.getTable(dbName, tblName);
            failed = false;
            try {
                tbl2.setTableName(invTblName);
                tbl2.getSd().setCols(invCols);
                client.alter_table(dbName, tblName, tbl2);
            }
            catch (InvalidOperationException ex) {
                failed = true;
            }
            if (!failed) {
                Assert.assertTrue((String)("Able to rename table with invalid name: " + invTblName), (boolean)false);
            }
            Table tbl_pk = client.getTable(tbl.getDbName(), tbl.getTableName());
            List partitionKeys = tbl_pk.getPartitionKeys();
            for (FieldSchema fs : partitionKeys) {
                fs.setName("invalid_to_change_name");
                fs.setComment("can_change_comment");
            }
            tbl_pk.setPartitionKeys(partitionKeys);
            try {
                client.alter_table(dbName, tblName, tbl_pk);
            }
            catch (InvalidOperationException ex) {
                failed = true;
            }
            Assert.assertTrue((String)"Should not have succeeded in altering partition key name", (boolean)failed);
            failed = false;
            tbl_pk = client.getTable(tbl.getDbName(), tbl.getTableName());
            partitionKeys = tbl_pk.getPartitionKeys();
            for (FieldSchema fs : partitionKeys) {
                fs.setComment("can_change_comment");
            }
            tbl_pk.setPartitionKeys(partitionKeys);
            try {
                client.alter_table(dbName, tblName, tbl_pk);
            }
            catch (InvalidOperationException ex) {
                failed = true;
            }
            Assert.assertFalse((String)"Should not have failed alter table partition comment", (boolean)failed);
            Table newT = client.getTable(tbl.getDbName(), tbl.getTableName());
            Assert.assertEquals((Object)partitionKeys, (Object)newT.getPartitionKeys());
            tbl2.setTableName(tblName + "_renamed");
            tbl2.getSd().setCols(cols);
            tbl2.getSd().setNumBuckets(32);
            client.alter_table(dbName, tblName, tbl2);
            Table tbl3 = client.getTable(dbName, tbl2.getTableName());
            Assert.assertEquals((String)"Alter table didn't succeed. Num buckets is different ", (long)tbl2.getSd().getNumBuckets(), (long)tbl3.getSd().getNumBuckets());
            FileSystem fs = FileSystem.get((URI)new Path(tbl.getSd().getLocation()).toUri(), (Configuration)conf);
            Assert.assertFalse((String)"old table location still exists", (boolean)fs.exists(new Path(tbl.getSd().getLocation())));
            Assert.assertTrue((String)"data did not move to new location", (boolean)fs.exists(new Path(tbl3.getSd().getLocation())));
            if (!isThriftClient) {
                Assert.assertEquals((String)"alter table didn't move data correct location", (Object)tbl3.getSd().getLocation(), (Object)tbl2.getSd().getLocation());
            }
            tbl_pk.getSd().setCols(invColsInvType);
            failed = false;
            try {
                client.alter_table(dbName, tbl2.getTableName(), tbl_pk);
            }
            catch (InvalidOperationException ex) {
                failed = true;
            }
            Assert.assertTrue((String)"Should not have succeeded in altering column", (boolean)failed);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testSimpleTable() failed.");
            throw e;
        }
        finally {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
    }

    @Test
    public void testComplexTable() throws Exception {
        String dbName = "compdb";
        String tblName = "comptbl";
        String typeName = "Person";
        try {
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
            client.dropType(typeName);
            Type typ1 = new Type();
            typ1.setName(typeName);
            typ1.setFields(new ArrayList(2));
            typ1.getFields().add(new FieldSchema("name", "string", ""));
            typ1.getFields().add(new FieldSchema("income", "int", ""));
            client.createType(typ1);
            Table tbl = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).setCols(typ1.getFields())).addPartCol("ds", "date").addPartCol("hr", "int").setNumBuckets(1)).addBucketCol("name")).addStorageDescriptorParam("test_param_1", "Use this for comments etc")).create((IMetaStoreClient)client, conf);
            Table tbl2 = client.getTable(dbName, tblName);
            Assert.assertEquals((Object)tbl2.getDbName(), (Object)dbName);
            Assert.assertEquals((Object)tbl2.getTableName(), (Object)tblName);
            Assert.assertEquals((long)tbl2.getSd().getCols().size(), (long)typ1.getFields().size());
            Assert.assertFalse((boolean)tbl2.getSd().isCompressed());
            Assert.assertFalse((boolean)tbl2.getSd().isStoredAsSubDirectories());
            Assert.assertEquals((long)tbl2.getSd().getNumBuckets(), (long)1L);
            Assert.assertEquals((Object)"Use this for comments etc", tbl2.getSd().getParameters().get("test_param_1"));
            Assert.assertEquals((Object)"name", tbl2.getSd().getBucketCols().get(0));
            Assert.assertNotNull((Object)tbl2.getPartitionKeys());
            Assert.assertEquals((long)2L, (long)tbl2.getPartitionKeys().size());
            Assert.assertEquals((Object)"date", (Object)((FieldSchema)tbl2.getPartitionKeys().get(0)).getType());
            Assert.assertEquals((Object)"int", (Object)((FieldSchema)tbl2.getPartitionKeys().get(1)).getType());
            Assert.assertEquals((Object)"ds", (Object)((FieldSchema)tbl2.getPartitionKeys().get(0)).getName());
            Assert.assertEquals((Object)"hr", (Object)((FieldSchema)tbl2.getPartitionKeys().get(1)).getName());
            List fieldSchemas = client.getFields(dbName, tblName);
            Assert.assertNotNull((Object)fieldSchemas);
            Assert.assertEquals((long)fieldSchemas.size(), (long)tbl.getSd().getCols().size());
            for (FieldSchema fs : tbl.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemas.contains(fs));
            }
            List fieldSchemasFull = client.getSchema(dbName, tblName);
            Assert.assertNotNull((Object)fieldSchemasFull);
            Assert.assertEquals((long)fieldSchemasFull.size(), (long)(tbl.getSd().getCols().size() + tbl.getPartitionKeys().size()));
            for (FieldSchema fs : tbl.getSd().getCols()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
            for (FieldSchema fs : tbl.getPartitionKeys()) {
                Assert.assertTrue((boolean)fieldSchemasFull.contains(fs));
            }
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testComplexTable() failed.");
            throw e;
        }
        finally {
            client.dropTable(dbName, tblName);
            boolean ret = client.dropType(typeName);
            Assert.assertTrue((String)("Unable to drop type " + typeName), (boolean)ret);
            client.dropDatabase(dbName);
        }
    }

    @Test
    public void testTableDatabase() throws Exception {
        String dbName = "testDb";
        String tblName_1 = "testTbl_1";
        String tblName_2 = "testTbl_2";
        try {
            TestHiveMetaStore.silentDropDatabase(dbName);
            String dbLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "_testDB_table_create_";
            new DatabaseBuilder().setName(dbName).setLocation(dbLocation).create((IMetaStoreClient)client, conf);
            Database db = client.getDatabase(dbName);
            Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName_1).addCol("name", "string")).addCol("income", "int")).create((IMetaStoreClient)client, conf);
            tbl = client.getTable(dbName, tblName_1);
            Path path = new Path(tbl.getSd().getLocation());
            System.err.println("Table's location " + path + ", Database's location " + db.getLocationUri());
            Assert.assertEquals((String)"Table location is not a subset of the database location", (Object)path.getParent().toString(), (Object)db.getLocationUri());
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTableDatabase() failed.");
            throw e;
        }
        finally {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
    }

    @Test
    public void testGetConfigValue() {
        String val = "value";
        if (!isThriftClient) {
            try {
                Assert.assertEquals((Object)client.getConfigValue("hive.key1", val), (Object)"value1");
                Assert.assertEquals((Object)client.getConfigValue("hive.key2", val), (Object)"http://www.example.com");
                Assert.assertEquals((Object)client.getConfigValue("hive.key3", val), (Object)"");
                Assert.assertEquals((Object)client.getConfigValue("hive.key4", val), (Object)"0");
                Assert.assertEquals((Object)client.getConfigValue("hive.key5", val), (Object)val);
                Assert.assertEquals((Object)client.getConfigValue(null, val), (Object)val);
            }
            catch (TException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        boolean threwException = false;
        try {
            client.getConfigValue("javax.jdo.option.ConnectionPassword", "password");
        }
        catch (ConfigValSecurityException e) {
            threwException = true;
        }
        catch (TException e) {
            e.printStackTrace();
            Assert.fail();
        }
        assert (threwException);
    }

    private static void adjust(HiveMetaStoreClient client, Partition part, String dbName, String tblName) throws TException {
        Partition part_get = client.getPartition(dbName, tblName, part.getValues());
        part.setCreateTime(part_get.getCreateTime());
        part.putToParameters("transient_lastDdlTime", Long.toString(part_get.getCreateTime()));
    }

    private static void silentDropDatabase(String dbName) throws TException {
        try {
            for (String tableName : client.getTables(dbName, "*")) {
                client.dropTable(dbName, tableName);
            }
            client.dropDatabase(dbName);
        }
        catch (InvalidOperationException | NoSuchObjectException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testPartitionFilter() throws Exception {
        String dbName = "filterdb";
        String tblName = "filtertbl";
        TestHiveMetaStore.silentDropDatabase(dbName);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("c1", "string")).addCol("c2", "int")).addPartCol("p1", "string").addPartCol("p2", "string").addPartCol("p3", "int").create((IMetaStoreClient)client, conf);
        tbl = client.getTable(dbName, tblName);
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p11", "p21", "31"}), "part1");
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p11", "p22", "32"}), "part2");
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p12", "p21", "31"}), "part3");
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p12", "p23", "32"}), "part4");
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p13", "p24", "31"}), "part5");
        this.add_partition(client, tbl, Lists.newArrayList((Object[])new String[]{"p13", "p25", "-33"}), "part6");
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 = \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p2 = \"p21\"", 2);
        this.checkFilter(client, dbName, tblName, "p2 = \"p23\"", 1);
        this.checkFilter(client, dbName, tblName, "p3 = 31", 3);
        this.checkFilter(client, dbName, tblName, "p3 = 33", 0);
        this.checkFilter(client, dbName, tblName, "p3 = -33", 1);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" and p2=\"p22\"", 1);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or p2=\"p23\"", 3);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or p1=\"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or p1=\"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or p1=\"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" and p3 = 31", 1);
        this.checkFilter(client, dbName, tblName, "p3 = -33 or p1 = \"p12\"", 3);
        this.checkFilter(client, dbName, tblName, "p1 != \"p11\"", 4);
        this.checkFilter(client, dbName, tblName, "p2 != \"p23\"", 5);
        this.checkFilter(client, dbName, tblName, "p2 != \"p33\"", 6);
        this.checkFilter(client, dbName, tblName, "p3 != 32", 4);
        this.checkFilter(client, dbName, tblName, "p3 != 8589934592", 6);
        this.checkFilter(client, dbName, tblName, "p1 != \"p11\" and p1 != \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 != \"p11\" and p2 != \"p22\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 != \"p11\" or p2 != \"p22\"", 5);
        this.checkFilter(client, dbName, tblName, "p1 != \"p12\" and p2 != \"p25\"", 3);
        this.checkFilter(client, dbName, tblName, "p1 != \"p12\" or p2 != \"p25\"", 6);
        this.checkFilter(client, dbName, tblName, "p3 != -33 or p1 != \"p13\"", 5);
        this.checkFilter(client, dbName, tblName, "p1 != \"p11\" and p3 = 31", 2);
        this.checkFilter(client, dbName, tblName, "p3 != 31 and p1 = \"p12\"", 1);
        this.checkFilter(client, dbName, tblName, "31 != p3 and p1 = \"p12\"", 1);
        this.checkFilter(client, dbName, tblName, "\"p23\" = p2", 1);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or (p1=\"p12\" and p2=\"p21\")", 3);
        this.checkFilter(client, dbName, tblName, "p1 = \"p11\" or (p1=\"p12\" and p2=\"p21\") Or (p1=\"p13\" aNd p2=\"p24\")", 4);
        this.checkFilter(client, dbName, tblName, "p1=\"p12\" and (p2=\"p27\" Or p2=\"p21\")", 1);
        this.checkFilter(client, dbName, tblName, "p1=\"p12\" and p2=\"p27\" Or p2=\"p21\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 > \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 >= \"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 < \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 <= \"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 like \"p1.*\"", 6);
        this.checkFilter(client, dbName, tblName, "p2 like \"p.*3\"", 1);
        this.checkFilter(client, dbName, tblName, "p3 < 0", 1);
        this.checkFilter(client, dbName, tblName, "p3 >= -33", 6);
        this.checkFilter(client, dbName, tblName, "p3 > -33", 5);
        this.checkFilter(client, dbName, tblName, "p3 > 31 and p3 < 32", 0);
        this.checkFilter(client, dbName, tblName, "p3 > 31 or p3 < 31", 3);
        this.checkFilter(client, dbName, tblName, "p3 > 30 or p3 < 30", 6);
        this.checkFilter(client, dbName, tblName, "p3 >= 31 or p3 < -32", 6);
        this.checkFilter(client, dbName, tblName, "p3 >= 32", 2);
        this.checkFilter(client, dbName, tblName, "p3 > 32", 0);
        this.checkFilter(client, dbName, tblName, "p1 between \"p11\" and \"p12\"", 4);
        this.checkFilter(client, dbName, tblName, "p1 not between \"p11\" and \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p3 not between 0 and 2", 6);
        this.checkFilter(client, dbName, tblName, "p3 between 31 and 32", 5);
        this.checkFilter(client, dbName, tblName, "p3 between 32 and 31", 0);
        this.checkFilter(client, dbName, tblName, "p3 between -32 and 34 and p3 not between 31 and 32", 0);
        this.checkFilter(client, dbName, tblName, "p3 between 1 and 3 or p3 not between 1 and 3", 6);
        this.checkFilter(client, dbName, tblName, "p3 between 31 and 32 and p1 between \"p12\" and \"p14\"", 3);
        List partitions = client.listPartitionsByFilter(dbName, tblName, "p1 >= \"p12\"", (short)2);
        Assert.assertEquals((String)"User specified row limit for partitions", (long)2L, (long)partitions.size());
        Throwable me = null;
        try {
            client.listPartitionsByFilter(dbName, tblName, "p3 >= \"p12\"", (short)-1);
        }
        catch (MetaException e) {
            me = e;
        }
        Assert.assertNotNull((Object)me);
        Assert.assertTrue((String)"Filter on int partition key", (boolean)me.getMessage().contains("Filtering is supported only on partition keys of type string"));
        me = null;
        try {
            client.listPartitionsByFilter(dbName, tblName, "c1 >= \"p12\"", (short)-1);
        }
        catch (MetaException e) {
            me = e;
        }
        Assert.assertNotNull((Object)me);
        Assert.assertTrue((String)"Filter on invalid key", (boolean)me.getMessage().contains("<c1> is not a partitioning key for the table"));
        me = null;
        try {
            client.listPartitionsByFilter(dbName, tblName, "c1 >= ", (short)-1);
        }
        catch (MetaException e) {
            me = e;
        }
        Assert.assertNotNull((Object)me);
        Assert.assertTrue((String)"Invalid filter string", (boolean)me.getMessage().contains("Error parsing partition filter"));
        me = null;
        try {
            client.listPartitionsByFilter("invDBName", "invTableName", "p1 = \"p11\"", (short)-1);
        }
        catch (NoSuchObjectException e) {
            me = e;
        }
        Assert.assertNotNull((Object)me);
        Assert.assertTrue((String)"NoSuchObject exception", (boolean)me.getMessage().contains("invDBName.invTableName table not found"));
        client.dropTable(dbName, tblName);
        client.dropDatabase(dbName);
    }

    @Test
    public void testFilterSinglePartition() throws Exception {
        String dbName = "filterdb";
        String tblName = "filtertbl";
        ArrayList<String> vals = new ArrayList<String>(1);
        vals.add("p11");
        ArrayList<String> vals2 = new ArrayList<String>(1);
        vals2.add("p12");
        ArrayList<String> vals3 = new ArrayList<String>(1);
        vals3.add("p13");
        TestHiveMetaStore.silentDropDatabase(dbName);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("c1", "string")).addCol("c2", "int")).addPartCol("p1", "string").create((IMetaStoreClient)client, conf);
        tbl = client.getTable(dbName, tblName);
        this.add_partition(client, tbl, vals, "part1");
        this.add_partition(client, tbl, vals2, "part2");
        this.add_partition(client, tbl, vals3, "part3");
        this.checkFilter(client, dbName, tblName, "p1 = \"p12\"", 1);
        this.checkFilter(client, dbName, tblName, "p1 < \"p12\"", 1);
        this.checkFilter(client, dbName, tblName, "p1 > \"p12\"", 1);
        this.checkFilter(client, dbName, tblName, "p1 >= \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 <= \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 <> \"p12\"", 2);
        this.checkFilter(client, dbName, tblName, "p1 like \"p1.*\"", 3);
        this.checkFilter(client, dbName, tblName, "p1 like \"p.*2\"", 1);
        client.dropTable(dbName, tblName);
        client.dropDatabase(dbName);
    }

    @Test
    public void testFilterLastPartition() throws Exception {
        String dbName = "filterdb";
        String tblName = "filtertbl";
        ArrayList<String> vals = new ArrayList<String>(2);
        vals.add("p11");
        vals.add("p21");
        ArrayList<String> vals2 = new ArrayList<String>(2);
        vals2.add("p11");
        vals2.add("p22");
        ArrayList<String> vals3 = new ArrayList<String>(2);
        vals3.add("p12");
        vals3.add("p21");
        this.cleanUp(dbName, tblName, null);
        this.createDb(dbName);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("c1", "string")).addCol("c2", "int")).addPartCol("p1", "string").addPartCol("p2", "string").create((IMetaStoreClient)client, conf);
        tbl = client.getTable(dbName, tblName);
        this.add_partition(client, tbl, vals, "part1");
        this.add_partition(client, tbl, vals2, "part2");
        this.add_partition(client, tbl, vals3, "part3");
        this.checkFilter(client, dbName, tblName, "p2 = \"p21\"", 2);
        this.checkFilter(client, dbName, tblName, "p2 < \"p23\"", 3);
        this.checkFilter(client, dbName, tblName, "p2 > \"p21\"", 1);
        this.checkFilter(client, dbName, tblName, "p2 >= \"p21\"", 3);
        this.checkFilter(client, dbName, tblName, "p2 <= \"p21\"", 2);
        this.checkFilter(client, dbName, tblName, "p2 <> \"p12\"", 3);
        this.checkFilter(client, dbName, tblName, "p2 != \"p12\"", 3);
        this.checkFilter(client, dbName, tblName, "p2 like \"p2.*\"", 3);
        this.checkFilter(client, dbName, tblName, "p2 like \"p.*2\"", 1);
        try {
            this.checkFilter(client, dbName, tblName, "p2 !< 'dd'", 0);
            Assert.fail((String)"Invalid operator not detected");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.cleanUp(dbName, tblName, null);
    }

    private void checkFilter(HiveMetaStoreClient client, String dbName, String tblName, String filter, int expectedCount) throws TException {
        LOG.debug("Testing filter: " + filter);
        List partitions = client.listPartitionsByFilter(dbName, tblName, filter, (short)-1);
        Assert.assertEquals((String)("Partition count expected for filter " + filter), (long)expectedCount, (long)partitions.size());
    }

    private void add_partition(HiveMetaStoreClient client, Table table, List<String> vals, String location) throws TException {
        Partition part = new Partition();
        part.setDbName(table.getDbName());
        part.setTableName(table.getTableName());
        part.setValues(vals);
        part.setParameters(new HashMap());
        part.setSd(table.getSd().deepCopy());
        part.getSd().setSerdeInfo(table.getSd().getSerdeInfo());
        part.getSd().setLocation(table.getSd().getLocation() + location);
        client.add_partition(part);
    }

    @Test
    public void testSynchronized() throws Exception {
        int currentNumberOfDbs = client.getAllDatabases().size();
        IMetaStoreClient synchronizedClient = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)client);
        List databases = synchronizedClient.getAllDatabases();
        Assert.assertEquals((long)currentNumberOfDbs, (long)databases.size());
    }

    @Test
    public void testTableFilter() throws Exception {
        try {
            String dbName = "testTableFilter";
            String owner1 = "testOwner1";
            String owner2 = "testOwner2";
            int lastAccessTime1 = 90;
            int lastAccessTime2 = 30;
            String tableName1 = "table1";
            String tableName2 = "table2";
            String tableName3 = "table3";
            client.dropTable(dbName, tableName1);
            client.dropTable(dbName, tableName2);
            client.dropTable(dbName, tableName3);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).setDescription("Alter Partition Test database").create((IMetaStoreClient)client, conf);
            Table table1 = this.createTableForTestFilter(dbName, tableName1, owner1, lastAccessTime1, true);
            Table table2 = this.createTableForTestFilter(dbName, tableName2, owner2, lastAccessTime2, true);
            Table table3 = this.createTableForTestFilter(dbName, tableName3, owner1, lastAccessTime2, false);
            String filter = "hive_filter_field_owner__ like \".*Owner.*\" and hive_filter_field_owner__ like  \"test.*\"";
            List tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)tableNames.size(), (long)3L);
            assert (tableNames.contains(table1.getTableName()));
            assert (tableNames.contains(table2.getTableName()));
            assert (tableNames.contains(table3.getTableName()));
            filter = "hive_filter_field_owner__ = \"testOwner1\"";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)2L, (long)tableNames.size());
            assert (tableNames.contains(table1.getTableName()));
            assert (tableNames.contains(table3.getTableName()));
            filter = "hive_filter_field_last_access__ < 90";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)2L, (long)tableNames.size());
            assert (tableNames.contains(table2.getTableName()));
            assert (tableNames.contains(table3.getTableName()));
            filter = "hive_filter_field_last_access__ > 90";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)0L, (long)tableNames.size());
            filter = "hive_filter_field_params__test_param_2 LIKE \"50\"";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)2L, (long)tableNames.size());
            assert (tableNames.contains(table1.getTableName()));
            assert (tableNames.contains(table2.getTableName()));
            filter = "hive_filter_field_params__test_param_2 LIKE \"75\"";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)0L, (long)tableNames.size());
            filter = "hive_filter_field_params__key_dne LIKE \"50\"";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)0L, (long)tableNames.size());
            filter = "hive_filter_field_params__test_param_1 NOT LIKE \"yellow\"";
            filter = "hive_filter_field_params__test_param_1 NOT LIKE \"yellow\"";
            filter = "hive_filter_field_owner__ = \"testOwner1\" and (hive_filter_field_last_access__ = 30 or hive_filter_field_params__test_param_1 LIKE \"hi\")";
            tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            Assert.assertEquals((long)2L, (long)tableNames.size());
            assert (tableNames.contains(table1.getTableName()));
            assert (tableNames.contains(table3.getTableName()));
            MetaException me = null;
            try {
                filter = "badKey = \"testOwner1\"";
                tableNames = client.listTableNamesByFilter(dbName, filter, (short)-1);
            }
            catch (MetaException e) {
                me = e;
            }
            Assert.assertNotNull((Object)((Object)me));
            Assert.assertTrue((String)"Bad filter key test", (boolean)me.getMessage().contains("Invalid key name in filter"));
            client.dropTable(dbName, tableName1);
            client.dropTable(dbName, tableName2);
            client.dropTable(dbName, tableName3);
            client.dropDatabase(dbName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTableFilter() failed.");
            throw e;
        }
    }

    private Table createTableForTestFilter(String dbName, String tableName, String owner, int lastAccessTime, boolean hasSecondParam) throws Exception {
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("test_param_1", "hi");
        if (hasSecondParam) {
            tableParams.put("test_param_2", "50");
        }
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("name", "string")).addCol("income", "int")).addPartCol("ds", "string").addPartCol("hr", "int").setTableParams(tableParams).setOwner(owner).setLastAccessTime(lastAccessTime).create((IMetaStoreClient)client, conf);
        if (isThriftClient) {
            tbl = client.getTable(dbName, tableName);
        }
        return tbl;
    }

    @Test
    public void testConcurrentMetastores() throws Exception {
        String dbName = "concurrentdb";
        String tblName = "concurrenttbl";
        String renameTblName = "rename_concurrenttbl";
        try {
            this.cleanUp(dbName, tblName, null);
            this.createDb(dbName);
            Table tbl1 = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("c1", "string")).addCol("c2", "int")).create((IMetaStoreClient)client, conf);
            Table tbl2 = client.getTable(dbName, tblName);
            Assert.assertEquals((String)"Client returned table with different name.", (Object)tbl2.getTableName(), (Object)tblName);
            this.updateTableNameInDB(tblName, renameTblName);
            Table tbl3 = client.getTable(dbName, renameTblName);
            Assert.assertEquals((String)"Client returned table with different name after rename.", (Object)tbl3.getTableName(), (Object)renameTblName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testConcurrentMetastores() failed.");
            throw e;
        }
        finally {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
    }

    @Test
    public void testSimpleFunction() throws Exception {
        String dbName = "test_db";
        String funcName = "test_func";
        String className = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
        String owner = "test_owner";
        int N_FUNCTIONS = 5;
        PrincipalType ownerType = PrincipalType.USER;
        int createTime = (int)(System.currentTimeMillis() / 1000L);
        FunctionType funcType = FunctionType.JAVA;
        try {
            this.cleanUp(dbName, null, null);
            for (Function f : client.getAllFunctions().getFunctions()) {
                client.dropFunction(f.getDbName(), f.getFunctionName());
            }
            this.createDb(dbName);
            for (int i = 0; i < 5; ++i) {
                this.createFunction(dbName, funcName + "_" + i, className, owner, ownerType, createTime, funcType, null);
            }
            Function func = client.getFunction(dbName, funcName + "_0");
            Assert.assertEquals((String)"function db name", (Object)dbName, (Object)func.getDbName());
            Assert.assertEquals((String)"function name", (Object)(funcName + "_0"), (Object)func.getFunctionName());
            Assert.assertEquals((String)"function class name", (Object)className, (Object)func.getClassName());
            Assert.assertEquals((String)"function owner name", (Object)owner, (Object)func.getOwnerName());
            Assert.assertEquals((String)"function owner type", (Object)PrincipalType.USER, (Object)func.getOwnerType());
            Assert.assertEquals((String)"function type", (Object)funcType, (Object)func.getFunctionType());
            List resources = func.getResourceUris();
            Assert.assertTrue((String)"function resources", (resources == null || resources.size() == 0 ? 1 : 0) != 0);
            boolean gotException = false;
            try {
                func = client.getFunction(dbName, "nonexistent_func");
            }
            catch (NoSuchObjectException e) {
                gotException = true;
            }
            Assert.assertEquals((Object)true, (Object)gotException);
            GetAllFunctionsResponse response = client.getAllFunctions();
            List allFunctions = response.getFunctions();
            Assert.assertEquals((long)5L, (long)allFunctions.size());
            Assert.assertEquals((Object)(funcName + "_3"), (Object)((Function)allFunctions.get(3)).getFunctionName());
            List funcs = client.getFunctions(dbName, "*_func_*");
            Assert.assertEquals((long)5L, (long)funcs.size());
            Assert.assertEquals((Object)(funcName + "_0"), funcs.get(0));
            funcs = client.getFunctions(dbName, "nonexistent_func");
            Assert.assertEquals((long)0L, (long)funcs.size());
            for (int i = 0; i < 5; ++i) {
                client.dropFunction(dbName, funcName + "_" + i);
            }
            funcs = client.getFunctions(dbName, funcName);
            Assert.assertEquals((long)0L, (long)funcs.size());
            response = client.getAllFunctions();
            allFunctions = response.getFunctions();
            Assert.assertEquals((long)0L, (long)allFunctions.size());
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testConcurrentMetastores() failed.");
            throw e;
        }
        finally {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
    }

    @Test
    public void testFunctionWithResources() throws Exception {
        String dbName = "test_db2";
        String funcName = "test_func";
        String className = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
        String owner = "test_owner";
        PrincipalType ownerType = PrincipalType.USER;
        int createTime = (int)(System.currentTimeMillis() / 1000L);
        FunctionType funcType = FunctionType.JAVA;
        ArrayList<ResourceUri> resList = new ArrayList<ResourceUri>();
        resList.add(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar"));
        resList.add(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt"));
        resList.add(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz"));
        try {
            this.cleanUp(dbName, null, null);
            this.createDb(dbName);
            this.createFunction(dbName, funcName, className, owner, ownerType, createTime, funcType, resList);
            Function func = client.getFunction(dbName, funcName);
            Assert.assertEquals((String)"function db name", (Object)dbName, (Object)func.getDbName());
            Assert.assertEquals((String)"function name", (Object)funcName, (Object)func.getFunctionName());
            Assert.assertEquals((String)"function class name", (Object)className, (Object)func.getClassName());
            Assert.assertEquals((String)"function owner name", (Object)owner, (Object)func.getOwnerName());
            Assert.assertEquals((String)"function owner type", (Object)PrincipalType.USER, (Object)func.getOwnerType());
            Assert.assertEquals((String)"function type", (Object)funcType, (Object)func.getFunctionType());
            List resources = func.getResourceUris();
            Assert.assertEquals((String)"Resource list size", (long)resList.size(), (long)resources.size());
            for (ResourceUri res : resources) {
                Assert.assertTrue((String)("Matching resource " + res.getResourceType() + " " + res.getUri()), (resList.indexOf(res) >= 0 ? 1 : 0) != 0);
            }
            client.dropFunction(dbName, funcName);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testConcurrentMetastores() failed.");
            throw e;
        }
        finally {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
    }

    private void updateTableNameInDB(String oldTableName, String newTableName) throws SQLException {
        String connectionStr = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        Connection conn = DriverManager.getConnection(connectionStr);
        PreparedStatement stmt = conn.prepareStatement("UPDATE TBLS SET tbl_name = '" + newTableName + "' WHERE tbl_name = '" + oldTableName + "'");
        stmt.executeUpdate();
    }

    private void cleanUp(String dbName, String tableName, String typeName) throws Exception {
        if (dbName != null && tableName != null) {
            client.dropTable(dbName, tableName);
        }
        if (dbName != null) {
            TestHiveMetaStore.silentDropDatabase(dbName);
        }
        if (typeName != null) {
            client.dropType(typeName);
        }
    }

    private Database createDb(String dbName) throws Exception {
        if (null == dbName) {
            return null;
        }
        return new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
    }

    private Type createType(String typeName, Map<String, String> fields) throws Throwable {
        Type typ1 = new Type();
        typ1.setName(typeName);
        typ1.setFields(new ArrayList(fields.size()));
        for (String fieldName : fields.keySet()) {
            typ1.getFields().add(new FieldSchema(fieldName, fields.get(fieldName), ""));
        }
        client.createType(typ1);
        return typ1;
    }

    private void createTable(String dbName, String tableName) throws TException {
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("foo", "string")).addCol("bar", "string")).create((IMetaStoreClient)client, conf);
    }

    private void createMaterializedView(String dbName, String tableName, Set<String> tablesUsed) throws TException {
        Table t = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).setType(TableType.MATERIALIZED_VIEW.name()).addMaterializedViewReferencedTables(tablesUsed).addCol("foo", "string")).addCol("bar", "string")).create((IMetaStoreClient)client, conf);
    }

    private List<Partition> createPartitions(String dbName, Table tbl, List<List<String>> values) throws Throwable {
        int i = 1;
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (List<String> vals : values) {
            Partition part = TestHiveMetaStore.makePartitionObject(dbName, tbl.getTableName(), vals, tbl, "/part" + i);
            ++i;
            boolean exceptionThrown = false;
            try {
                Partition partition = client.getPartition(dbName, tbl.getTableName(), vals);
            }
            catch (Exception e) {
                Assert.assertEquals((String)"partition should not have existed", NoSuchObjectException.class, e.getClass());
                exceptionThrown = true;
            }
            Assert.assertTrue((String)"getPartition() should have thrown NoSuchObjectException", (boolean)exceptionThrown);
            Partition retp = client.add_partition(part);
            Assert.assertNotNull((String)("Unable to create partition " + part), (Object)retp);
            partitions.add(retp);
        }
        return partitions;
    }

    private void createMultiPartitionTableSchema(String dbName, String tblName, String typeName, List<List<String>> values) throws Throwable {
        this.createDb(dbName);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", "string");
        fields.put("income", "int");
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string")).addCol("income", "int")).addPartCol("ds", "string").addPartCol("hr", "string").create((IMetaStoreClient)client, conf);
        if (isThriftClient) {
            tbl = client.getTable(dbName, tblName);
        }
        this.createPartitions(dbName, tbl, values);
    }

    @Test
    public void testDBOwner() throws TException {
        Database db = client.getDatabase("default");
        Assert.assertEquals((Object)db.getOwnerName(), (Object)"public");
        Assert.assertEquals((Object)db.getOwnerType(), (Object)PrincipalType.ROLE);
    }

    @Test
    public void testDBOwnerChange() throws TException {
        String dbName = "alterDbOwner";
        String user1 = "user1";
        String user2 = "user2";
        String role1 = "role1";
        TestHiveMetaStore.silentDropDatabase("alterDbOwner");
        Database db = new DatabaseBuilder().setName("alterDbOwner").setOwnerName("user1").setOwnerType(PrincipalType.USER).create((IMetaStoreClient)client, conf);
        this.checkDbOwnerType("alterDbOwner", "user1", PrincipalType.USER);
        db.setOwnerName("user2");
        client.alterDatabase("alterDbOwner", db);
        this.checkDbOwnerType("alterDbOwner", "user2", PrincipalType.USER);
        db.setOwnerName("role1");
        db.setOwnerType(PrincipalType.ROLE);
        client.alterDatabase("alterDbOwner", db);
        this.checkDbOwnerType("alterDbOwner", "role1", PrincipalType.ROLE);
    }

    @Test
    public void testGetTableObjects() throws Exception {
        String dbName = "db";
        List<String> tableNames = Arrays.asList("table1", "table2", "table3", "table4", "table5");
        TestHiveMetaStore.silentDropDatabase(dbName);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        for (String tableName : tableNames) {
            this.createTable(dbName, tableName);
        }
        this.createMaterializedView(dbName, "mv1", Sets.newHashSet((Object[])new String[]{"db.table1", "db.table2"}));
        List tableObjs = client.getTableObjectsByName(dbName, tableNames);
        Assert.assertEquals((long)tableNames.size(), (long)tableObjs.size());
        for (Table table : tableObjs) {
            Assert.assertTrue((boolean)tableNames.contains(table.getTableName().toLowerCase()));
        }
        client.dropDatabase(dbName, true, true, true);
    }

    @Test
    public void testDropDatabaseCascadeMVMultiDB() throws Exception {
        String dbName1 = "db1";
        String tableName1 = "table1";
        String dbName2 = "db2";
        String tableName2 = "table2";
        String mvName = "mv1";
        TestHiveMetaStore.silentDropDatabase(dbName1);
        TestHiveMetaStore.silentDropDatabase(dbName2);
        Database db1 = new Database();
        db1.setName(dbName1);
        client.createDatabase(db1);
        this.createTable(dbName1, tableName1);
        Database db2 = new Database();
        db2.setName(dbName2);
        client.createDatabase(db2);
        this.createTable(dbName2, tableName2);
        this.createMaterializedView(dbName2, mvName, Sets.newHashSet((Object[])new String[]{"db1.table1", "db2.table2"}));
        boolean exceptionFound = false;
        try {
            client.dropDatabase(dbName1, true, true, true);
        }
        catch (Exception e) {
            exceptionFound = true;
        }
        Assert.assertTrue((boolean)exceptionFound);
        client.dropDatabase(dbName2, true, true, true);
        client.dropDatabase(dbName1, true, true, true);
    }

    @Test
    public void testDBLocationChange() throws IOException, TException {
        String dbName = "alterDbLocation";
        String defaultUri = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/default_location.db";
        String newUri = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/new_location.db";
        new DatabaseBuilder().setName("alterDbLocation").setLocation(defaultUri).create((IMetaStoreClient)client, conf);
        Database db = client.getDatabase("alterDbLocation");
        Assert.assertEquals((String)"Incorrect default location of the database", (Object)warehouse.getDnsPath(new Path(defaultUri)).toString(), (Object)db.getLocationUri());
        db.setLocationUri(newUri);
        client.alterDatabase("alterDbLocation", db);
        db = client.getDatabase("alterDbLocation");
        Assert.assertEquals((String)"Incorrect new location of the database", (Object)warehouse.getDnsPath(new Path(newUri)).toString(), (Object)db.getLocationUri());
        client.dropDatabase("alterDbLocation");
        TestHiveMetaStore.silentDropDatabase("alterDbLocation");
    }

    private void checkDbOwnerType(String dbName, String ownerName, PrincipalType ownerType) throws TException {
        Database db = client.getDatabase(dbName);
        Assert.assertEquals((String)"Owner name", (Object)ownerName, (Object)db.getOwnerName());
        Assert.assertEquals((String)"Owner type", (Object)ownerType, (Object)db.getOwnerType());
    }

    private void createFunction(String dbName, String funcName, String className, String ownerName, PrincipalType ownerType, int createTime, FunctionType functionType, List<ResourceUri> resources) throws Exception {
        Function func = new Function(funcName, dbName, className, ownerName, ownerType, createTime, functionType, resources);
        client.createFunction(func);
    }

    @Test
    public void testRetriableClientWithConnLifetime() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_LIFETIME, (long)4L, (TimeUnit)TimeUnit.SECONDS);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        long timeout = 5000L;
        IMetaStoreClient client = RetryingMetaStoreClient.getProxy((Configuration)conf, (HiveMetaHookLoader)this.getHookLoader(), (String)HiveMetaStoreClient.class.getName());
        client.getAllDatabases();
        client.close();
        client = RetryingMetaStoreClient.getProxy((Configuration)conf, (HiveMetaHookLoader)this.getHookLoader(), (String)HiveMetaStoreClient.class.getName());
        Thread.sleep(timeout);
        client.getAllDatabases();
        client.close();
    }

    @Test
    public void testJDOPersistanceManagerCleanup() throws Exception {
        if (!isThriftClient) {
            return;
        }
        int numObjectsBeforeClose = TestHiveMetaStore.getJDOPersistanceManagerCacheSize();
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(conf);
        closingClient.getAllDatabases();
        closingClient.close();
        Thread.sleep(5000L);
        int numObjectsAfterClose = TestHiveMetaStore.getJDOPersistanceManagerCacheSize();
        Assert.assertTrue((numObjectsBeforeClose == numObjectsAfterClose ? 1 : 0) != 0);
        HiveMetaStoreClient nonClosingClient = new HiveMetaStoreClient(conf);
        nonClosingClient.getAllDatabases();
        nonClosingClient.getTTransport().close();
        Thread.sleep(5000L);
        int numObjectsAfterDroppedConnection = TestHiveMetaStore.getJDOPersistanceManagerCacheSize();
        Assert.assertTrue((numObjectsAfterClose == numObjectsAfterDroppedConnection ? 1 : 0) != 0);
    }

    private static int getJDOPersistanceManagerCacheSize() {
        try {
            Field pmf = ObjectStore.class.getDeclaredField("pmf");
            if (pmf != null) {
                pmf.setAccessible(true);
                JDOPersistenceManagerFactory jdoPmf = (JDOPersistenceManagerFactory)pmf.get(null);
                Field pmCache = JDOPersistenceManagerFactory.class.getDeclaredField("pmCache");
                if (pmCache != null) {
                    pmCache.setAccessible(true);
                    Set pmCacheObj = (Set)pmCache.get(jdoPmf);
                    if (pmCacheObj != null) {
                        return pmCacheObj.size();
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return -1;
    }

    private HiveMetaHookLoader getHookLoader() {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(Table tbl) throws MetaException {
                return null;
            }
        };
        return hookLoader;
    }

    @Test
    public void testValidateTableCols() throws Throwable {
        try {
            String dbName = "compdb";
            String tblName = "comptbl";
            client.dropTable(dbName, tblName);
            TestHiveMetaStore.silentDropDatabase(dbName);
            new DatabaseBuilder().setName(dbName).setDescription("Validate Table Columns test").create((IMetaStoreClient)client, conf);
            Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("name", "string")).addCol("income", "int")).create((IMetaStoreClient)client, conf);
            if (isThriftClient) {
                tbl = client.getTable(dbName, tblName);
            }
            ArrayList expectedCols = Lists.newArrayList();
            expectedCols.add("name");
            ObjectStore objStore = new ObjectStore();
            try {
                objStore.validateTableCols(tbl, (List)expectedCols);
            }
            catch (MetaException ex) {
                throw new RuntimeException(ex);
            }
            expectedCols.add("doesntExist");
            boolean exceptionFound = false;
            try {
                objStore.validateTableCols(tbl, (List)expectedCols);
            }
            catch (MetaException ex) {
                Assert.assertEquals((Object)ex.getMessage(), (Object)"Column doesntExist doesn't exist in table comptbl in database compdb");
                exceptionFound = true;
            }
            Assert.assertTrue((boolean)exceptionFound);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testValidateTableCols() failed.");
            throw e;
        }
    }

    @Test
    public void testGetMetastoreUuid() throws Throwable {
        String uuid = client.getMetastoreDbUuid();
        Assert.assertNotNull((Object)uuid);
    }

    @Test
    public void testGetUUIDInParallel() throws Exception {
        int numThreads = 5;
        int parallelCalls = 10;
        final int numAPICallsPerThread = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        ArrayList<Future<List<String>>> futures = new ArrayList<Future<List<String>>>();
        for (int n = 0; n < parallelCalls; ++n) {
            futures.add(executorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    HiveMetaStoreClient testClient = new HiveMetaStoreClient(conf);
                    ArrayList<String> uuids = new ArrayList<String>(10);
                    for (int i = 0; i < numAPICallsPerThread; ++i) {
                        String uuid = testClient.getMetastoreDbUuid();
                        uuids.add(uuid);
                    }
                    return uuids;
                }
            }));
        }
        String firstUUID = null;
        ArrayList<String> allUuids = new ArrayList<String>();
        for (Future future : futures) {
            for (String uuid : (List)future.get()) {
                if (firstUUID == null) {
                    firstUUID = uuid;
                } else {
                    Assert.assertEquals((Object)firstUUID.toLowerCase(), (Object)uuid.toLowerCase());
                }
                allUuids.add(uuid);
            }
        }
        int size = allUuids.size();
        Assert.assertEquals((long)(numAPICallsPerThread * parallelCalls), (long)size);
    }

    static {
        isThriftClient = false;
    }
}

