/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreDataManager {
    protected Map<String, StoreData> storeDataByName = new ConcurrentHashMap<String, StoreData>();
    protected Map<String, StoreData> savedStoreDataByName;

    public void clear() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("032002"));
        }
        this.storeDataByName.clear();
    }

    public void deregisterClass(String className) {
        this.storeDataByName.remove(className);
    }

    protected void registerStoreData(StoreData data) {
        if (this.storeDataByName.containsKey(data.getName())) {
            return;
        }
        this.storeDataByName.put(data.getName(), data);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("032001", data));
        }
    }

    public StoreData[] getStoreDataForProperties(String key1, Object value1, String key2, Object value2) {
        HashSet<StoreData> results = null;
        Collection<StoreData> storeDatas = this.storeDataByName.values();
        for (StoreData data : storeDatas) {
            if (data.getProperties() == null) continue;
            Object prop1Value = data.getProperties().get(key1);
            Object prop2Value = data.getProperties().get(key2);
            if (prop1Value == null || !prop1Value.equals(value1) || prop2Value == null || !prop2Value.equals(value2)) continue;
            if (results == null) {
                results = new HashSet<StoreData>();
            }
            results.add(data);
        }
        if (results != null) {
            return results.toArray(new StoreData[results.size()]);
        }
        return null;
    }

    public boolean managesClass(String className) {
        return this.storeDataByName.containsKey(className);
    }

    public Collection<StoreData> getManagedStoreData() {
        return Collections.unmodifiableCollection(this.storeDataByName.values());
    }

    public StoreData get(String className) {
        return this.storeDataByName.get(className);
    }

    public StoreData get(AbstractMemberMetaData mmd) {
        return this.storeDataByName.get(mmd.getFullFieldName());
    }

    public int size() {
        return this.storeDataByName.size();
    }

    public void begin() {
        this.savedStoreDataByName = new ConcurrentHashMap<String, StoreData>(this.storeDataByName);
    }

    public void rollback() {
        this.storeDataByName = this.savedStoreDataByName;
        this.savedStoreDataByName = null;
    }

    public void commit() {
        this.savedStoreDataByName = null;
    }
}

