/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestRuntimeStats
extends MetaStoreClientTest {
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private String metastoreName;

    public TestRuntimeStats(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metastoreName = name;
        this.metaStore = metaStore;
        this.metaStore.start();
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
        this.client = null;
    }

    @Test
    public void testRuntimeStatHandling() throws Exception {
        List<RuntimeStat> rs0 = this.getRuntimeStats();
        Assert.assertNotNull(rs0);
        Assert.assertEquals((long)0L, (long)rs0.size());
        RuntimeStat stat = this.createStat(1);
        this.client.addRuntimeStat(stat);
        List<RuntimeStat> rs1 = this.getRuntimeStats();
        Assert.assertNotNull(rs1);
        Assert.assertEquals((long)1L, (long)rs1.size());
        Assert.assertArrayEquals((byte[])stat.getPayload(), (byte[])rs1.get(0).getPayload());
        Assert.assertEquals((long)stat.getWeight(), (long)rs1.get(0).getWeight());
        Assert.assertNotEquals((long)stat.getCreateTime(), (long)rs1.get(0).getCreateTime());
        this.client.addRuntimeStat(this.createStat(2));
        this.client.addRuntimeStat(this.createStat(3));
        this.client.addRuntimeStat(this.createStat(4));
        List<RuntimeStat> rs2 = this.getRuntimeStats();
        Assert.assertEquals((long)4L, (long)rs2.size());
    }

    @Test
    public void testCleanup() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteRuntimeStats(0);
        objStore.addRuntimeStat(this.createStat(1));
        Thread.sleep(2000L);
        objStore.addRuntimeStat(this.createStat(2));
        int deleted = objStore.deleteRuntimeStats(1);
        Assert.assertEquals((long)1L, (long)deleted);
        List<RuntimeStat> all = this.getRuntimeStats();
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((long)2L, (long)all.get(0).getWeight());
    }

    @Test
    public void testReading() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteRuntimeStats(0);
        objStore.addRuntimeStat(this.createStat(1));
        Thread.sleep(1000L);
        objStore.addRuntimeStat(this.createStat(2));
        Thread.sleep(1000L);
        objStore.addRuntimeStat(this.createStat(3));
        List g0 = this.client.getRuntimeStats(3, -1);
        Assert.assertEquals((long)1L, (long)g0.size());
        Assert.assertEquals((long)3L, (long)((RuntimeStat)g0.get(0)).getWeight());
        int ct = ((RuntimeStat)g0.get(0)).getCreateTime();
        List g1 = this.client.getRuntimeStats(3, ct);
        Assert.assertEquals((long)2L, (long)g1.size());
        Assert.assertEquals((long)2L, (long)((RuntimeStat)g1.get(0)).getWeight());
        Assert.assertEquals((long)1L, (long)((RuntimeStat)g1.get(1)).getWeight());
        int ct1 = ((RuntimeStat)g1.get(1)).getCreateTime();
        List g2 = this.client.getRuntimeStats(3, ct1);
        Assert.assertEquals((long)0L, (long)g2.size());
    }

    private List<RuntimeStat> getRuntimeStats() throws Exception {
        return this.client.getRuntimeStats(-1, -1);
    }

    private RuntimeStat createStat(int w) {
        byte[] payload = new byte[w];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 120;
        }
        RuntimeStat stat = new RuntimeStat();
        stat.setWeight(w);
        stat.setPayload(payload);
        return stat;
    }
}

