/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.skyscreamer.jsonassert.JSONAssert;

@Category(value={MetastoreUnitTest.class})
public class TestJSONMessageDeserializer {
    @Test
    public void shouldNotSerializePropertiesNotAnnotated() throws IOException, JSONException {
        MyClass obj = new MyClass(Integer.MAX_VALUE, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("a", "a");
                this.put("b", "b");
            }
        }, Long.MAX_VALUE);
        String json = JSONMessageDeserializer.mapper.writeValueAsString((Object)obj);
        JSONAssert.assertEquals((String)"{\"a\":2147483647,\"map\":{\"b\":\"b\",\"a\":\"a\"},\"l\":9223372036854775807}", (String)json, (boolean)false);
    }

    @Test
    public void shouldDeserializeJsonStringToObject() throws IOException {
        String json = "{\"a\":47,\"map\":{\"a\":\"a\",\"b\":\"a value for b\"},\"l\":98}";
        MyClass actual = (MyClass)JSONMessageDeserializer.mapper.readValue(json, MyClass.class);
        MyClass expected = new MyClass(47, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("a", "a");
                this.put("b", "a value for b");
            }
        }, 98L);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static class MyClass {
        @JsonProperty
        private int a;
        @JsonProperty
        private Map<String, String> map;
        private long l;
        private String shouldNotSerialize = "shouldNotSerialize";

        MyClass() {
        }

        MyClass(int a, Map<String, String> map, long l) {
            this.a = a;
            this.map = map;
            this.l = l;
        }

        @JsonProperty
        long getL() {
            return this.l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyClass myClass = (MyClass)o;
            if (this.a != myClass.a) {
                return false;
            }
            if (this.l != myClass.l) {
                return false;
            }
            if (!this.map.equals(myClass.map)) {
                return false;
            }
            return this.shouldNotSerialize.equals(myClass.shouldNotSerialize);
        }

        public int hashCode() {
            int result = this.a;
            result = 31 * result + this.map.hashCode();
            result = 31 * result + (int)(this.l ^ this.l >>> 32);
            result = 31 * result + this.shouldNotSerialize.hashCode();
            return result;
        }
    }
}

