/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.MetastoreSchemaTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbInstallBase {
    private static final Logger LOG = LoggerFactory.getLogger(DbInstallBase.class);
    private static final String HIVE_USER = "hiveuser";
    protected static final String HIVE_DB = "hivedb";
    private static final String FIRST_VERSION = "1.2.0";
    private static final int MAX_STARTUP_WAIT = 300000;
    private String metastoreHome;

    protected abstract String getDockerContainerName();

    protected abstract String getDockerImageName();

    protected abstract String[] getDockerAdditionalArgs();

    protected abstract String getDbType();

    protected abstract String getDbRootUser();

    protected abstract String getDbRootPassword();

    protected abstract String getJdbcDriver();

    protected abstract String getJdbcUrl();

    protected abstract String getInitialJdbcUrl();

    protected abstract boolean isContainerReady(String var1);

    protected abstract String getHivePassword();

    @Before
    public void runDockerContainer() throws IOException, InterruptedException {
        ProcessResults pr;
        if (this.runCmdAndPrintStreams(this.buildRunCmd(), 600L) != 0) {
            throw new RuntimeException("Unable to start docker container");
        }
        long startTime = System.currentTimeMillis();
        do {
            Thread.sleep(5000L);
            pr = this.runCmd(this.buildLogCmd(), 5L);
            if (pr.rc == 0) continue;
            throw new RuntimeException("Failed to get docker logs");
        } while (startTime + 300000L >= System.currentTimeMillis() && !this.isContainerReady(pr.stdout));
        if (startTime + 300000L < System.currentTimeMillis()) {
            throw new RuntimeException("Container failed to be ready in 300 seconds");
        }
        MetastoreSchemaTool.homeDir = this.metastoreHome = System.getProperty("test.tmp.dir", "target/tmp");
    }

    @After
    public void stopAndRmDockerContainer() throws IOException, InterruptedException {
        if ("true".equalsIgnoreCase(System.getProperty("metastore.itest.no.stop.container"))) {
            LOG.warn("Not stopping container " + this.getDockerContainerName() + " at user request, please be sure to shut it down before rerunning the test.");
            return;
        }
        if (this.runCmdAndPrintStreams(this.buildStopCmd(), 60L) != 0) {
            throw new RuntimeException("Unable to stop docker container");
        }
        if (this.runCmdAndPrintStreams(this.buildRmCmd(), 15L) != 0) {
            throw new RuntimeException("Unable to remove docker container");
        }
    }

    private ProcessResults runCmd(String[] cmd, long secondsToWait) throws IOException, InterruptedException {
        LOG.info("Going to run: " + StringUtils.join((Object[])cmd, (String)" "));
        Process proc = Runtime.getRuntime().exec(cmd);
        if (!proc.waitFor(secondsToWait, TimeUnit.SECONDS)) {
            throw new RuntimeException("Process " + cmd[0] + " failed to run in " + secondsToWait + " seconds");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StringBuilder lines = new StringBuilder();
        reader.lines().forEach(s -> lines.append((String)s).append('\n'));
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        StringBuilder errLines = new StringBuilder();
        reader.lines().forEach(s -> errLines.append((String)s).append('\n'));
        return new ProcessResults(lines.toString(), errLines.toString(), proc.exitValue());
    }

    private int runCmdAndPrintStreams(String[] cmd, long secondsToWait) throws InterruptedException, IOException {
        ProcessResults results = this.runCmd(cmd, secondsToWait);
        LOG.info("Stdout from proc: " + results.stdout);
        LOG.info("Stderr from proc: " + results.stderr);
        return results.rc;
    }

    private int createUser() {
        return MetastoreSchemaTool.run((String[])this.buildArray("-createUser", "-dbType", this.getDbType(), "-userName", this.getDbRootUser(), "-passWord", this.getDbRootPassword(), "-hiveUser", HIVE_USER, "-hivePassword", this.getHivePassword(), "-hiveDb", HIVE_DB, "-url", this.getInitialJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    private int installLatest() {
        return MetastoreSchemaTool.run((String[])this.buildArray("-initSchema", "-dbType", this.getDbType(), "-userName", HIVE_USER, "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    private int installAVersion(String version) {
        return MetastoreSchemaTool.run((String[])this.buildArray("-initSchemaTo", version, "-dbType", this.getDbType(), "-userName", HIVE_USER, "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    private int upgradeToLatest() {
        return MetastoreSchemaTool.run((String[])this.buildArray("-upgradeSchema", "-dbType", this.getDbType(), "-userName", HIVE_USER, "-passWord", this.getHivePassword(), "-url", this.getJdbcUrl(), "-driver", this.getJdbcDriver()));
    }

    protected String[] buildArray(String ... strs) {
        return strs;
    }

    private String getCurrentVersionMinusOne() throws HiveMetaException {
        List scripts = MetaStoreSchemaInfoFactory.get((Configuration)MetastoreConf.newMetastoreConf(), (String)this.metastoreHome, (String)this.getDbType()).getUpgradeScripts(FIRST_VERSION);
        Assert.assertTrue((scripts.size() > 0 ? 1 : 0) != 0);
        String lastUpgradePath = (String)scripts.get(scripts.size() - 1);
        String version = lastUpgradePath.split("-")[1];
        LOG.info("Current version minus 1 is " + version);
        return version;
    }

    @Test
    public void install() {
        Assert.assertEquals((long)0L, (long)this.createUser());
        Assert.assertEquals((long)0L, (long)this.installLatest());
    }

    @Test
    public void upgrade() throws HiveMetaException {
        Assert.assertEquals((long)0L, (long)this.createUser());
        Assert.assertEquals((long)0L, (long)this.installAVersion(FIRST_VERSION));
        Assert.assertEquals((long)0L, (long)this.upgradeToLatest());
    }

    private String[] buildRunCmd() {
        ArrayList<String> cmd = new ArrayList<String>(4 + this.getDockerAdditionalArgs().length);
        cmd.add("docker");
        cmd.add("run");
        cmd.add("--name");
        cmd.add(this.getDockerContainerName());
        cmd.addAll(Arrays.asList(this.getDockerAdditionalArgs()));
        cmd.add(this.getDockerImageName());
        return cmd.toArray(new String[cmd.size()]);
    }

    private String[] buildStopCmd() {
        return this.buildArray("docker", "stop", this.getDockerContainerName());
    }

    private String[] buildRmCmd() {
        return this.buildArray("docker", "rm", this.getDockerContainerName());
    }

    private String[] buildLogCmd() {
        return this.buildArray("docker", "logs", this.getDockerContainerName());
    }

    private static class ProcessResults {
        final String stdout;
        final String stderr;
        final int rc;

        public ProcessResults(String stdout, String stderr, int rc) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.rc = rc;
        }
    }
}

