/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetaStoreTxns {
    private final Configuration conf = MetastoreConf.newMetastoreConf();
    private IMetaStoreClient client;

    @Test
    public void testTxns() throws Exception {
        List tids = this.client.openTxns("me", 3).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        Assert.assertEquals((long)2L, (long)((Long)tids.get(1)));
        Assert.assertEquals((long)3L, (long)((Long)tids.get(2)));
        this.client.rollbackTxn(1L);
        this.client.commitTxn(2L);
        ValidTxnList validTxns = this.client.getValidTxns();
        Assert.assertFalse((boolean)validTxns.isTxnValid(1L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(2L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(3L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(4L));
    }

    @Test
    public void testOpenTxnNotExcluded() throws Exception {
        List tids = this.client.openTxns("me", 3).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        Assert.assertEquals((long)2L, (long)((Long)tids.get(1)));
        Assert.assertEquals((long)3L, (long)((Long)tids.get(2)));
        this.client.rollbackTxn(1L);
        this.client.commitTxn(2L);
        ValidTxnList validTxns = this.client.getValidTxns(3L);
        Assert.assertFalse((boolean)validTxns.isTxnValid(1L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(2L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(3L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(4L));
    }

    @Test
    public void testTxnRange() throws Exception {
        ValidTxnList validTxns = this.client.getValidTxns();
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)validTxns.isTxnRangeValid(1L, 3L));
        List tids = this.client.openTxns("me", 5).getTxn_ids();
        HeartbeatTxnRangeResponse rsp = this.client.heartbeatTxnRange(1L, 5L);
        Assert.assertEquals((long)0L, (long)rsp.getNosuch().size());
        Assert.assertEquals((long)0L, (long)rsp.getAborted().size());
        this.client.rollbackTxn(1L);
        this.client.commitTxn(2L);
        this.client.commitTxn(3L);
        this.client.commitTxn(4L);
        validTxns = this.client.getValidTxns();
        System.out.println("validTxns = " + validTxns);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(2L, 2L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(2L, 3L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(2L, 4L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(3L, 4L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(1L, 4L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(2L, 5L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(1L, 2L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(4L, 5L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)validTxns.isTxnRangeValid(1L, 1L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)validTxns.isTxnRangeValid(5L, 10L));
        validTxns = new ValidReadTxnList("10:5:4,5,6:");
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)validTxns.isTxnRangeValid(4L, 6L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(7L, 10L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(7L, 11L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(3L, 6L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(4L, 7L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.SOME, (Object)validTxns.isTxnRangeValid(1L, 12L));
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)validTxns.isTxnRangeValid(1L, 3L));
    }

    @Test
    public void testLocks() throws Exception {
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("mytable").setPartitionName("mypartition").setExclusive().setOperationType(DataOperationType.NO_TXN).build());
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("yourtable").setSemiShared().setOperationType(DataOperationType.NO_TXN).build());
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("yourdb").setOperationType(DataOperationType.NO_TXN).setShared().build());
        rqstBuilder.setUser("fred");
        LockResponse res = this.client.lock(rqstBuilder.build());
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        res = this.client.checkLock(1L);
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        this.client.heartbeat(0L, 1L);
        this.client.unlock(1L);
    }

    @Test
    public void testLocksWithTxn() throws Exception {
        long txnid = this.client.openTxn("me");
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        rqstBuilder.setTransactionId(txnid).addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("mytable").setPartitionName("mypartition").setSemiShared().setOperationType(DataOperationType.UPDATE).build()).addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("yourtable").setSemiShared().setOperationType(DataOperationType.UPDATE).build()).addLockComponent(new LockComponentBuilder().setDbName("yourdb").setShared().setOperationType(DataOperationType.SELECT).build()).setUser("fred");
        LockResponse res = this.client.lock(rqstBuilder.build());
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        res = this.client.checkLock(1L);
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        this.client.heartbeat(txnid, 1L);
        this.client.commitTxn(txnid);
    }

    @Test
    public void stringifyValidTxns() throws Exception {
        ValidReadTxnList validTxns = new ValidReadTxnList("1:9223372036854775807::");
        String asString = validTxns.toString();
        Assert.assertEquals((Object)"1:9223372036854775807::", (Object)asString);
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)1L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        asString = validTxns.toString();
        Assert.assertEquals((Object)"1:9223372036854775807::", (Object)asString);
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)1L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        validTxns = new ValidReadTxnList("10:3:5:3");
        asString = validTxns.toString();
        if (!asString.equals("10:3:3:5") && !asString.equals("10:3:5:3")) {
            Assert.fail((String)("Unexpected string value " + asString));
        }
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)10L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)2L, (long)validTxns.getInvalidTransactions().length);
        boolean sawThree = false;
        boolean sawFive = false;
        for (long tid : validTxns.getInvalidTransactions()) {
            if (tid == 3L) {
                sawThree = true;
                continue;
            }
            if (tid == 5L) {
                sawFive = true;
                continue;
            }
            Assert.fail((String)("Unexpected value " + tid));
        }
        Assert.assertTrue((boolean)sawThree);
        Assert.assertTrue((boolean)sawFive);
    }

    @Before
    public void setUp() throws Exception {
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        TxnDbUtil.setConfValues((Configuration)this.conf);
        TxnDbUtil.prepDb((Configuration)this.conf);
        this.client = new HiveMetaStoreClient(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TxnDbUtil.cleanDb((Configuration)this.conf);
    }
}

