/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class DoubleColumnMapping
extends AbstractColumnMapping {
    public DoubleColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isDecimalBased() {
        return true;
    }

    @Override
    public int getJDBCType() {
        return 8;
    }

    @Override
    public void setInt(PreparedStatement ps, int param, int value) {
        try {
            ps.setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"int", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public int getInt(ResultSet rs, int param) {
        int value;
        try {
            value = (int)rs.getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"int", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(PreparedStatement ps, int param, long value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"long", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public long getLong(ResultSet rs, int param) {
        long value;
        try {
            value = rs.getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"long", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setDouble(PreparedStatement ps, int param, double value) {
        try {
            ps.setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"double", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public double getDouble(ResultSet rs, int param) {
        double value;
        try {
            value = rs.getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"double", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public float getFloat(ResultSet rs, int param) {
        float value;
        try {
            value = (float)rs.getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"float", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setFloat(PreparedStatement ps, int param, float value) {
        try {
            ps.setDouble(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"float", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setDouble(param, Double.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else if (value instanceof Integer) {
                ps.setDouble(param, ((Integer)value).doubleValue());
            } else if (value instanceof Long) {
                ps.setDouble(param, ((Long)value).doubleValue());
            } else if (value instanceof Short) {
                ps.setDouble(param, ((Short)value).doubleValue());
            } else if (value instanceof Float) {
                ps.setDouble(param, ((Float)value).doubleValue());
            } else if (value instanceof Character) {
                ps.setDouble(param, value.toString().charAt(0));
            } else if (value instanceof BigInteger) {
                ps.setDouble(param, ((BigInteger)value).doubleValue());
            } else if (value instanceof BigDecimal) {
                ps.setDouble(param, ((BigDecimal)value).doubleValue());
            } else if (value instanceof String) {
                ps.setDouble(param, Double.parseDouble((String)value));
            } else {
                ps.setDouble(param, (Double)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Number value;
        try {
            double d = rs.getDouble(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER) ? (Number)(rs.wasNull() ? null : Integer.valueOf((int)d)) : (Number)(this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG) ? (Number)(rs.wasNull() ? null : Long.valueOf((long)d)) : (Number)(this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT) ? (Number)(rs.wasNull() ? null : Float.valueOf((float)d)) : (Number)(rs.wasNull() ? null : Double.valueOf(d))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

