/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.StyleResolver;
import sqlline.BuiltInProperty;
import sqlline.ConnectionMetadata;
import sqlline.DatabaseConnection;
import sqlline.MemoizingSupplier;
import sqlline.SqlLine;
import sqlline.SqlLineOpts;
import sqlline.SqlLineProperty;

public class PromptHandler {
    private static final Map<Character, Supplier<String>> DATE_TIME_FORMATS = Collections.unmodifiableMap(new HashMap<Character, Supplier<String>>(){
        {
            this.put(Character.valueOf('D'), () -> PromptHandler.getFormattedDateTime("yyyy-MM-dd HH:mm:ss.SSS"));
            this.put(Character.valueOf('m'), () -> PromptHandler.getFormattedDateTime("mm"));
            this.put(Character.valueOf('o'), () -> PromptHandler.getFormattedDateTime("MM"));
            this.put(Character.valueOf('O'), () -> PromptHandler.getFormattedDateTime("MMM"));
            this.put(Character.valueOf('P'), () -> PromptHandler.getFormattedDateTime("aa"));
            this.put(Character.valueOf('r'), () -> PromptHandler.getFormattedDateTime("hh:mm"));
            this.put(Character.valueOf('R'), () -> PromptHandler.getFormattedDateTime("HH:mm"));
            this.put(Character.valueOf('s'), () -> PromptHandler.getFormattedDateTime("ss"));
            this.put(Character.valueOf('w'), () -> PromptHandler.getFormattedDateTime("d"));
            this.put(Character.valueOf('W'), () -> PromptHandler.getFormattedDateTime("E"));
            this.put(Character.valueOf('y'), () -> PromptHandler.getFormattedDateTime("YY"));
            this.put(Character.valueOf('Y'), () -> PromptHandler.getFormattedDateTime("YYYY"));
        }
    });
    private static final StyleResolver STYLE_RESOLVER = new StyleResolver(s -> "");
    protected final SqlLine sqlLine;
    static final Supplier<ScriptEngine> SCRIPT_ENGINE_SUPPLIER = new MemoizingSupplier<ScriptEngine>(() -> {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        return engineManager.getEngineByName("nashorn");
    });

    public PromptHandler(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public AttributedString getRightPrompt() {
        int connectionIndex = this.sqlLine.getDatabaseConnections().getIndex();
        String currentPrompt = this.sqlLine.getOpts().isDefault(BuiltInProperty.RIGHT_PROMPT) ? (String)BuiltInProperty.RIGHT_PROMPT.defaultValue() : this.sqlLine.getOpts().get(BuiltInProperty.RIGHT_PROMPT);
        return this.getPrompt(this.sqlLine, connectionIndex, currentPrompt);
    }

    public AttributedString getPrompt() {
        if (!this.sqlLine.getOpts().isDefault(BuiltInProperty.PROMPT_SCRIPT)) {
            String promptScript = this.sqlLine.getOpts().get(BuiltInProperty.PROMPT_SCRIPT);
            return this.getPromptFromScript(this.sqlLine, promptScript);
        }
        String defaultPrompt = String.valueOf(BuiltInProperty.PROMPT.defaultValue());
        String currentPrompt = this.sqlLine.getOpts().get(BuiltInProperty.PROMPT);
        DatabaseConnection dbc = this.sqlLine.getDatabaseConnection();
        boolean useDefaultPrompt = this.sqlLine.getOpts().isDefault(BuiltInProperty.PROMPT);
        if (dbc == null || dbc.getUrl() == null) {
            return useDefaultPrompt ? this.getDefaultPrompt(-1, null, defaultPrompt) : this.getPrompt(this.sqlLine, -1, currentPrompt);
        }
        int connectionIndex = this.sqlLine.getConnectionMetadata().getIndex();
        if (useDefaultPrompt || dbc.getNickname() != null) {
            String nickNameOrUrl = dbc.getNickname() == null ? dbc.getUrl() : dbc.getNickname();
            return this.getDefaultPrompt(connectionIndex, nickNameOrUrl, defaultPrompt);
        }
        return this.getPrompt(this.sqlLine, connectionIndex, currentPrompt);
    }

    private AttributedString getPromptFromScript(SqlLine sqlLine, String promptScript) {
        try {
            ScriptEngine engine = SCRIPT_ENGINE_SUPPLIER.get();
            SimpleBindings bindings = new SimpleBindings();
            ConnectionMetadata meta = sqlLine.getConnectionMetadata();
            bindings.put("connectionIndex", (Object)meta.getIndex());
            bindings.put("databaseProductName", (Object)meta.getDatabaseProductName());
            bindings.put("userName", (Object)meta.getUserName());
            bindings.put("url", (Object)meta.getUrl());
            bindings.put("currentSchema", (Object)meta.getCurrentSchema());
            Object o = engine.eval(promptScript, (Bindings)bindings);
            return new AttributedString((CharSequence)String.valueOf(o));
        }
        catch (ScriptException e) {
            e.printStackTrace();
            return new AttributedString((CharSequence)">");
        }
    }

    protected AttributedString getPrompt(SqlLine sqlLine, int connectionIndex, String prompt) {
        AttributedStringBuilder promptStringBuilder = new AttributedStringBuilder();
        SqlLineOpts opts = sqlLine.getOpts();
        ConnectionMetadata meta = sqlLine.getConnectionMetadata();
        block13: for (int i = 0; i < prompt.length(); ++i) {
            switch (prompt.charAt(i)) {
                case '%': {
                    if (i >= prompt.length() - 1) continue block13;
                    String dateTime = this.formatDateTime(prompt.charAt(i + 1));
                    if (dateTime != null) {
                        promptStringBuilder.append((CharSequence)dateTime);
                    } else {
                        switch (prompt.charAt(i + 1)) {
                            case 'c': {
                                if (connectionIndex < 0) break;
                                promptStringBuilder.append((CharSequence)String.valueOf(connectionIndex));
                                break;
                            }
                            case 'C': {
                                if (connectionIndex < 0) break;
                                promptStringBuilder.append((CharSequence)String.valueOf(connectionIndex)).append((CharSequence)": ");
                                break;
                            }
                            case 'd': {
                                String databaseProductName = meta.getDatabaseProductName();
                                if (databaseProductName == null) break;
                                promptStringBuilder.append((CharSequence)databaseProductName);
                                break;
                            }
                            case 'n': {
                                String userName = meta.getUserName();
                                if (userName == null) break;
                                promptStringBuilder.append((CharSequence)userName);
                                break;
                            }
                            case 'u': {
                                String url = meta.getUrl();
                                if (url == null) break;
                                promptStringBuilder.append((CharSequence)url);
                                break;
                            }
                            case 'S': {
                                String currentSchema = meta.getCurrentSchema();
                                if (currentSchema == null) break;
                                promptStringBuilder.append((CharSequence)currentSchema);
                                break;
                            }
                            case '[': {
                                int closeBracketIndex = prompt.indexOf("%]", i + 2);
                                if (closeBracketIndex > 0) {
                                    String color = prompt.substring(i + 2, closeBracketIndex);
                                    AttributedStyle style = this.resolveStyle(color);
                                    promptStringBuilder.style(style);
                                    i = closeBracketIndex;
                                    break;
                                }
                            }
                            case ':': {
                                SqlLineProperty property;
                                int nextColonIndex = prompt.indexOf(":", i + 2);
                                if (nextColonIndex > 0 && (property = BuiltInProperty.valueOf(prompt.substring(i + 2, nextColonIndex), true)) != null) {
                                    promptStringBuilder.append((CharSequence)opts.get(property));
                                    i = nextColonIndex - 1;
                                    break;
                                }
                            }
                            default: {
                                promptStringBuilder.append(prompt.charAt(i)).append(prompt.charAt(i + 1));
                            }
                        }
                    }
                    ++i;
                    continue block13;
                }
                default: {
                    promptStringBuilder.append(prompt.charAt(i));
                }
            }
        }
        return promptStringBuilder.toAttributedString();
    }

    protected AttributedString getDefaultPrompt(int connectionIndex, String url, String defaultPrompt) {
        String resultPrompt;
        if (url == null || url.length() == 0) {
            return new AttributedString((CharSequence)defaultPrompt);
        }
        if (url.contains(";")) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        if ((resultPrompt = connectionIndex + ": " + url).length() > 45) {
            resultPrompt = resultPrompt.substring(0, 45);
        }
        return new AttributedString((CharSequence)(resultPrompt + "> "));
    }

    protected AttributedStyle resolveStyle(String value) {
        return STYLE_RESOLVER.resolve(value);
    }

    protected String formatDateTime(char c) {
        Supplier<String> dateFormat = DATE_TIME_FORMATS.get(Character.valueOf(c));
        if (dateFormat != null) {
            return dateFormat.get();
        }
        return null;
    }

    private static String getFormattedDateTime(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.ROOT);
        return sdf.format(new Date());
    }
}

