/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;

public class JDOQLQueryHelper {
    static final String[] SINGLE_STRING_KEYWORDS = new String[]{"SELECT", "UNIQUE", "INTO", "FROM", "EXCLUDE", "SUBCLASSES", "WHERE", "VARIABLES", "PARAMETERS", "GROUP", "ORDER", "BY", "RANGE"};
    static final String[] SINGLE_STRING_KEYWORDS_LOWERCASE = new String[]{"select", "unique", "into", "from", "exclude", "subclasses", "where", "variables", "parameters", "group", "order", "by", "range"};
    private static final Map<Expression.Operator, String> DYADIC_OP_JDOQL_MAP = Stream.of({Expression.OP_AND, " && "}, {Expression.OP_OR, " || "}, {Expression.OP_BIT_AND, " & "}, {Expression.OP_BIT_OR, " | "}, {Expression.OP_BIT_XOR, " ^ "}, {Expression.OP_ADD, " + "}, {Expression.OP_SUB, " - "}, {Expression.OP_MUL, " * "}, {Expression.OP_DIV, " / "}, {Expression.OP_EQ, " == "}, {Expression.OP_GT, " > "}, {Expression.OP_LT, " < "}, {Expression.OP_GTEQ, " >= "}, {Expression.OP_LTEQ, " <= "}, {Expression.OP_NOTEQ, " != "}, {Expression.OP_DISTINCT, ""}).collect(Collectors.toMap(p -> (Expression.Operator)p[0], p -> (String)p[1]));

    public static boolean isKeyword(String name) {
        for (int i = 0; i < SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!name.equals(SINGLE_STRING_KEYWORDS[i]) && !name.equals(SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
            return true;
        }
        return name.equals("IMPORT") || name.equals("import");
    }

    public static boolean isKeywordExtended(String name) {
        for (int i = 0; i < SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!name.equals(SINGLE_STRING_KEYWORDS[i]) && !name.equals(SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
            return true;
        }
        if (name.equals("DELETE") || name.equals("delete")) {
            return true;
        }
        if (name.equals("UPDATE") || name.equals("update")) {
            return true;
        }
        if (name.equals("SET") || name.equals("set")) {
            return true;
        }
        return name.equals("IMPORT") || name.equals("import");
    }

    public static boolean isValidJavaIdentifierForJDOQL(String s) {
        int len = s.length();
        if (len < 1) {
            return false;
        }
        if (s.equals("this")) {
            return false;
        }
        char[] c = new char[len];
        s.getChars(0, len, c, 0);
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String getCandidateFromJDOQLString(String query) {
        if (query == null) {
            return null;
        }
        int fromStartPos = query.indexOf(" FROM ");
        if (fromStartPos < 0) {
            fromStartPos = query.indexOf(" from ");
        }
        if (fromStartPos < 0) {
            return null;
        }
        String fromStr = query.substring(fromStartPos + 6).trim();
        int fromEndPos = fromStr.indexOf(32);
        String fromCandidate = fromStr;
        if (fromEndPos > 0) {
            fromCandidate = fromStr.substring(0, fromEndPos);
        }
        return fromCandidate;
    }

    public static String getJDOQLForExpression(Expression expr) {
        if (expr instanceof DyadicExpression) {
            String opString;
            DyadicExpression dyExpr = (DyadicExpression)expr;
            Expression left = dyExpr.getLeft();
            Expression right = dyExpr.getRight();
            StringBuilder str = new StringBuilder("(");
            if (dyExpr.getOperator() == Expression.OP_DISTINCT) {
                str.append("DISTINCT ");
            }
            if (left != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(left));
            }
            if ((opString = DYADIC_OP_JDOQL_MAP.get(dyExpr.getOperator())) == null) {
                throw new UnsupportedOperationException("Dont currently support operator " + dyExpr.getOperator() + " in JDOQL conversion");
            }
            str.append(opString);
            if (right != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(right));
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            if (primExpr.getLeft() != null) {
                return JDOQLQueryHelper.getJDOQLForExpression(primExpr.getLeft()) + "." + primExpr.getId();
            }
            return primExpr.getId();
        }
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            if (paramExpr.getId() != null) {
                return ":" + paramExpr.getId();
            }
            return "?" + paramExpr.getPosition();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            StringBuilder str = new StringBuilder();
            if (invExpr.getLeft() != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(invExpr.getLeft())).append(".");
            }
            str.append(invExpr.getOperation());
            str.append("(");
            List<Expression> args = invExpr.getArguments();
            if (args != null) {
                Iterator<Expression> iter = args.iterator();
                while (iter.hasNext()) {
                    str.append(JDOQLQueryHelper.getJDOQLForExpression(iter.next()));
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof Literal) {
            Literal litExpr = (Literal)expr;
            Object value = litExpr.getLiteral();
            if (value instanceof String || value instanceof Character) {
                return "'" + value.toString() + "'";
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "TRUE" : "FALSE";
            }
            if (litExpr.getLiteral() == null) {
                return "null";
            }
            return litExpr.getLiteral().toString();
        }
        throw new UnsupportedOperationException("Dont currently support " + expr.getClass().getName() + " in JDOQLHelper");
    }
}

