/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.scram;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.scram.ScramAuthMethod;

public final class ScramUtil {
    private static final Log LOG = LogFactory.getLog(ScramUtil.class);

    private ScramUtil() {
    }

    public static String getScramMechanismName() {
        if (ScramUtil.isScramSupported()) {
            return ScramAuthMethod.INSTANCE.getMechanismName();
        }
        LOG.info((Object)"SCRAM is not supported.");
        return "SCRAM-SHA-256";
    }

    public static boolean isScramSupported() {
        try {
            Class.forName("org.apache.hadoop.security.scram.ScramAuthMethod", false, ScramUtil.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)"Class org.apache.hadoop.security.scram.ScramAuthMethod is not in the class path");
            return false;
        }
    }

    public static boolean isHadoopConfiguredForScram() {
        Configuration configuration = new Configuration();
        configuration.addResource("yarn-site.xml");
        String hadoopTokenAuth = configuration.get("hadoop.security.token.authentication.method");
        if (hadoopTokenAuth != null && !hadoopTokenAuth.isBlank()) {
            return hadoopTokenAuth.toUpperCase().contains("SCRAM");
        }
        return false;
    }
}

