/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreUtils {
    private static final String DB_NAME = "db1";
    private static final String TABLE_NAME = "tbl1";
    private final Map<String, String> paramsWithStats = ImmutableMap.of((Object)"numFiles", (Object)"1", (Object)"totalSize", (Object)"2");
    private Database db;

    public TestMetaStoreUtils() {
        try {
            this.db = new DatabaseBuilder().setName(DB_NAME).build(null);
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testTrimMapNullsXform() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("akey", "aval");
        m.put("blank", "");
        m.put("null", null);
        ImmutableMap expected = ImmutableMap.of((Object)"akey", (Object)"aval", (Object)"blank", (Object)"", (Object)"null", (Object)"");
        Map xformed = MetaStoreUtils.trimMapNulls(m, (boolean)true);
        Assert.assertThat((Object)xformed, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testTrimMapNullsPrune() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("akey", "aval");
        m.put("blank", "");
        m.put("null", null);
        ImmutableMap expected = ImmutableMap.of((Object)"akey", (Object)"aval", (Object)"blank", (Object)"");
        Map pruned = MetaStoreUtils.trimMapNulls(m, (boolean)false);
        Assert.assertThat((Object)pruned, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testcolumnsIncludedByNameType() {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema col1a = new FieldSchema("col1", "string", "col1 but with a different comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1), Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1), Arrays.asList(col1a)));
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1, col2)));
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col2, col1)));
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1, col2, col3)));
        Assert.assertTrue((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col3, col2, col1)));
        Assert.assertFalse((boolean)MetaStoreUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1)));
    }

    @Test
    public void testUpdateTableStatsSlow_statsUpdated() throws TException {
        long fileLength = 5L;
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).build(null);
        FileStatus fs1 = new FileStatus(1L, true, 2, 3L, 4L, new Path("/tmp/0"));
        FileStatus fs2 = new FileStatus(fileLength, false, 3, 4L, 5L, new Path("/tmp/1"));
        FileStatus fs3 = new FileStatus(fileLength, false, 3, 4L, 5L, new Path("/tmp/1"));
        List<FileStatus> fileStatus = Arrays.asList(fs1, fs2, fs3);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl)).thenReturn(fileStatus);
        ImmutableMap expected = ImmutableMap.of((Object)"numFiles", (Object)"2", (Object)"totalSize", (Object)String.valueOf(2L * fileLength));
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)false, (boolean)false, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is((Object)expected));
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("numFiles", "0").addTableParam("totalSize", "0").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl1)).thenReturn(fileStatus);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl1.getParameters(), (Matcher)Is.is((Object)expected));
        Table tbl2 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("COLUMN_STATS_ACCURATE", "true").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl2)).thenReturn(fileStatus);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl2, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl2.getParameters(), (Matcher)Is.is((Object)expected));
        EnvironmentContext context = new EnvironmentContext((Map)ImmutableMap.of((Object)"STATS_GENERATED", (Object)"TASK"));
        Table tbl3 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("COLUMN_STATS_ACCURATE", "foo").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl3)).thenReturn(fileStatus);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl3, (Warehouse)wh, (boolean)false, (boolean)true, (EnvironmentContext)context);
        ImmutableMap expected1 = ImmutableMap.of((Object)"numFiles", (Object)"2", (Object)"totalSize", (Object)String.valueOf(2L * fileLength), (Object)"COLUMN_STATS_ACCURATE", (Object)"{\"BASIC_STATS\":\"true\"}");
        Assert.assertThat((Object)tbl3.getParameters(), (Matcher)Is.is((Object)expected1));
    }

    @Test
    public void testUpdateTableStatsSlow_removesDoNotUpdateStats() throws TException {
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("DO_NOT_UPDATE_STATS", "true").build(null);
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("DO_NOT_UPDATE_STATS", "false").build(null);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is(Collections.emptyMap()));
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)true, (boolean)false, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is(Collections.emptyMap()));
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl1);
    }

    @Test
    public void testUpdateTableStatsSlow_doesNotUpdateStats() throws TException {
        FieldSchema fs = new FieldSchema("date", "string", "date column");
        List<FieldSchema> cols = Collections.singletonList(fs);
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).build(null);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)true, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl);
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setPartCols(cols).build(null);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)false, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl1);
        Table tbl2 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setTableParams(this.paramsWithStats).build(null);
        MetaStoreUtils.updateTableStatsSlow((Database)this.db, (Table)tbl2, (Warehouse)wh, (boolean)false, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl2);
    }

    @Test
    public void isFastStatsSameWithNullPartitions() {
        Partition partition = new Partition();
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame(null, null));
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame(null, (Partition)partition));
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)partition, null));
    }

    @Test
    public void isFastStatsSameWithNoMatchingStats() {
        Partition oldPartition = new Partition();
        HashMap<String, String> stats = new HashMap<String, String>();
        oldPartition.setParameters(stats);
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, null));
        stats.put("someKeyThatIsNotInFastStats", "value");
        oldPartition.setParameters(stats);
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, null));
    }

    @Test
    public void isFastStatsSameMatchingButOnlyOneStat() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put(StatsSetupConst.fastStats[0], "1");
        oldPartition.setParameters(stats);
        newPartition.setParameters(stats);
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameMatching() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> stats = new HashMap<String, String>();
        for (int i = 0; i < StatsSetupConst.fastStats.length; ++i) {
            stats.put(StatsSetupConst.fastStats[i], String.valueOf(i));
        }
        oldPartition.setParameters(stats);
        newPartition.setParameters(stats);
        Assert.assertTrue((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameDifferent() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> oldStats = new HashMap<String, String>();
        for (int i = 0; i < StatsSetupConst.fastStats.length; ++i) {
            oldStats.put(StatsSetupConst.fastStats[i], String.valueOf(i));
        }
        oldPartition.setParameters(oldStats);
        HashMap<String, String> newStats = new HashMap<String, String>();
        for (int i = 0; i < StatsSetupConst.fastStats.length; ++i) {
            newStats.put(StatsSetupConst.fastStats[i], String.valueOf(i + 1));
        }
        newPartition.setParameters(newStats);
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameNullStatsInNew() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> oldStats = new HashMap<String, String>();
        for (int i = 0; i < StatsSetupConst.fastStats.length; ++i) {
            oldStats.put(StatsSetupConst.fastStats[i], String.valueOf(i));
        }
        oldPartition.setParameters(oldStats);
        HashMap<String, Object> newStats = new HashMap<String, Object>();
        for (int i = 0; i < StatsSetupConst.fastStats.length; ++i) {
            newStats.put(StatsSetupConst.fastStats[i], null);
        }
        newPartition.setParameters(newStats);
        Assert.assertFalse((boolean)MetaStoreUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }
}

