/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestAlterPartitions
extends MetaStoreClientTest {
    private static final int NEW_CREATE_TIME = 123456789;
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "testpartdb";
    private static final String TABLE_NAME = "testparttable";
    private static final List<String> PARTCOL_SCHEMA = Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"});

    public TestAlterPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        this.createDB(DB_NAME);
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivilages) throws Exception {
        TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string");
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build(this.metaStore.getConf());
        if (setPartitionLevelPrivilages) {
            table.putToParameters("PARTITION_LEVEL_PRIVILEGE", "true");
        }
        client.createTable(table);
        return table;
    }

    private void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder partitionBuilder = new PartitionBuilder().inTable(table);
        values.forEach(val -> partitionBuilder.addValue(val));
        client.add_partition(partitionBuilder.build(this.metaStore.getConf()));
    }

    private List<List<String>> createTable4PartColsParts(IMetaStoreClient client) throws Exception {
        Table t = this.createTestTable(client, DB_NAME, TABLE_NAME, PARTCOL_SCHEMA, false);
        ArrayList testValues = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"1999", "01", "02"}), Lists.newArrayList((Object[])new String[]{"2009", "02", "10"}), Lists.newArrayList((Object[])new String[]{"2017", "10", "26"}), Lists.newArrayList((Object[])new String[]{"2017", "11", "27"})});
        for (List vals : testValues) {
            this.addPartition(client, t, vals);
        }
        return testValues;
    }

    private static void assertPartitionsHaveCorrectValues(List<Partition> partitions, List<List<String>> testValues) throws Exception {
        Assert.assertEquals((long)testValues.size(), (long)partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            Assert.assertEquals(testValues.get(i), (Object)partitions.get(i).getValues());
        }
    }

    private static void makeTestChangesOnPartition(Partition partition) {
        partition.getParameters().put("hmsTestParam001", "testValue001");
        partition.setCreateTime(123456789);
        partition.setLastAccessTime(123456789);
        partition.getSd().setLocation(partition.getSd().getLocation() + "/hh=01");
        partition.getSd().getCols().add(new FieldSchema("newcol", "string", ""));
    }

    private void assertPartitionUnchanged(Partition partition, List<String> testValues, List<String> partCols) throws MetaException {
        Assert.assertFalse((boolean)partition.getParameters().containsKey("hmsTestParam001"));
        ArrayList<CallSite> expectedKVPairs = new ArrayList<CallSite>();
        for (int i = 0; i < partCols.size(); ++i) {
            expectedKVPairs.add((CallSite)((Object)(partCols.get(i) + "=" + testValues.get(i))));
        }
        String partPath = expectedKVPairs.stream().collect(Collectors.joining("/"));
        Assert.assertTrue((boolean)partition.getSd().getLocation().equals(this.metaStore.getWarehouseRoot() + "/testpartdb.db/testparttable/" + partPath));
        Assert.assertNotEquals((long)123456789L, (long)partition.getCreateTime());
        Assert.assertNotEquals((long)123456789L, (long)partition.getLastAccessTime());
        Assert.assertEquals((long)2L, (long)partition.getSd().getCols().size());
    }

    private void assertPartitionChanged(Partition partition, List<String> testValues, List<String> partCols) throws MetaException {
        Assert.assertEquals((Object)"testValue001", partition.getParameters().get("hmsTestParam001"));
        ArrayList<CallSite> expectedKVPairs = new ArrayList<CallSite>();
        for (int i = 0; i < partCols.size(); ++i) {
            expectedKVPairs.add((CallSite)((Object)(partCols.get(i) + "=" + testValues.get(i))));
        }
        String partPath = expectedKVPairs.stream().collect(Collectors.joining("/"));
        Assert.assertTrue((boolean)partition.getSd().getLocation().equals(this.metaStore.getWarehouseRoot() + "/testpartdb.db/testparttable/" + partPath + "/hh=01"));
        Assert.assertEquals((long)123456789L, (long)partition.getCreateTime());
        Assert.assertEquals((long)123456789L, (long)partition.getLastAccessTime());
        Assert.assertEquals((long)3L, (long)partition.getSd().getCols().size());
    }

    @Test
    public void testAlterPartition() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition oldPart = (Partition)oldParts.get(3);
        this.assertPartitionUnchanged(oldPart, testValues.get(3), PARTCOL_SCHEMA);
        TestAlterPartitions.makeTestChangesOnPartition(oldPart);
        this.client.alter_partition(DB_NAME, TABLE_NAME, oldPart);
        List newParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition newPart = (Partition)newParts.get(3);
        this.assertPartitionChanged(newPart, testValues.get(3), PARTCOL_SCHEMA);
        TestAlterPartitions.assertPartitionsHaveCorrectValues(newParts, testValues);
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "alter_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "alter_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[5];
        for (int i = 0; i < 5; ++i) {
            parts[i] = ((PartitionBuilder)new PartitionBuilder().inTable(table).addValue("a" + i).setLocation(MetaStoreTestUtils.getTestWarehouseDir("b" + i))).build(this.metaStore.getConf());
        }
        this.client.add_partitions(Arrays.asList(parts));
        Partition newPart = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a0"));
        newPart.getParameters().put("test_key", "test_value");
        this.client.alter_partition(catName, dbName, tableName, newPart);
        Partition fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a0"));
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
        newPart = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a1"));
        newPart.setLastAccessTime(3);
        Partition newPart1 = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a2"));
        newPart1.getSd().setLocation(MetaStoreTestUtils.getTestWarehouseDir("somewhere"));
        this.client.alter_partitions(catName, dbName, tableName, Arrays.asList(newPart, newPart1));
        fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a1"));
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertEquals((long)3L, (long)fetched.getLastAccessTime());
        fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a2"));
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertTrue((boolean)fetched.getSd().getLocation().contains("somewhere"));
        newPart = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a4"));
        newPart.getParameters().put("test_key", "test_value");
        EnvironmentContext ec = new EnvironmentContext();
        ec.setProperties(Collections.singletonMap("a", "b"));
        this.client.alter_partition(catName, dbName, tableName, newPart, ec);
        fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a4"));
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
        this.client.dropDatabase(catName, dbName, true, true, true);
        this.client.dropCatalog(catName);
    }

    @Test
    public void deprecatedCalls() throws TException {
        String tableName = "deprecated_table";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[5];
        for (int i = 0; i < 5; ++i) {
            parts[i] = ((PartitionBuilder)new PartitionBuilder().inTable(table).addValue("a" + i).setLocation(MetaStoreTestUtils.getTestWarehouseDir("a" + i))).build(this.metaStore.getConf());
        }
        this.client.add_partitions(Arrays.asList(parts));
        Partition newPart = this.client.getPartition("default", tableName, Collections.singletonList("a0"));
        newPart.getParameters().put("test_key", "test_value");
        this.client.alter_partition("default", tableName, newPart);
        Partition fetched = this.client.getPartition("default", tableName, Collections.singletonList("a0"));
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
        newPart = this.client.getPartition("default", tableName, Collections.singletonList("a1"));
        newPart.setLastAccessTime(3);
        Partition newPart1 = this.client.getPartition("default", tableName, Collections.singletonList("a2"));
        newPart1.getSd().setLocation("somewhere");
        this.client.alter_partitions("default", tableName, Arrays.asList(newPart, newPart1));
        fetched = this.client.getPartition("default", tableName, Collections.singletonList("a1"));
        Assert.assertEquals((long)3L, (long)fetched.getLastAccessTime());
        fetched = this.client.getPartition("default", tableName, Collections.singletonList("a2"));
        Assert.assertTrue((boolean)fetched.getSd().getLocation().contains("somewhere"));
        newPart = this.client.getPartition("default", tableName, Collections.singletonList("a3"));
        newPart.setValues(Collections.singletonList("b3"));
        this.client.renamePartition("default", tableName, Collections.singletonList("a3"), newPart);
        fetched = this.client.getPartition("default", tableName, Collections.singletonList("b3"));
        Assert.assertEquals((long)1L, (long)fetched.getValuesSize());
        Assert.assertEquals((Object)"b3", fetched.getValues().get(0));
        newPart = this.client.getPartition("default", tableName, Collections.singletonList("a4"));
        newPart.getParameters().put("test_key", "test_value");
        EnvironmentContext ec = new EnvironmentContext();
        ec.setProperties(Collections.singletonMap("a", "b"));
        this.client.alter_partition("default", tableName, newPart, ec);
        fetched = this.client.getPartition("default", tableName, Collections.singletonList("a4"));
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionUnknownPartition() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("1111").addValue("11").addValue("11").build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part);
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionIncompletePartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("2017").build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part);
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionMissingPartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionBogusCatalogName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition("nosuch", DB_NAME, TABLE_NAME, (Partition)partitions.get(3));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition("", TABLE_NAME, (Partition)partitions.get(3));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(null, TABLE_NAME, (Partition)partitions.get(3));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(DB_NAME, "", (Partition)partitions.get(3));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionNullTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(DB_NAME, null, (Partition)partitions.get(3));
    }

    @Test
    public void testAlterPartitionNullPartition() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
            this.client.alter_partition(DB_NAME, TABLE_NAME, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionChangeDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setDbName("testpartdb_changed");
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition);
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionChangeTableName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setTableName("testparttable_changed");
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionChangeValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setValues((List)Lists.newArrayList((Object[])new String[]{"1", "2", "3"}));
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition);
    }

    @Test
    public void testAlterPartitionWithEnvironmentCtx() throws Exception {
        EnvironmentContext context = new EnvironmentContext();
        context.setProperties((Map)new HashMap<String, String>(){
            {
                this.put("TestKey", "TestValue");
            }
        });
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)oldParts.get(3);
        this.assertPartitionUnchanged(partition, testValues.get(3), PARTCOL_SCHEMA);
        TestAlterPartitions.makeTestChangesOnPartition(partition);
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, context);
        List newParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        partition = (Partition)newParts.get(3);
        this.assertPartitionChanged(partition, testValues.get(3), PARTCOL_SCHEMA);
        TestAlterPartitions.assertPartitionsHaveCorrectValues(newParts, testValues);
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, new EnvironmentContext());
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, null);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionWithEnvironmentCtxUnknownPartition() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("1111").addValue("11").addValue("11").build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part, new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxIncompletePartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("2017").build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part, new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxMissingPartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).build(this.metaStore.getConf());
        this.client.alter_partition(DB_NAME, TABLE_NAME, part, new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionWithEnvironmentCtxNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition("", TABLE_NAME, (Partition)partitions.get(3), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(null, TABLE_NAME, (Partition)partitions.get(3), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionWithEnvironmentCtxNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(DB_NAME, "", (Partition)partitions.get(3), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxNullTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        this.client.alter_partition(DB_NAME, null, (Partition)partitions.get(3), new EnvironmentContext());
    }

    @Test
    public void testAlterPartitionWithEnvironmentCtxNullPartition() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
            this.client.alter_partition(DB_NAME, TABLE_NAME, null, new EnvironmentContext());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxChangeDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setDbName("testpartdb_changed");
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionWithEnvironmentCtxChangeTableName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setTableName("testparttable_changed");
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionWithEnvironmentCtxChangeValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partition = (Partition)partitions.get(3);
        partition.setValues((List)Lists.newArrayList((Object[])new String[]{"1", "2", "3"}));
        this.client.alter_partition(DB_NAME, TABLE_NAME, partition, new EnvironmentContext());
    }

    @Test
    public void testAlterPartitions() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        for (int i = 0; i < testValues.size(); ++i) {
            this.assertPartitionUnchanged((Partition)oldParts.get(i), testValues.get(i), PARTCOL_SCHEMA);
        }
        oldParts.forEach(p -> TestAlterPartitions.makeTestChangesOnPartition(p));
        this.client.alter_partitions(DB_NAME, TABLE_NAME, oldParts);
        List newParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        for (int i = 0; i < testValues.size(); ++i) {
            this.assertPartitionChanged((Partition)oldParts.get(i), testValues.get(i), PARTCOL_SCHEMA);
        }
        TestAlterPartitions.assertPartitionsHaveCorrectValues(newParts, testValues);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsEmptyPartitionList() throws Exception {
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList());
    }

    @Test
    public void testAlterPartitionsUnknownPartition() throws Exception {
        Partition part1 = null;
        try {
            this.createTable4PartColsParts(this.client);
            Table t = this.client.getTable(DB_NAME, TABLE_NAME);
            PartitionBuilder builder = new PartitionBuilder();
            Partition part = builder.inTable(t).addValue("1111").addValue("11").addValue("11").build(this.metaStore.getConf());
            part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
            TestAlterPartitions.makeTestChangesOnPartition(part1);
            this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}));
            Assert.fail((String)"Should have thrown InvalidOperationException");
        }
        catch (InvalidOperationException e) {
            part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
            this.assertPartitionUnchanged(part1, part1.getValues(), PARTCOL_SCHEMA);
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsIncompletePartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("2017").build(this.metaStore.getConf());
        Partition part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsMissingPartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).build(this.metaStore.getConf());
        Partition part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsBogusCatalogName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions("nosuch", DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions("", TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, "", (List)Lists.newArrayList((Object[])new Partition[]{part}));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsNullTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, null, (List)Lists.newArrayList((Object[])new Partition[]{part}));
    }

    @Test(expected=NullPointerException.class)
    public void testAlterPartitionsNullPartition() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, null}));
    }

    @Test(expected=NullPointerException.class)
    public void testAlterPartitionsNullPartitions() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{null, null}));
    }

    @Test
    public void testAlterPartitionsNullPartitionList() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
            this.client.alter_partitions(DB_NAME, TABLE_NAME, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsChangeDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setDbName("testpartdb_changed");
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}));
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsChangeTableName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setTableName("testparttable_changed");
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}));
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsChangeValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setValues((List)Lists.newArrayList((Object[])new String[]{"1", "2", "3"}));
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}));
    }

    @Test
    public void testAlterPartitionsWithEnvironmentCtx() throws Exception {
        int i;
        EnvironmentContext context = new EnvironmentContext();
        context.setProperties((Map)new HashMap<String, String>(){
            {
                this.put("TestKey", "TestValue");
            }
        });
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        for (int i2 = 0; i2 < testValues.size(); ++i2) {
            this.assertPartitionUnchanged((Partition)oldParts.get(i2), testValues.get(i2), PARTCOL_SCHEMA);
        }
        oldParts.forEach(p -> TestAlterPartitions.makeTestChangesOnPartition(p));
        this.client.alter_partitions(DB_NAME, TABLE_NAME, oldParts, context);
        List newParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        for (i = 0; i < testValues.size(); ++i) {
            this.assertPartitionChanged((Partition)oldParts.get(i), testValues.get(i), PARTCOL_SCHEMA);
        }
        TestAlterPartitions.assertPartitionsHaveCorrectValues(newParts, testValues);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, newParts, new EnvironmentContext());
        this.client.alter_partitions(DB_NAME, TABLE_NAME, newParts, null);
        for (i = 0; i < testValues.size(); ++i) {
            this.assertPartitionChanged((Partition)oldParts.get(i), testValues.get(i), PARTCOL_SCHEMA);
        }
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxEmptyPartitionList() throws Exception {
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList(), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxUnknownPartition() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("1111").addValue("11").addValue("11").build(this.metaStore.getConf());
        Partition part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxIncompletePartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).addValue("2017").build(this.metaStore.getConf());
        Partition part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxMissingPartitionVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        Table t = this.client.getTable(DB_NAME, TABLE_NAME);
        PartitionBuilder builder = new PartitionBuilder();
        Partition part = builder.inTable(t).build(this.metaStore.getConf());
        Partition part1 = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, part1}), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxBogusCatalogName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions("nosuch", DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions("", TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part}), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, "", (List)Lists.newArrayList((Object[])new Partition[]{part}), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, null, (List)Lists.newArrayList((Object[])new Partition[]{part}), new EnvironmentContext());
    }

    @Test(expected=NullPointerException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullPartition() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{part, null}), new EnvironmentContext());
    }

    @Test(expected=NullPointerException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullPartitions() throws Exception {
        this.createTable4PartColsParts(this.client);
        Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{null, null}), new EnvironmentContext());
    }

    @Test
    public void testAlterPartitionsWithEnvironmentCtxNullPartitionList() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            Partition part = (Partition)this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1).get(0);
            this.client.alter_partitions(DB_NAME, TABLE_NAME, null, new EnvironmentContext());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxChangeDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setDbName("testpartdb_changed");
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}), new EnvironmentContext());
    }

    @Test(expected=MetaException.class)
    public void testAlterPartitionsWithEnvironmentCtxChangeTableName() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setTableName("testparttable_changed");
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}), new EnvironmentContext());
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxChangeValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition p = (Partition)partitions.get(3);
        p.setValues((List)Lists.newArrayList((Object[])new String[]{"1", "2", "3"}));
        this.client.alter_partitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new Partition[]{p}), new EnvironmentContext());
    }

    @Test
    public void testRenamePartition() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        ArrayList<List<String>> newValues = new ArrayList<List<String>>();
        ArrayList newVal = Lists.newArrayList((Object[])new String[]{"2018", "01", "16"});
        newValues.addAll(oldValues.subList(0, 3));
        newValues.add(newVal);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)newVal);
        TestAlterPartitions.makeTestChangesOnPartition(partToRename);
        this.client.renamePartition(DB_NAME, TABLE_NAME, oldValues.get(3), partToRename);
        List newParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        TestAlterPartitions.assertPartitionsHaveCorrectValues(newParts, newValues);
        Assert.assertFalse((boolean)((Partition)newParts.get(3)).getSd().getLocation().endsWith("hh=01"));
        Assert.assertEquals((long)3L, (long)((Partition)newParts.get(3)).getSd().getCols().size());
        Assert.assertEquals((Object)"testValue001", ((Partition)newParts.get(3)).getParameters().get("hmsTestParam001"));
        Assert.assertEquals((long)123456789L, (long)((Partition)newParts.get(3)).getCreateTime());
        Assert.assertEquals((long)123456789L, (long)((Partition)newParts.get(3)).getLastAccessTime());
        Assert.assertTrue((boolean)this.client.listPartitions(DB_NAME, TABLE_NAME, oldValues.get(3), (short)-1).isEmpty());
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionTargetAlreadyExisting() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, TABLE_NAME, oldValues.get(3), (Partition)oldParts.get(2));
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNoSuchOldPartition() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1", "2", ""}), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionNullTableInPartition() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        partToRename.setTableName(null);
        this.client.renamePartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionNullDbInPartition() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        partToRename.setDbName(null);
        this.client.renamePartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), partToRename);
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionEmptyOldPartList() throws Exception {
        this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList(), partToRename);
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNullOldPartList() throws Exception {
        this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, TABLE_NAME, null, partToRename);
    }

    @Test
    public void testRenamePartitionNullNewPart() throws Exception {
        try {
            List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
            List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
            Partition partToRename = (Partition)oldParts.get(3);
            partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
            this.client.renamePartition(DB_NAME, TABLE_NAME, oldValues.get(3), null);
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionBogusCatalogName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition("nosuch", DB_NAME, TABLE_NAME, oldValues.get(3), partToRename);
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNoDbName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition("", TABLE_NAME, oldValues.get(3), partToRename);
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNoTblName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, "", oldValues.get(3), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionNullDbName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(null, TABLE_NAME, oldValues.get(3), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionNullTblName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        this.client.renamePartition(DB_NAME, null, oldValues.get(3), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionChangeTblName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        partToRename.setTableName("testparttable_2");
        this.client.renamePartition(DB_NAME, TABLE_NAME, oldValues.get(3), partToRename);
    }

    @Test(expected=MetaException.class)
    public void testRenamePartitionChangeDbName() throws Exception {
        List<List<String>> oldValues = this.createTable4PartColsParts(this.client);
        List oldParts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Partition partToRename = (Partition)oldParts.get(3);
        partToRename.setValues((List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}));
        partToRename.setDbName("testpartdb_2");
        this.client.renamePartition(DB_NAME, TABLE_NAME, oldValues.get(3), partToRename);
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNoTable() throws Exception {
        this.client.renamePartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2018", "01", "16"}), new Partition());
    }
}

