/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TestHiveMetaStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestRemoteHiveMetaStore
extends TestHiveMetaStore {
    private static boolean isServerStarted = false;
    protected static int port;

    public TestRemoteHiveMetaStore() {
        isThriftClient = true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (isServerStarted) {
            Assert.assertNotNull((String)"Unable to connect to the MetaStore server", (Object)client);
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
            return;
        }
        port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        System.out.println("Starting MetaStore Server on port " + port);
        isServerStarted = true;
        client = this.createClient();
    }

    @Override
    protected HiveMetaStoreClient createClient() throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        return new HiveMetaStoreClient(conf);
    }
}

