/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOCanRetryException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.FakeDerby;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestObjectStoreInitRetry {
    private static final Logger LOG = LoggerFactory.getLogger(TestObjectStoreInitRetry.class);
    private static int injectConnectFailure = 0;
    protected static Configuration conf;

    private static void setInjectConnectFailure(int x) {
        injectConnectFailure = x;
    }

    private static int getInjectConnectFailure() {
        return injectConnectFailure;
    }

    private static void decrementInjectConnectFailure() {
        --injectConnectFailure;
    }

    @BeforeClass
    public static void oneTimeSetup() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new FakeDerby()));
    }

    @AfterClass
    public static void oneTimeTearDown() throws SQLException {
        DriverManager.deregisterDriver((Driver)((Object)new FakeDerby()));
    }

    static void misbehave() throws RuntimeException {
        TestObjectStoreInitRetry.debugTrace();
        if (TestObjectStoreInitRetry.getInjectConnectFailure() > 0) {
            TestObjectStoreInitRetry.decrementInjectConnectFailure();
            JDOCanRetryException re = new JDOCanRetryException();
            LOG.debug("MISBEHAVE:" + TestObjectStoreInitRetry.getInjectConnectFailure(), (Throwable)re);
            throw re;
        }
    }

    static void debugTrace() {
        if (LOG.isDebugEnabled()) {
            Exception e = new Exception();
            LOG.debug("." + e.getStackTrace()[1].getLineNumber() + ":" + TestObjectStoreInitRetry.getInjectConnectFailure());
        }
    }

    @Test
    public void testObjStoreRetry() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS, (long)4L);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER, (String)FakeDerby.class.getName());
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL, (boolean)true);
        String jdbcUrl = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        jdbcUrl = jdbcUrl.replace("derby", "fderby");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)jdbcUrl);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        FakeDerby fd = new FakeDerby();
        ObjectStore objStore = new ObjectStore();
        Exception savE = null;
        try {
            TestObjectStoreInitRetry.setInjectConnectFailure(5);
            objStore.setConf(conf);
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info("Caught exception ", (Throwable)e);
            savE = e;
        }
        Assert.assertEquals((long)1L, (long)TestObjectStoreInitRetry.getInjectConnectFailure());
        Assert.assertNotNull((Object)savE);
        TestObjectStoreInitRetry.setInjectConnectFailure(0);
        objStore.setConf(conf);
        Assert.assertEquals((long)0L, (long)TestObjectStoreInitRetry.getInjectConnectFailure());
    }
}

