/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class DateStringConverter
implements TypeConverter<Date, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 4638239842151376340L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy");

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 28;
    }

    @Override
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Date.from(Instant.from(FORMATTER.parse(str)));
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Date.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Date date) {
        return date != null ? FORMATTER.format(date.toInstant()) : null;
    }
}

