/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.FunctionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestDatabases
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "default";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Database[] testDatabases = new Database[4];

    public TestDatabases(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        for (String databaseName : this.client.getAllDatabases()) {
            if (databaseName.equals(DEFAULT_DATABASE)) continue;
            this.client.dropDatabase(databaseName, true, true, true);
        }
        this.testDatabases[0] = new DatabaseBuilder().setName("test_database_1").create(this.client, this.metaStore.getConf());
        this.testDatabases[1] = new DatabaseBuilder().setName("test_database_to_find_1").create(this.client, this.metaStore.getConf());
        this.testDatabases[2] = new DatabaseBuilder().setName("test_database_to_find_2").create(this.client, this.metaStore.getConf());
        this.testDatabases[3] = new DatabaseBuilder().setName("test_database_hidden_1").create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testDatabases.length; ++i) {
            this.testDatabases[i] = this.client.getDatabase(this.testDatabases[i].getName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testCreateGetDeleteDatabase() throws Exception {
        Database database = this.getDatabaseWithAllParametersSet();
        this.client.createDatabase(database);
        Database createdDatabase = this.client.getDatabase(database.getName());
        Assert.assertEquals((String)"Comparing databases", (Object)database, (Object)createdDatabase);
        Assert.assertTrue((String)"The directory should be created", (boolean)this.metaStore.isPathExists(new Path(database.getLocationUri())));
        this.client.dropDatabase(database.getName());
        Assert.assertFalse((String)"The directory should be removed", (boolean)this.metaStore.isPathExists(new Path(database.getLocationUri())));
        try {
            this.client.getDatabase(database.getName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDatabaseDefaultValues() throws Exception {
        Database database = new DatabaseBuilder().setName("dummy").create(this.client, this.metaStore.getConf());
        Database createdDatabase = this.client.getDatabase(database.getName());
        Assert.assertNull((String)"Comparing description", (Object)createdDatabase.getDescription());
        Assert.assertEquals((String)"Comparing location", (Object)(this.metaStore.getWarehouseRoot() + "/" + createdDatabase.getName() + ".db"), (Object)createdDatabase.getLocationUri());
        Assert.assertEquals((String)"Comparing parameters", new HashMap(), (Object)createdDatabase.getParameters());
        Assert.assertNull((String)"Comparing privileges", (Object)createdDatabase.getPrivileges());
        Assert.assertEquals((String)"Comparing owner name", (Object)SecurityUtils.getUser(), (Object)createdDatabase.getOwnerName());
        Assert.assertEquals((String)"Comparing owner type", (Object)PrincipalType.USER, (Object)createdDatabase.getOwnerType());
    }

    @Test(expected=MetaException.class)
    public void testCreateDatabaseNullName() throws Exception {
        Database database = this.testDatabases[0];
        database.setName(null);
        this.client.createDatabase(database);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateDatabaseInvalidName() throws Exception {
        Database database = this.testDatabases[0];
        database.setName("test_database_1;");
        this.client.createDatabase(database);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateDatabaseEmptyName() throws Exception {
        Database database = this.testDatabases[0];
        database.setName("");
        this.client.createDatabase(database);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testCreateDatabaseAlreadyExists() throws Exception {
        Database database = this.testDatabases[0];
        this.client.createDatabase(database);
    }

    @Test
    public void testDefaultDatabaseData() throws Exception {
        Database database = this.client.getDatabase(DEFAULT_DATABASE);
        Assert.assertEquals((String)"Default database name", (Object)DEFAULT_DATABASE, (Object)database.getName());
        Assert.assertEquals((String)"Default database description", (Object)"Default Hive database", (Object)database.getDescription());
        Assert.assertEquals((String)"Default database location", (Object)this.metaStore.getWarehouseRoot(), (Object)new Path(database.getLocationUri()));
        Assert.assertEquals((String)"Default database parameters", new HashMap(), (Object)database.getParameters());
        Assert.assertEquals((String)"Default database owner", (Object)"public", (Object)database.getOwnerName());
        Assert.assertEquals((String)"Default database owner type", (Object)PrincipalType.ROLE, (Object)database.getOwnerType());
        Assert.assertNull((String)"Default database privileges", (Object)database.getPrivileges());
    }

    @Test
    public void testGetDatabaseCaseInsensitive() throws Exception {
        Database database = this.testDatabases[0];
        Database resultUpper = this.client.getDatabase(database.getName().toUpperCase());
        Assert.assertEquals((String)"Comparing databases", (Object)database, (Object)resultUpper);
        Database resultMix = this.client.getDatabase("teST_dAtABase_1");
        Assert.assertEquals((String)"Comparing databases", (Object)database, (Object)resultMix);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetDatabaseNoSuchDatabase() throws Exception {
        this.client.getDatabase("no_such_database");
    }

    @Test(expected=MetaException.class)
    public void testGetDatabaseNullName() throws Exception {
        this.client.getDatabase(null);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropDatabaseNoSuchDatabase() throws Exception {
        this.client.dropDatabase("no_such_database");
    }

    @Test(expected=MetaException.class)
    public void testDropDatabaseNullName() throws Exception {
        this.client.dropDatabase(null);
    }

    @Test(expected=MetaException.class)
    public void testDropDatabaseDefaultDatabase() throws Exception {
        this.client.dropDatabase(DEFAULT_DATABASE);
    }

    @Test
    public void testDropDatabaseCaseInsensitive() throws Exception {
        Database database = this.testDatabases[0];
        this.client.dropDatabase(database.getName().toUpperCase());
        List allDatabases = this.client.getAllDatabases();
        Assert.assertEquals((String)"All databases size", (long)4L, (long)allDatabases.size());
        this.client.createDatabase(database);
        this.client.dropDatabase("TesT_DatABaSe_1");
        allDatabases = this.client.getAllDatabases();
        Assert.assertEquals((String)"All databases size", (long)4L, (long)allDatabases.size());
    }

    @Test
    public void testDropDatabaseDeleteData() throws Exception {
        Database database = this.testDatabases[0];
        Path dataFile = new Path(database.getLocationUri() + "/dataFile");
        this.metaStore.createFile(dataFile, "100");
        this.client.dropDatabase(database.getName(), false, false);
        Assert.assertTrue((String)"The data file should still exist", (boolean)this.metaStore.isPathExists(dataFile));
        this.client.createDatabase(database);
        Assert.assertTrue((String)"The data file should still exist", (boolean)this.metaStore.isPathExists(dataFile));
        this.client.dropDatabase(database.getName(), true, false);
        Assert.assertFalse((String)"The data file should not exist", (boolean)this.metaStore.isPathExists(dataFile));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropDatabaseIgnoreUnknownFalse() throws Exception {
        this.client.dropDatabase("no_such_database", false, false);
    }

    @Test
    public void testDropDatabaseIgnoreUnknownTrue() throws Exception {
        this.client.dropDatabase("no_such_database", false, true);
    }

    @Test(expected=InvalidOperationException.class)
    public void testDropDatabaseWithTable() throws Exception {
        Database database = this.testDatabases[0];
        Table testTable = ((TableBuilder)new TableBuilder().setDbName(database.getName()).setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.client.dropDatabase(database.getName(), true, true, false);
    }

    @Test
    public void testDropDatabaseWithTableCascade() throws Exception {
        Database database = this.testDatabases[0];
        Table testTable = ((TableBuilder)new TableBuilder().setDbName(database.getName()).setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.client.dropDatabase(database.getName(), true, true, true);
        Assert.assertFalse((String)"The directory should be removed", (boolean)this.metaStore.isPathExists(new Path(database.getLocationUri())));
    }

    @Test(expected=InvalidOperationException.class)
    public void testDropDatabaseWithFunction() throws Exception {
        Database database = this.testDatabases[0];
        Function testFunction = new FunctionBuilder().setDbName(database.getName()).setName("test_function").setClass("org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper").create(this.client, this.metaStore.getConf());
        this.client.dropDatabase(database.getName(), true, true, false);
    }

    @Test
    public void testDropDatabaseWithFunctionCascade() throws Exception {
        Database database = this.testDatabases[0];
        Function testFunction = new FunctionBuilder().setDbName(database.getName()).setName("test_function").setClass("org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper").create(this.client, this.metaStore.getConf());
        this.client.dropDatabase(database.getName(), true, true, true);
        Assert.assertFalse((String)"The directory should be removed", (boolean)this.metaStore.isPathExists(new Path(database.getLocationUri())));
    }

    @Test
    public void testGetAllDatabases() throws Exception {
        List allDatabases = this.client.getAllDatabases();
        Assert.assertEquals((String)"All databases size", (long)5L, (long)allDatabases.size());
        for (Database database : this.testDatabases) {
            Assert.assertTrue((String)"Checking database names", (boolean)allDatabases.contains(database.getName()));
        }
        Assert.assertTrue((String)"Checnking that default database is returned", (boolean)allDatabases.contains(DEFAULT_DATABASE));
        this.client.dropDatabase(this.testDatabases[1].getName());
        allDatabases = this.client.getAllDatabases();
        Assert.assertEquals((String)"All databases size", (long)4L, (long)allDatabases.size());
        for (Database database : this.testDatabases) {
            if (database.getName().equals(this.testDatabases[1].getName())) continue;
            Assert.assertTrue((String)"Checking database names", (boolean)allDatabases.contains(database.getName()));
        }
        Assert.assertTrue((String)"Checnking that default database is returned", (boolean)allDatabases.contains(DEFAULT_DATABASE));
        Assert.assertFalse((String)"Checking that the deleted database is not returned", (boolean)allDatabases.contains(this.testDatabases[1].getName()));
    }

    @Test
    public void testGetDatabases() throws Exception {
        List databases = this.client.getDatabases("*_to_find_*");
        Assert.assertEquals((String)"Found databases size", (long)2L, (long)databases.size());
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_2"));
        databases = this.client.getDatabases("*_to_find_*|*_hidden_*");
        Assert.assertEquals((String)"Found databases size", (long)3L, (long)databases.size());
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_2"));
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_hidden_1"));
        databases = this.client.getDatabases("*_not_such_database_*");
        Assert.assertEquals((String)"No such databases size", (long)0L, (long)databases.size());
        databases = this.client.getDatabases(null);
        Assert.assertEquals((String)"Search databases without pattern size", (long)5L, (long)databases.size());
    }

    @Test
    public void testGetDatabasesCaseInsensitive() throws Exception {
        List databases = this.client.getDatabases("*_tO_FiND*");
        Assert.assertEquals((String)"Found databases size", (long)2L, (long)databases.size());
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)databases.contains("test_database_to_find_2"));
    }

    @Test
    public void testAlterDatabase() throws Exception {
        Database originalDatabase = this.testDatabases[0];
        Database newDatabase = new DatabaseBuilder().setName(originalDatabase.getName()).setOwnerType(PrincipalType.GROUP).setOwnerName("owner2").setLocation(this.metaStore.getWarehouseRoot() + "/database_location_2").setDescription("dummy description 2").addParam("param_key_1", "param_value_1_2").addParam("param_key_2_3", "param_value_2_3").build(this.metaStore.getConf());
        this.client.alterDatabase(originalDatabase.getName(), newDatabase);
        Database alteredDatabase = this.client.getDatabase(newDatabase.getName());
        Assert.assertEquals((String)"Comparing Databases", (Object)newDatabase, (Object)alteredDatabase);
    }

    @Test
    public void testAlterDatabaseNotNullableFields() throws Exception {
        Database database = this.getDatabaseWithAllParametersSet();
        this.client.createDatabase(database);
        Database originalDatabase = this.client.getDatabase(database.getName());
        Database newDatabase = new Database();
        newDatabase.setName("new_name");
        newDatabase.setCatalogName("hive");
        this.client.alterDatabase(originalDatabase.getName(), newDatabase);
        Database alteredDatabase = this.client.getDatabase(originalDatabase.getName());
        Assert.assertEquals((String)"Database name should not change", (Object)originalDatabase.getName(), (Object)alteredDatabase.getName());
        Assert.assertEquals((String)"Database description should not change", (Object)originalDatabase.getDescription(), (Object)alteredDatabase.getDescription());
        Assert.assertEquals((String)"Database location should not change", (Object)originalDatabase.getLocationUri(), (Object)alteredDatabase.getLocationUri());
        Assert.assertEquals((String)"Database parameters should be empty", new HashMap(), (Object)alteredDatabase.getParameters());
        Assert.assertNull((String)"Database owner should be empty", (Object)alteredDatabase.getOwnerName());
        Assert.assertEquals((String)"Database owner type should not change", (Object)originalDatabase.getOwnerType(), (Object)alteredDatabase.getOwnerType());
        Assert.assertNull((String)"Database privileges should be empty", (Object)alteredDatabase.getPrivileges());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testAlterDatabaseNoSuchDatabase() throws Exception {
        Database newDatabase = new DatabaseBuilder().setName("test_database_altered").build(this.metaStore.getConf());
        this.client.alterDatabase("no_such_database", newDatabase);
    }

    @Test
    public void testAlterDatabaseCaseInsensitive() throws Exception {
        Database originalDatabase = this.testDatabases[0];
        Database newDatabase = originalDatabase.deepCopy();
        newDatabase.setDescription("Altered database");
        this.client.alterDatabase(originalDatabase.getName().toUpperCase(), newDatabase);
        Database alteredDatabase = this.client.getDatabase(newDatabase.getName());
        Assert.assertEquals((String)"Comparing databases", (Object)newDatabase, (Object)alteredDatabase);
        originalDatabase = this.testDatabases[2];
        newDatabase = originalDatabase.deepCopy();
        newDatabase.setDescription("Altered database 2");
        this.client.alterDatabase("TeST_daTAbaSe_TO_FiNd_2", newDatabase);
        alteredDatabase = this.client.getDatabase(newDatabase.getName());
        Assert.assertEquals((String)"Comparing databases", (Object)newDatabase, (Object)alteredDatabase);
    }

    @Test
    public void databasesInCatalogs() throws TException, URISyntaxException {
        String catName = "mycatalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String[] dbNames = new String[]{"db1", "db9"};
        Database[] dbs = new Database[2];
        dbs[0] = new DatabaseBuilder().setName(dbNames[0]).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String db1Location = MetaStoreTestUtils.getTestWarehouseDir(dbNames[1]);
        dbs[1] = new DatabaseBuilder().setName(dbNames[1]).setCatalogName(catName).setLocation(db1Location).create(this.client, this.metaStore.getConf());
        Database fetched = this.client.getDatabase(catName, dbNames[0]);
        String expectedLocation = new File(cat.getLocationUri(), dbNames[0] + ".db").toURI().toString();
        Assert.assertEquals((Object)expectedLocation, (Object)(fetched.getLocationUri() + "/"));
        String db0Location = new URI(fetched.getLocationUri()).getPath();
        File dir = new File(db0Location);
        Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        fetched = this.client.getDatabase(catName, dbNames[1]);
        Assert.assertEquals((Object)new File(db1Location).toURI().toString(), (Object)(fetched.getLocationUri() + "/"));
        dir = new File(new URI(fetched.getLocationUri()).getPath());
        Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        HashSet fetchedDbs = new HashSet(this.client.getAllDatabases(catName));
        Assert.assertEquals((long)3L, (long)fetchedDbs.size());
        for (String dbName : dbNames) {
            Assert.assertTrue((boolean)fetchedDbs.contains(dbName));
        }
        fetchedDbs = new HashSet(this.client.getAllDatabases());
        Assert.assertEquals((long)5L, (long)fetchedDbs.size());
        Assert.assertTrue((boolean)fetchedDbs.contains(DEFAULT_DATABASE));
        fetchedDbs = new HashSet(this.client.getAllDatabases());
        Assert.assertEquals((long)5L, (long)fetchedDbs.size());
        Assert.assertTrue((boolean)fetchedDbs.contains(DEFAULT_DATABASE));
        fetchedDbs = new HashSet(this.client.getDatabases(catName, "d*"));
        Assert.assertEquals((long)3L, (long)fetchedDbs.size());
        for (String dbName : dbNames) {
            Assert.assertTrue((boolean)fetchedDbs.contains(dbName));
        }
        fetchedDbs = new HashSet(this.client.getDatabases("d*"));
        Assert.assertEquals((long)1L, (long)fetchedDbs.size());
        Assert.assertTrue((boolean)fetchedDbs.contains(DEFAULT_DATABASE));
        fetchedDbs = new HashSet(this.client.getDatabases("d*"));
        Assert.assertEquals((long)1L, (long)fetchedDbs.size());
        Assert.assertTrue((boolean)fetchedDbs.contains(DEFAULT_DATABASE));
        fetchedDbs = new HashSet(this.client.getDatabases(catName, "*1"));
        Assert.assertEquals((long)1L, (long)fetchedDbs.size());
        Assert.assertTrue((boolean)fetchedDbs.contains(dbNames[0]));
        fetchedDbs = new HashSet(this.client.getDatabases("*9"));
        Assert.assertEquals((long)0L, (long)fetchedDbs.size());
        fetchedDbs = new HashSet(this.client.getDatabases("*9"));
        Assert.assertEquals((long)0L, (long)fetchedDbs.size());
        fetchedDbs = new HashSet(this.client.getDatabases(catName, "*x"));
        Assert.assertEquals((long)0L, (long)fetchedDbs.size());
        try {
            this.client.dropDatabase(dbNames[0], true, false, false);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        try {
            this.client.dropDatabase(dbNames[0], true, false, false);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.client.dropDatabase(catName, dbNames[0], true, false, false);
        dir = new File(db0Location);
        Assert.assertFalse((boolean)dir.exists());
        this.client.dropDatabase(catName, dbNames[1], true, false, false);
        dir = new File(db1Location);
        Assert.assertFalse((boolean)dir.exists());
        fetchedDbs = new HashSet(this.client.getAllDatabases(catName));
        Assert.assertEquals((long)1L, (long)fetchedDbs.size());
    }

    @Test(expected=InvalidObjectException.class)
    public void createDatabaseInNonExistentCatalog() throws TException {
        Database db = new DatabaseBuilder().setName("doomed").setCatalogName("nosuch").create(this.client, this.metaStore.getConf());
    }

    @Test(expected=NoSuchObjectException.class)
    public void fetchDatabaseInNonExistentCatalog() throws TException {
        this.client.getDatabase("nosuch", DEFAULT_DATABASE);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropDatabaseInNonExistentCatalog() throws TException {
        this.client.dropDatabase("nosuch", DEFAULT_DATABASE, true, false, false);
    }

    private Database getDatabaseWithAllParametersSet() throws Exception {
        return new DatabaseBuilder().setName("dummy").setOwnerType(PrincipalType.ROLE).setOwnerName("owner").setLocation(this.metaStore.getWarehouseRoot() + "/database_location").setDescription("dummy description").addParam("param_key_1", "param_value_1").addParam("param_key_2", "param_value_2").build(this.metaStore.getConf());
    }
}

