/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.SequenceAdapter;
import org.datanucleus.store.types.TypeManager;

public class PersistFieldManager
extends AbstractFieldManager {
    private final ObjectProvider op;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(ObjectProvider op, boolean replaceSCOsWithWrappers) {
        this.op = op;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected Object processPersistable(Object pc, int ownerFieldNum, int objectType) {
        ApiAdapter adapter = this.op.getExecutionContext().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            if (objectType != 0) {
                return this.op.getExecutionContext().persistObjectInternal(pc, this.op, ownerFieldNum, objectType);
            }
            return this.op.getExecutionContext().persistObjectInternal(pc, null, -1, objectType);
        }
        return pc;
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        if (value != null) {
            ClassLoaderResolver clr;
            RelationType relationType;
            AbstractMemberMetaData mmd;
            boolean[] secondClassMutableFieldFlags;
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.op.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                value = SCOUtils.wrapSCOField(this.op, fieldNumber, value, true);
            }
            if ((mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).isCascadePersist() && (relationType = mmd.getRelationType(clr = this.op.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
                if (mmd.hasContainer()) {
                    this.processContainer(fieldNumber, value, mmd);
                } else if (mmd.isEmbedded() || mmd.isSerialized()) {
                    this.processPersistable(value, fieldNumber, 1);
                } else {
                    this.processPersistable(value, -1, 0);
                }
            }
        }
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        if (mmd.hasMap()) {
            this.processMapContainer(fieldNumber, container, mmd);
        } else {
            this.processElementContainer(fieldNumber, container, mmd);
        }
    }

    private void processMapContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
        MapContainerAdapter mapAdapter = (MapContainerAdapter)containerHandler.getAdapter((Object)container);
        for (Map.Entry<Object, Object> entry : mapAdapter.entries()) {
            ObjectProvider valOP;
            ObjectProvider keyOP;
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            Object newMapKey = mapKey;
            Object newMapValue = mapValue;
            if (api.isPersistable(mapKey)) {
                int mapKeyObjectType = mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedKey() ? 3 : 0;
                newMapKey = this.processPersistable(mapKey, fieldNumber, mapKeyObjectType);
            }
            if (api.isPersistable(mapValue)) {
                int mapValueObjectType = mmd.getMap().isEmbeddedValue() || mmd.getMap().isSerializedValue() ? 4 : 0;
                newMapValue = this.processPersistable(mapValue, fieldNumber, mapValueObjectType);
            }
            if (newMapKey == mapKey && newMapValue == mapValue) continue;
            boolean updateKey = false;
            boolean updateValue = false;
            if (newMapKey != mapKey && (keyOP = this.op.getExecutionContext().findObjectProvider(newMapKey)).getReferencedPC() != null) {
                updateKey = true;
            }
            if (newMapValue != mapValue && (valOP = this.op.getExecutionContext().findObjectProvider(newMapValue)).getReferencedPC() != null) {
                updateValue = true;
            }
            if (updateKey) {
                mapAdapter.remove(mapKey);
                mapAdapter.put(newMapKey, updateValue ? newMapValue : mapValue);
                continue;
            }
            if (!updateValue) continue;
            mapAdapter.put(mapKey, newMapValue);
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
        ElementContainerHandler elementContainerHandler = (ElementContainerHandler)typeManager.getContainerHandler(mmd.getType());
        ElementContainerAdapter containerAdapter = (ElementContainerAdapter)elementContainerHandler.getAdapter(container);
        ApiAdapter api = this.op.getExecutionContext().getApiAdapter();
        int objectType = elementContainerHandler.getObjectType(mmd);
        if (objectType == 0) {
            int elementPosition = 0;
            for (Object element : containerAdapter) {
                if (api.isPersistable(element)) {
                    Object newElement = this.processPersistable(element, -1, objectType);
                    ObjectProvider elementSM = this.op.getExecutionContext().findObjectProvider(newElement);
                    if (elementSM.getReferencedPC() != null) {
                        if (containerAdapter instanceof SequenceAdapter) {
                            ((SequenceAdapter)((Object)containerAdapter)).update(newElement, elementPosition);
                        } else {
                            containerAdapter.remove(elementSM);
                            containerAdapter.add(newElement);
                        }
                    }
                }
                ++elementPosition;
            }
        } else {
            for (Object element : containerAdapter) {
                if (!api.isPersistable(element)) continue;
                this.processPersistable(element, fieldNumber, objectType);
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

