/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.IpAddressListener;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestRemoteHiveMetaStoreIpAddress {
    private static final Logger LOG = LoggerFactory.getLogger(TestRemoteHiveMetaStoreIpAddress.class);
    private static Configuration conf;
    private static HiveMetaStoreClient msc;

    @Before
    public void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        System.setProperty(MetastoreConf.ConfVars.EVENT_LISTENERS.toString(), IpAddressListener.class.getName());
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        msc = new HiveMetaStoreClient(conf);
    }

    @Test
    public void testIpAddress() throws Exception {
        Database db = new DatabaseBuilder().setName("testIpAddressIp").create((IMetaStoreClient)msc, conf);
        msc.dropDatabase(db.getName());
    }
}

