/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.minihms;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public abstract class AbstractMetaStoreService {
    private Configuration configuration;
    private Warehouse warehouse;
    private FileSystem warehouseRootFs;
    private Path trashDir;

    public AbstractMetaStoreService(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        this.configuration.set("fs.defaultFS", "file:///");
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public void start() throws Exception {
        this.warehouse = new Warehouse(this.configuration);
        this.warehouseRootFs = this.warehouse.getFs(this.warehouse.getWhRoot());
        TrashPolicy trashPolicy = TrashPolicy.getInstance((Configuration)this.configuration, (FileSystem)this.warehouseRootFs);
        this.trashDir = trashPolicy.getCurrentTrashDir();
    }

    public void start(Map<MetastoreConf.ConfVars, String> metastoreOverlay, Map<String, String> configurationOverlay) throws Exception {
        for (Map.Entry<MetastoreConf.ConfVars, String> entry : metastoreOverlay.entrySet()) {
            MetastoreConf.setVar((Configuration)this.configuration, (MetastoreConf.ConfVars)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, String> entry : configurationOverlay.entrySet()) {
            this.configuration.set((String)entry.getKey(), entry.getValue());
        }
        this.start();
    }

    public IMetaStoreClient getClient() throws MetaException {
        return new HiveMetaStoreClient(this.configuration);
    }

    public Path getWarehouseRoot() throws MetaException {
        return this.warehouse.getWhRoot();
    }

    public boolean isPathExists(Path path) throws IOException {
        return this.warehouseRootFs.exists(path);
    }

    public boolean isPathExistsInTrash(Path path) throws IOException {
        Path pathInTrash = new Path(this.trashDir.toUri().getScheme(), this.trashDir.toUri().getAuthority(), this.trashDir.toUri().getPath() + path.toUri().getPath());
        return this.isPathExists(pathInTrash);
    }

    public void createFile(Path path, String content) throws IOException {
        FSDataOutputStream outputStream = this.warehouseRootFs.create(path);
        outputStream.write(content.getBytes());
        outputStream.close();
    }

    public void cleanWarehouseDirs() throws MetaException {
        this.warehouse.deleteDir(this.getWarehouseRoot(), true, true, false);
        this.warehouse.deleteDir(this.trashDir, true, true, false);
    }

    public void stop() {
    }

    public Configuration getConf() {
        return this.configuration;
    }
}

