/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hive.common.ndv.hll.HLLSparseRegister;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestSparseEncodeHash {
    private long input;
    private int expected;

    public TestSparseEncodeHash(long i, int e) {
        this.input = i;
        this.expected = e;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{11111111111L, 373692871}, {4314495982023L, -1711269433}, {4314529536455L, -1744823865}, {4314563074503L, 268425671}, {17257983908295L, -1644160569}, {536861127L, 536861127}, {536844743L, 536844743}, {144115188075862471L, -671082041}};
        return Arrays.asList(data);
    }

    @Test
    public void testEncodeHash() {
        HLLSparseRegister reg = new HLLSparseRegister(14, 25, 6);
        int got = reg.encodeHash(this.input);
        Assert.assertEquals((long)this.expected, (long)got);
    }
}

