/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.StorageDescriptorBuilder;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;

public class PartitionBuilder
extends StorageDescriptorBuilder<PartitionBuilder> {
    private String catName;
    private String dbName = "default";
    private String tableName;
    private int createTime;
    private int lastAccessTime;
    private Map<String, String> partParams = new HashMap<String, String>();
    private List<String> values;

    public PartitionBuilder() {
        this.createTime = this.lastAccessTime = (int)(System.currentTimeMillis() / 1000L);
        super.setChild(this);
    }

    public PartitionBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public PartitionBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public PartitionBuilder inTable(Table table) {
        this.dbName = table.getDbName();
        this.tableName = table.getTableName();
        this.catName = table.getCatName();
        this.setCols((List)table.getSd().getCols());
        return this;
    }

    public PartitionBuilder setValues(List<String> values) {
        this.values = values;
        return this;
    }

    public PartitionBuilder addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(value);
        return this;
    }

    public PartitionBuilder setCreateTime(int createTime) {
        this.createTime = createTime;
        return this;
    }

    public PartitionBuilder setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public PartitionBuilder setPartParams(Map<String, String> partParams) {
        this.partParams = partParams;
        return this;
    }

    public PartitionBuilder addPartParam(String key, String value) {
        if (this.partParams == null) {
            this.partParams = new HashMap<String, String>();
        }
        this.partParams.put(key, value);
        return this;
    }

    public Partition build(Configuration conf) throws MetaException {
        if (this.tableName == null) {
            throw new MetaException("table name must be provided");
        }
        if (this.values == null) {
            throw new MetaException("You must provide partition values");
        }
        if (this.catName == null) {
            this.catName = MetaStoreUtils.getDefaultCatalog(conf);
        }
        Partition p = new Partition(this.values, this.dbName, this.tableName, this.createTime, this.lastAccessTime, this.buildSd(), this.partParams);
        p.setCatName(this.catName);
        return p;
    }

    public Partition addToTable(IMetaStoreClient client, Configuration conf) throws TException {
        Partition p = this.build(conf);
        client.add_partition(p);
        return p;
    }
}

