/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class LongArrayByteBufferConverter
implements TypeConverter<long[], ByteBuffer> {
    private static final long serialVersionUID = 1280117491397888843L;

    @Override
    public ByteBuffer toDatastoreType(long[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = TypeConversionHelper.getByteArrayFromLongArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public long[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return TypeConversionHelper.getLongArrayFromByteArray(datastoreValue.array());
    }
}

