/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.orc.impl.AircompressorCodec;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsFactory;

public class SnappyCodec
extends AircompressorCodec
implements DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShimsFactory.get();
    Boolean direct = null;
    HadoopShims.DirectDecompressor decompressShim = null;

    SnappyCodec() {
        super((Compressor)new SnappyCompressor(), (Decompressor)new SnappyDecompressor());
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        super.decompress(in, out);
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.ensureShim();
                this.direct = this.decompressShim != null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        this.ensureShim();
        this.decompressShim.decompress(in, out);
        out.flip();
    }

    private void ensureShim() {
        if (this.decompressShim == null) {
            this.decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.decompressShim != null) {
            this.decompressShim.reset();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.decompressShim != null) {
            this.decompressShim.end();
        }
    }
}

