/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHyperLogLogMerge {
    private float longRangeTolerance = 5.0f;
    private float shortRangeTolerance = 2.0f;
    int size;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({1000}, {10000}, {100000}, {1000000}, {10000000});
    }

    public TestHyperLogLogMerge(int size) {
        this.size = size;
    }

    @Test
    public void testHLLMergeDisjoint() {
        HyperLogLog hll1 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll1.addLong((long)i);
        }
        HyperLogLog hll2 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = this.size; i < 2 * this.size; ++i) {
            hll2.addLong((long)i);
        }
        hll1.merge(hll2);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)this.size / 100.0;
        long expected = 2 * this.size;
        long actual = hll1.count();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }

    @Test
    public void testHLLMerge25PercentOverlap() {
        HyperLogLog hll1 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll1.addLong((long)i);
        }
        HyperLogLog hll2 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        int start = (int)(0.75 * (double)this.size);
        int end = (int)((double)this.size * 1.75);
        for (int i = start; i < end; ++i) {
            hll2.addLong((long)i);
        }
        hll1.merge(hll2);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)this.size / 100.0;
        long expected = (long)(1.75 * (double)this.size);
        long actual = hll1.count();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }

    @Test
    public void testHLLMerge50PercentOverlap() {
        HyperLogLog hll1 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll1.addLong((long)i);
        }
        HyperLogLog hll2 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        int start = (int)(0.5 * (double)this.size);
        int end = (int)((double)this.size * 1.5);
        for (int i = start; i < end; ++i) {
            hll2.addLong((long)i);
        }
        hll1.merge(hll2);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)this.size / 100.0;
        long expected = (long)(1.5 * (double)this.size);
        long actual = hll1.count();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }

    @Test
    public void testHLLMerge75PercentOverlap() {
        HyperLogLog hll1 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll1.addLong((long)i);
        }
        HyperLogLog hll2 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        int start = (int)(0.25 * (double)this.size);
        int end = (int)((double)this.size * 1.25);
        for (int i = start; i < end; ++i) {
            hll2.addLong((long)i);
        }
        hll1.merge(hll2);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)this.size / 100.0;
        long expected = (long)(1.25 * (double)this.size);
        long actual = hll1.count();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }

    @Test
    public void testHLLMerge100PercentOverlap() {
        HyperLogLog hll1 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll1.addLong((long)i);
        }
        HyperLogLog hll2 = HyperLogLog.builder().setNumRegisterIndexBits(16).build();
        for (int i = 0; i < this.size; ++i) {
            hll2.addLong((long)i);
        }
        hll1.merge(hll2);
        double threshold = this.size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)this.size / 100.0;
        long expected = this.size;
        long actual = hll1.count();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }
}

