/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetaStoreGetMetaConf {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Logger LOG = LoggerFactory.getLogger(TestHiveMetaStoreGetMetaConf.class);
    private static Configuration conf;
    private HiveMetaStoreClient hmsc;

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("Shutting down metastore.");
    }

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        Configuration metastoreConf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setClass((Configuration)metastoreConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        MetastoreConf.setBoolVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL_DDL, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(metastoreConf);
        int msPort = MetaStoreUtils.startMetaStore((Configuration)metastoreConf);
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + msPort));
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)10L);
    }

    @Before
    public void setup() throws MetaException {
        this.hmsc = new HiveMetaStoreClient(conf);
    }

    @After
    public void closeClient() {
        if (this.hmsc != null) {
            this.hmsc.close();
        }
    }

    @Test
    public void testGetMetaConfDefault() throws TException {
        MetastoreConf.ConfVars metaConfVar = MetastoreConf.ConfVars.TRY_DIRECT_SQL;
        String expected = metaConfVar.getDefaultVal().toString();
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfDefaultEmptyString() throws TException {
        MetastoreConf.ConfVars metaConfVar = MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN;
        String expected = "";
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfOverridden() throws TException {
        MetastoreConf.ConfVars metaConfVar = MetastoreConf.ConfVars.TRY_DIRECT_SQL_DDL;
        String expected = "false";
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfUnknownPreperty() throws TException {
        String unknownPropertyName = "hive.meta.foo.bar";
        this.thrown.expect(MetaException.class);
        this.thrown.expectMessage("Invalid configuration key " + unknownPropertyName);
        this.hmsc.getMetaConf(unknownPropertyName);
    }
}

