/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.Counter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetrics {
    private static final long REPORT_INTERVAL = 1L;

    @Before
    public void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void jsonReporter() throws Exception {
        File jsonReportFile = File.createTempFile("TestMetrics", ".json");
        String jsonFile = jsonReportFile.getAbsolutePath();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"json");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        Metrics.initialize((Configuration)conf);
        Counter counter = Metrics.getOrCreateCounter((String)"my-counter");
        for (int i = 0; i < 5; ++i) {
            counter.inc();
            Thread.sleep(1500L);
            String json = new String(MetricsTestUtils.getFileData(jsonFile, 200, 10));
            MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.COUNTER, "my-counter", i + 1);
        }
    }

    @Test
    public void allReporters() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"json,jmx,console,hadoop");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        Metrics.initialize((Configuration)conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void allReportersHiveConfig() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.ConsoleMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.Metrics2Reporter");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        Metrics.initialize((Configuration)conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void allReportersOldHiveConfig() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        conf.set(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName(), "JSON_FILE,JMX,CONSOLE,HADOOP2");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        Metrics.initialize((Configuration)conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void defaults() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        Metrics.initialize((Configuration)conf);
        Assert.assertEquals((long)2L, (long)Metrics.getReporters().size());
    }

    private static class MetricsTestUtils {
        static final MetricsCategory COUNTER = new MetricsCategory("counters", "count");
        static final MetricsCategory TIMER = new MetricsCategory("timers", "count");
        static final MetricsCategory GAUGE = new MetricsCategory("gauges", "value");
        static final MetricsCategory METER = new MetricsCategory("meters", "count");

        private MetricsTestUtils() {
        }

        static void verifyMetricsJson(String json, MetricsCategory category, String metricsName, Object expectedValue) throws Exception {
            JsonNode jsonNode = MetricsTestUtils.getJsonNode(json, category, metricsName);
            Assert.assertEquals((Object)expectedValue.toString(), (Object)jsonNode.asText());
        }

        static JsonNode getJsonNode(String json, MetricsCategory category, String metricsName) throws Exception {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(json);
            JsonNode categoryNode = rootNode.path(category.category);
            JsonNode metricsNode = categoryNode.path(metricsName);
            return metricsNode.path(category.metricsHandle);
        }

        static byte[] getFileData(String path, int timeoutInterval, int tries) throws Exception {
            File file = new File(path);
            do {
                Thread.sleep(timeoutInterval);
            } while (--tries > 0 && !file.exists());
            return Files.readAllBytes(Paths.get(path, new String[0]));
        }

        static class MetricsCategory {
            String category;
            String metricsHandle;

            MetricsCategory(String category, String metricsHandle) {
                this.category = category;
                this.metricsHandle = metricsHandle;
            }
        }
    }
}

