/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class DecimalColumnStatsMergerTest {
    private static final Decimal DECIMAL_3 = DecimalUtils.getDecimal((int)3, (int)0);
    private static final Decimal DECIMAL_5 = DecimalUtils.getDecimal((int)5, (int)0);
    private static final Decimal DECIMAL_20 = DecimalUtils.getDecimal((int)2, (int)1);
    private static final DecimalColumnStatsDataInspector DATA_3 = new DecimalColumnStatsDataInspector();
    private static final DecimalColumnStatsDataInspector DATA_5 = new DecimalColumnStatsDataInspector();
    private static final DecimalColumnStatsDataInspector DATA_20 = new DecimalColumnStatsDataInspector();
    private DecimalColumnStatsMerger merger = new DecimalColumnStatsMerger();

    @Test
    public void testMergeNullMinMaxValues() {
        ColumnStatisticsObj objNulls = new ColumnStatisticsObj();
        this.createData(objNulls, null, null);
        this.merger.merge(objNulls, objNulls);
        Assert.assertNull((Object)objNulls.getStatsData().getDecimalStats().getLowValue());
        Assert.assertNull((Object)objNulls.getStatsData().getDecimalStats().getHighValue());
    }

    @Test
    public void testMergeNonNullAndNullLowerValuesOldIsNull() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, null, null);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, DECIMAL_3, null);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getLowValue());
    }

    @Test
    public void testMergeNonNullAndNullLowerValuesNewIsNull() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, DECIMAL_3, null);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, null, null);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getLowValue());
    }

    @Test
    public void testMergeNonNullAndNullHigherValuesOldIsNull() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, null, null);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, null, DECIMAL_3);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getHighValue());
    }

    @Test
    public void testMergeNonNullAndNullHigherValuesNewIsNull() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, null, DECIMAL_3);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, null, null);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getHighValue());
    }

    @Test
    public void testMergeLowValuesFirstWins() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, DECIMAL_3, null);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, DECIMAL_5, null);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getLowValue());
    }

    @Test
    public void testMergeLowValuesSecondWins() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, DECIMAL_5, null);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, DECIMAL_3, null);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_3, (Object)oldObj.getStatsData().getDecimalStats().getLowValue());
    }

    @Test
    public void testMergeHighValuesFirstWins() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, null, DECIMAL_5);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, null, DECIMAL_3);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_5, (Object)oldObj.getStatsData().getDecimalStats().getHighValue());
    }

    @Test
    public void testMergeHighValuesSecondWins() {
        ColumnStatisticsObj oldObj = new ColumnStatisticsObj();
        this.createData(oldObj, null, DECIMAL_3);
        ColumnStatisticsObj newObj = new ColumnStatisticsObj();
        this.createData(newObj, null, DECIMAL_5);
        this.merger.merge(oldObj, newObj);
        Assert.assertEquals((Object)DECIMAL_5, (Object)oldObj.getStatsData().getDecimalStats().getHighValue());
    }

    @Test
    public void testDecimalCompareEqual() {
        Assert.assertTrue((boolean)DECIMAL_3.equals(DECIMAL_3));
    }

    @Test
    public void testDecimalCompareDoesntEqual() {
        Assert.assertTrue((!DECIMAL_3.equals(DECIMAL_5) ? 1 : 0) != 0);
    }

    @Test
    public void testCompareSimple() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_5);
        this.merger.setHighValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_5, (Object)data1.getHighValue());
    }

    @Test
    public void testCompareSimpleFlipped() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_5);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        this.merger.setHighValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_5, (Object)data1.getHighValue());
    }

    @Test
    public void testCompareSimpleReversed() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_5);
        this.merger.setLowValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getLowValue());
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_5);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        this.merger.setLowValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getLowValue());
    }

    @Test
    public void testCompareUnscaledValue() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_20);
        this.merger.setHighValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_20, (Object)data1.getHighValue());
    }

    @Test
    public void testCompareNullsMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        this.merger.setLowValue(data1, data2);
        Assert.assertNull((Object)data1.getLowValue());
    }

    @Test
    public void testCompareNullsMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        this.merger.setHighValue(data1, data2);
        Assert.assertNull((Object)data1.getHighValue());
    }

    @Test
    public void testCompareFirstNullMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        this.merger.setLowValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getLowValue());
    }

    @Test
    public void testCompareSecondNullMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        this.merger.setLowValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getLowValue());
    }

    @Test
    public void testCompareFirstNullMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        this.merger.setHighValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getHighValue());
    }

    @Test
    public void testCompareSecondNullMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        this.merger.setHighValue(data1, data2);
        Assert.assertEquals((Object)DECIMAL_3, (Object)data1.getHighValue());
    }

    private DecimalColumnStatsDataInspector createData(ColumnStatisticsObj objNulls, Decimal lowValue, Decimal highValue) {
        ColumnStatisticsData statisticsData = new ColumnStatisticsData();
        DecimalColumnStatsDataInspector data = new DecimalColumnStatsDataInspector();
        statisticsData.setDecimalStats((DecimalColumnStatsData)data);
        objNulls.setStatsData(statisticsData);
        data.setLowValue(lowValue);
        data.setHighValue(highValue);
        return data;
    }

    static {
        DATA_3.setLowValue(DECIMAL_3);
        DATA_3.setHighValue(DECIMAL_3);
        DATA_5.setLowValue(DECIMAL_5);
        DATA_5.setHighValue(DECIMAL_5);
        DATA_20.setLowValue(DECIMAL_20);
        DATA_20.setHighValue(DECIMAL_20);
    }
}

