/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.NonCatCallsWithCatalog;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.junit.After;

public class TestCatalogNonDefaultClient
extends NonCatCallsWithCatalog {
    private final String catName = "non_default_catalog";
    private String catLocation;

    @After
    public void dropCatalog() throws TException {
        MetaStoreTestUtils.dropCatalogCascade(this.client, "non_default_catalog");
    }

    @Override
    protected IMetaStoreClient getClient() throws Exception {
        Configuration svrConf = new Configuration(this.conf);
        svrConf.set("fs.defaultFS", "file:///");
        int port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), svrConf);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_DEFAULT, (String)"non_default_catalog");
        HiveMetaStoreClient client = new HiveMetaStoreClient(this.conf);
        assert (!client.isLocalMetaStore());
        this.catLocation = MetaStoreTestUtils.getTestWarehouseDir("non_default_catalog");
        Catalog cat = new CatalogBuilder().setName("non_default_catalog").setLocation(this.catLocation).build();
        client.createCatalog(cat);
        return client;
    }

    @Override
    protected String expectedCatalog() {
        return "non_default_catalog";
    }

    @Override
    protected String expectedBaseDir() throws MetaException {
        return this.catLocation;
    }
}

