/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Functions;
import java.util.List;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.Assert;

public class InjectableBehaviourObjectStore
extends ObjectStore {
    private static com.google.common.base.Function<Table, Table> getTableModifier = Functions.identity();
    private static com.google.common.base.Function<Partition, Partition> getPartitionModifier = Functions.identity();
    private static com.google.common.base.Function<List<String>, List<String>> listPartitionNamesModifier = Functions.identity();
    private static com.google.common.base.Function<NotificationEventResponse, NotificationEventResponse> getNextNotificationModifier = Functions.identity();
    private static com.google.common.base.Function<CallerArguments, Boolean> callerVerifier = null;

    public static void setGetTableBehaviour(com.google.common.base.Function<Table, Table> modifier) {
        getTableModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetTableBehaviour() {
        InjectableBehaviourObjectStore.setGetTableBehaviour(null);
    }

    public static void setGetPartitionBehaviour(com.google.common.base.Function<Partition, Partition> modifier) {
        getPartitionModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetPartitionBehaviour() {
        InjectableBehaviourObjectStore.setGetPartitionBehaviour(null);
    }

    public static void setListPartitionNamesBehaviour(com.google.common.base.Function<List<String>, List<String>> modifier) {
        listPartitionNamesModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetListPartitionNamesBehaviour() {
        InjectableBehaviourObjectStore.setListPartitionNamesBehaviour(null);
    }

    public static void setGetNextNotificationBehaviour(com.google.common.base.Function<NotificationEventResponse, NotificationEventResponse> modifier) {
        getNextNotificationModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetNextNotificationBehaviour() {
        InjectableBehaviourObjectStore.setGetNextNotificationBehaviour(null);
    }

    public static void setCallerVerifier(com.google.common.base.Function<CallerArguments, Boolean> verifier) {
        callerVerifier = verifier;
    }

    public static void resetCallerVerifier() {
        InjectableBehaviourObjectStore.setCallerVerifier(null);
    }

    public Table getTable(String catName, String dbName, String tableName) throws MetaException {
        return (Table)getTableModifier.apply((Object)super.getTable(catName, dbName, tableName));
    }

    public Partition getPartition(String catName, String dbName, String tableName, List<String> partVals) throws NoSuchObjectException, MetaException {
        return (Partition)getPartitionModifier.apply((Object)super.getPartition(catName, dbName, tableName, partVals));
    }

    public List<String> listPartitionNames(String catName, String dbName, String tableName, short max) throws MetaException {
        return (List)listPartitionNamesModifier.apply((Object)super.listPartitionNames(catName, dbName, tableName, max));
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        return (NotificationEventResponse)getNextNotificationModifier.apply((Object)super.getNextNotification(rqst));
    }

    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(tbl.getDbName());
            args.tblName = tbl.getTableName();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Create Table operation on DB: " + args.dbName + " table: " + args.tblName);
            }
        }
        super.createTable(tbl);
    }

    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(func.getDbName());
            args.funcName = func.getFunctionName();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Create Function operation on DB: " + args.dbName + " function: " + args.funcName);
            }
        }
        super.createFunction(func);
    }

    public List<String> addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(pks.get(0).getTable_db());
            args.constraintTblName = pks.get(0).getTable_name();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Add Primary Key operation on DB: " + args.dbName + " table: " + args.constraintTblName);
            }
        }
        return super.addPrimaryKeys(pks);
    }

    public List<String> addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(fks.get(0).getFktable_db());
            args.constraintTblName = fks.get(0).getFktable_name();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Add Foreign Key operation on DB: " + args.dbName + " table: " + args.constraintTblName);
            }
        }
        return super.addForeignKeys(fks);
    }

    public class CallerArguments {
        public String dbName;
        public String tblName;
        public String funcName;
        public String constraintTblName;

        public CallerArguments(String dbName) {
            this.dbName = dbName;
        }
    }

    public static abstract class BehaviourInjection<T, F>
    implements com.google.common.base.Function<T, F> {
        protected boolean injectionPathCalled = false;
        protected boolean nonInjectedPathCalled = false;

        public void assertInjectionsPerformed(boolean expectedInjectionCalled, boolean expectedNonInjectedPathCalled) {
            Assert.assertEquals((Object)expectedInjectionCalled, (Object)this.injectionPathCalled);
            Assert.assertEquals((Object)expectedNonInjectedPathCalled, (Object)this.nonInjectedPathCalled);
        }
    }
}

