/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestPartitionNameWhitelistValidation {
    private static final String partitionValidationPattern = "[\\x20-\\x7E&&[^,]]*";
    private static Configuration conf;
    private static HiveMetaStoreClient msc;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        System.setProperty(MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.toString(), partitionValidationPattern);
        conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        msc = new HiveMetaStoreClient(conf);
    }

    private boolean runValidation(List<String> partVals) {
        try {
            msc.validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private List<String> getPartValsWithUnicode() {
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("kl\u00e2wen");
        partVals.add("t\u00e4gel\u00eech");
        return partVals;
    }

    private List<String> getPartValsWithCommas() {
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("a,b");
        partVals.add("c,d,e,f");
        return partVals;
    }

    private List<String> getPartValsWithValidCharacters() {
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("part1");
        partVals.add("part2");
        return partVals;
    }

    @Test
    public void testAddPartitionWithCommas() {
        Assert.assertFalse((String)"Add a partition with commas in name", (boolean)this.runValidation(this.getPartValsWithCommas()));
    }

    @Test
    public void testAddPartitionWithUnicode() {
        Assert.assertFalse((String)"Add a partition with unicode characters in name", (boolean)this.runValidation(this.getPartValsWithUnicode()));
    }

    @Test
    public void testAddPartitionWithValidPartVal() {
        Assert.assertTrue((String)"Add a partition with unicode characters in name", (boolean)this.runValidation(this.getPartValsWithValidCharacters()));
    }

    @Test
    public void testAppendPartitionWithUnicode() {
        Assert.assertFalse((String)"Append a partition with unicode characters in name", (boolean)this.runValidation(this.getPartValsWithUnicode()));
    }

    @Test
    public void testAppendPartitionWithCommas() {
        Assert.assertFalse((String)"Append a partition with unicode characters in name", (boolean)this.runValidation(this.getPartValsWithCommas()));
    }

    @Test
    public void testAppendPartitionWithValidCharacters() {
        Assert.assertTrue((String)"Append a partition with no unicode characters in name", (boolean)this.runValidation(this.getPartValsWithValidCharacters()));
    }
}

