/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestAddPartitionsFromPartSpec
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "test_partition_db";
    private static final String TABLE_NAME = "test_partition_table";
    private static final String DEFAULT_PARAM_VALUE = "partparamvalue";
    private static final String DEFAULT_PARAM_KEY = "partparamkey";
    private static final String DEFAULT_YEAR_VALUE = "2017";
    private static final String DEFAULT_COL_TYPE = "string";
    private static final String YEAR_COL_NAME = "year";
    private static final String MONTH_COL_NAME = "month";
    private static final int DEFAULT_CREATE_TIME = 123456;
    private static final short MAX = -1;

    public TestAddPartitionsFromPartSpec(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(DB_NAME).create(this.client, this.metaStore.getConf());
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testAddPartitionSpec() throws Exception {
        Table table = this.createTable();
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2013"}), TestAddPartitionsFromPartSpec.getYearPartCol(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2014"}), TestAddPartitionsFromPartSpec.getYearPartCol(), 2);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2012"}), TestAddPartitionsFromPartSpec.getYearPartCol(), 3);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2, partition3});
        String rootPath = table.getSd().getLocation() + "/addpartspectest/";
        PartitionSpecProxy partitionSpec = this.buildPartitionSpec(DB_NAME, TABLE_NAME, rootPath, partitions);
        this.client.add_partitions_pspec(partitionSpec);
        this.verifyPartition(table, "year=2013", Lists.newArrayList((Object[])new String[]{"2013"}), 1);
        this.verifyPartition(table, "year=2014", Lists.newArrayList((Object[])new String[]{"2014"}), 2);
        this.verifyPartition(table, "year=2012", Lists.newArrayList((Object[])new String[]{"2012"}), 3);
    }

    @Test
    public void testAddPartitionSpecWithSharedSD() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition1 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2013"}), 1);
        PartitionWithoutSD partition2 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2014"}), 2);
        PartitionWithoutSD partition3 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2012"}), 3);
        ArrayList partitions = Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition1, partition2, partition3});
        String location = table.getSd().getLocation() + "/sharedSDTest/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(partitions, this.buildSD(location));
        this.client.add_partitions_pspec(partitionSpecProxy);
        this.verifyPartitionSharedSD(table, "year=2013", Lists.newArrayList((Object[])new String[]{"2013"}), 1);
        this.verifyPartitionSharedSD(table, "year=2014", Lists.newArrayList((Object[])new String[]{"2014"}), 2);
        this.verifyPartitionSharedSD(table, "year=2012", Lists.newArrayList((Object[])new String[]{"2012"}), 3);
    }

    @Test
    public void testAddPartitionSpecsMultipleValues() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitionsFromPartSpec.getYearAndMonthPartCols(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2002", "march"}), TestAddPartitionsFromPartSpec.getYearAndMonthPartCols(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2003", "april"}), TestAddPartitionsFromPartSpec.getYearAndMonthPartCols(), 2);
        PartitionWithoutSD partition3 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2004", "june"}), 3);
        PartitionWithoutSD partition4 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2005", "may"}), 4);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2});
        ArrayList partitionsWithoutSD = Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition3, partition4});
        PartitionSpecProxy partitionSpec = this.buildPartitionSpec(partitions, partitionsWithoutSD);
        this.client.add_partitions_pspec(partitionSpec);
        this.verifyPartition(table, "year=2002/month=march", Lists.newArrayList((Object[])new String[]{"2002", "march"}), 1);
        this.verifyPartition(table, "year=2003/month=april", Lists.newArrayList((Object[])new String[]{"2003", "april"}), 2);
        this.verifyPartitionSharedSD(table, "year=2004/month=june", Lists.newArrayList((Object[])new String[]{"2004", "june"}), 3);
        this.verifyPartitionSharedSD(table, "year=2005/month=may", Lists.newArrayList((Object[])new String[]{"2005", "may"}), 4);
    }

    @Test(expected=NullPointerException.class)
    public void testAddPartitionSpecNullSpec() throws Exception {
        this.client.add_partitions_pspec(null);
    }

    @Test
    public void testAddPartitionSpecEmptyPartList() throws Exception {
        this.createTable();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        PartitionSpecProxy partitionSpec = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        this.client.add_partitions_pspec(partitionSpec);
    }

    @Test
    public void testAddPartitionSpecNullPartList() throws Exception {
        this.createTable();
        List<Partition> partitions = null;
        PartitionSpecProxy partitionSpec = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        try {
            this.client.add_partitions_pspec(partitionSpec);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecNoDB() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(null, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecNoTable() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, null, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecNoDBAndTableInPartition() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.setDbName(null);
        partition.setTableName(null);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecDBAndTableSetFromSpecProxy() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.setDbName(null);
        partition.setTableName(null);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(null, null, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpecProxy.setDbName(DB_NAME);
        partitionSpecProxy.setTableName(TABLE_NAME);
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)resultPart);
    }

    @Test
    public void testAddPartitionSpecWithSharedSDDBAndTableSetFromSpecProxy() throws Exception {
        this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), 1);
        String location = this.metaStore.getWarehouseRoot() + "/test_partition_table/sharedSDTest/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(location));
        partitionSpecProxy.setDbName(DB_NAME);
        partitionSpecProxy.setTableName(TABLE_NAME);
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)resultPart);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionSpecEmptyDB() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec("", TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionSpecEmptyTable() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, "", null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionSpecNonExistingDB() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec("nonexistingdb", TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionSpecNonExistingTable() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, "nonexistingtable", null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddPartitionSpecDiffDBName() throws Exception {
        this.createDB("NewPartDB");
        this.createTable();
        this.createTable("NewPartDB", "NewPartTable", TestAddPartitionsFromPartSpec.getYearPartCol(), null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition("NewPartDB", "NewPartTable", DEFAULT_YEAR_VALUE);
        partitions.add(partition1);
        partitions.add(partition2);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
        }
        finally {
            this.client.dropDatabase("NewPartDB", true, true, true);
        }
    }

    @Test
    public void testAddPartitionSpecNullPart() throws Exception {
        this.createTable();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Object partition2 = null;
        partitions.add(partition1);
        partitions.add((Partition)partition2);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecUnsupportedPartSpecType() throws Exception {
        this.createTable();
        PartitionSpec partitionSpec = new PartitionSpec();
        partitionSpec.setDbName(DB_NAME);
        partitionSpec.setTableName(TABLE_NAME);
        partitionSpec.setPartitionList(null);
        partitionSpec.setSharedSDPartitionSpec(null);
        try {
            PartitionSpecProxy bubu = PartitionSpecProxy.Factory.get((PartitionSpec)partitionSpec);
            this.client.add_partitions_pspec(bubu);
            Assert.fail((String)"AssertionError should have been thrown.");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecBothTypeSet() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2013"}), TestAddPartitionsFromPartSpec.getYearPartCol(), 1);
        PartitionWithoutSD partitionWithoutSD = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2014"}), 0);
        PartitionSpec partitionSpec = new PartitionSpec();
        partitionSpec.setDbName(DB_NAME);
        partitionSpec.setTableName(TABLE_NAME);
        PartitionListComposingSpec partitionListComposingSpec = new PartitionListComposingSpec();
        partitionListComposingSpec.setPartitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpec.setPartitionList(partitionListComposingSpec);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = new PartitionSpecWithSharedSD();
        partitionSpecWithSharedSD.setPartitions((List)Lists.newArrayList((Object[])new PartitionWithoutSD[]{partitionWithoutSD}));
        partitionSpecWithSharedSD.setSd(this.buildSD(table.getSd().getLocation() + "/sharedSDTest/"));
        partitionSpec.setSharedSDPartitionSpec(partitionSpecWithSharedSD);
        PartitionSpecProxy partitionSpecProxy = PartitionSpecProxy.Factory.get((PartitionSpec)partitionSpec);
        this.client.add_partitions_pspec(partitionSpecProxy);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)partitionNames);
        Assert.assertTrue((partitionNames.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"year=2013", partitionNames.get(0));
    }

    @Test
    public void testAddPartitionSpecSetRootPath() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        String rootPath1 = table.getSd().getLocation() + "/someotherpath/";
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2007", rootPath + "part2007/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, rootPath1, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2007"}));
        Assert.assertEquals((Object)(rootPath + "part2007"), (Object)resultPart.getSd().getLocation());
    }

    @Test
    public void testAddPartitionSpecChangeRootPath() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        String rootPath1 = table.getSd().getLocation() + "/someotherpath/";
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2007", rootPath + "part2007/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, rootPath, Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpecProxy.setRootLocation(rootPath1);
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2007"}));
        Assert.assertEquals((Object)(rootPath1 + "part2007"), (Object)resultPart.getSd().getLocation());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecChangeRootPathFromNull() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        String rootPath1 = table.getSd().getLocation() + "/someotherpath/";
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2007", rootPath + "part2007/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpecProxy.setRootLocation(rootPath1);
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=NullPointerException.class)
    public void testAddPartitionSpecChangeRootPathToNull() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2007", rootPath + "part2007/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, rootPath, Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpecProxy.setRootLocation(null);
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecChangeRootPathDiffInSd() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        String rootPath1 = table.getSd().getLocation() + "/addPartSdPath/";
        String rootPath2 = table.getSd().getLocation() + "/someotherpath/";
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2007", rootPath1 + "part2007/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, rootPath, Lists.newArrayList((Object[])new Partition[]{partition}));
        partitionSpecProxy.setRootLocation(rootPath2);
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecWithSharedSDChangeRootPath() throws Exception {
        Table table = this.createTable();
        String rootPath = table.getSd().getLocation() + "/addPartSpecRootPath/";
        String rootPath1 = table.getSd().getLocation() + "/someotherpath/";
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2014"}), 0);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(rootPath));
        partitionSpecProxy.setRootLocation(rootPath1);
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2014"}));
        Assert.assertEquals((Object)(rootPath1 + "partwithoutsd0"), (Object)resultPart.getSd().getLocation());
    }

    @Test
    public void testAddPartitionSpecWithSharedSDWithoutRelativePath() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2014"}), 0);
        partition.setRelativePath(null);
        String location = table.getSd().getLocation() + "/sharedSDTest/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(location));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2014");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/sharedSDTest/null"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test(expected=AlreadyExistsException.class)
    public void testAddPartitionSpecPartAlreadyExists() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
        Partition newPartition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{newPartition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecPartDuplicateInSpec() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecPartDuplicateInSpecs() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, TestAddPartitionsFromPartSpec.getYearPartCol(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2002"}), TestAddPartitionsFromPartSpec.getYearPartCol(), 1);
        PartitionWithoutSD partitionWithoutSD = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2002"}), 0);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(Lists.newArrayList((Object[])new Partition[]{partition}), Lists.newArrayList((Object[])new PartitionWithoutSD[]{partitionWithoutSD}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecNullSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.setSd(null);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecWithSharedSDNullSd() throws Exception {
        this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2002"}), 0);
        StorageDescriptor sd = null;
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), sd);
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecWithSharedSDNullLocation() throws Exception {
        this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2002"}), 0);
        partition.setRelativePath("year2002");
        String location = null;
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(location));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecWithSharedSDEmptyLocation() throws Exception {
        this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2002"}), 0);
        partition.setRelativePath("year2002");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(""));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecWithSharedSDInvalidSD() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2002"}), 0);
        partition.setRelativePath("year2002");
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(table.getSd().getLocation() + "/nullLocationTest/");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), sd);
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecNullLocation() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, null);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/year=2017"), (Object)resultPart.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionSpecEmptyLocation() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, "");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/year=2017"), (Object)resultPart.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionSpecEmptyLocationInTableToo() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitionsFromPartSpec.getYearPartCol(), null);
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, "");
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/year=2017"), (Object)resultPart.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart.getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecForView() throws Exception {
        Table table = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).setType("VIRTUAL_VIEW").addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addPartCol(YEAR_COL_NAME, DEFAULT_COL_TYPE).setLocation(null)).create(this.client, this.metaStore.getConf());
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecWithSharedSDNoValue() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition = new PartitionWithoutSD();
        partition.setRelativePath("addpartspectest");
        String location = table.getSd().getLocation() + "/nullValueTest/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(location));
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecNoValue() throws Exception {
        this.createTable();
        Partition partition = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol(YEAR_COL_NAME, DEFAULT_COL_TYPE)).setLocation(this.metaStore.getWarehouseRoot() + "/addpartspectest")).build(this.metaStore.getConf());
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecNullValue() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, null);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddPartitionSpecWithSharedSDEmptyValue() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition = new PartitionWithoutSD();
        partition.setRelativePath("addpartspectest");
        partition.setValues((List)Lists.newArrayList((Object[])new String[]{""}));
        String location = table.getSd().getLocation() + "/nullValueTest/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition}), this.buildSD(location));
        this.client.add_partitions_pspec(partitionSpecProxy);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)partitionNames);
        Assert.assertTrue((partitionNames.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"year=__HIVE_DEFAULT_PARTITION__", partitionNames.get(0));
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSpecMoreValues() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), TestAddPartitionsFromPartSpec.getYearAndMonthPartCols(), 1);
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, Lists.newArrayList((Object[])new Partition[]{partition}));
        this.client.add_partitions_pspec(partitionSpecProxy);
    }

    @Test
    public void testAddPartitionSpecWithSharedSDNoRelativePath() throws Exception {
        Table table = this.createTable();
        PartitionWithoutSD partition1 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2007"}), 0);
        PartitionWithoutSD partition2 = this.buildPartitionWithoutSD(Lists.newArrayList((Object[])new String[]{"2008"}), 0);
        partition1.setRelativePath(null);
        partition2.setRelativePath(null);
        String location = table.getSd().getLocation() + "/noRelativePath/";
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpecWithSharedSD(Lists.newArrayList((Object[])new PartitionWithoutSD[]{partition1, partition2}), this.buildSD(location));
        this.client.add_partitions_pspec(partitionSpecProxy);
        Partition resultPart1 = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2007"}));
        Assert.assertEquals((Object)(location + "null"), (Object)resultPart1.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart1.getSd().getLocation())));
        Partition resultPart2 = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2008"}));
        Assert.assertEquals((Object)(location + "null"), (Object)resultPart2.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart2.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionSpecOneInvalid() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2015", "march"}), TestAddPartitionsFromPartSpec.getYearAndMonthPartCols(), 1);
        partition3.getSd().setLocation(this.metaStore.getWarehouseRoot() + "/addparttest");
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2, partition3});
        PartitionSpecProxy partitionSpecProxy = this.buildPartitionSpec(DB_NAME, TABLE_NAME, null, partitions);
        try {
            this.client.add_partitions_pspec(partitionSpecProxy);
            Assert.fail((String)"MetaException should have occurred.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertTrue((boolean)parts.isEmpty());
    }

    private void createDB(String dbName) throws TException {
        Database db = new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createTable() throws Exception {
        return this.createTable(DB_NAME, TABLE_NAME, TestAddPartitionsFromPartSpec.getYearPartCol(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
    }

    private Table createTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        Table table = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addTableParam("partTestTableParamKey", "partTestTableParamValue").setPartCols(partCols).addStorageDescriptorParam("partTestSDParamKey", "partTestSDParamValue")).setSerdeName(tableName)).setStoredAsSubDirectories(false)).addSerdeParam("partTestSerdeParamKey", "partTestSerdeParamValue")).setLocation(location)).create(this.client, this.metaStore.getConf());
        return this.client.getTable(dbName, tableName);
    }

    private Partition buildPartition(String dbName, String tableName, String value) throws MetaException {
        return this.buildPartition(dbName, tableName, value, this.metaStore.getWarehouseRoot() + "/" + tableName + "/addparttest");
    }

    private Partition buildPartition(String dbName, String tableName, String value, String location) throws MetaException {
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(dbName).setTableName(tableName).addValue(value).addCol(YEAR_COL_NAME, DEFAULT_COL_TYPE)).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addPartParam(DEFAULT_PARAM_KEY, DEFAULT_PARAM_VALUE).setLocation(location)).build(this.metaStore.getConf());
        return partition;
    }

    private Partition buildPartition(List<String> values, List<FieldSchema> partCols, int index) throws MetaException {
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).setValues(values).addPartParam(DEFAULT_PARAM_KEY + index, DEFAULT_PARAM_VALUE + index).setInputFormat("TestInputFormat" + index)).setOutputFormat("TestOutputFormat" + index)).setSerdeName("partserde" + index)).addStorageDescriptorParam("partsdkey" + index, "partsdvalue" + index)).setCols(partCols)).setCreateTime(123456).setLastAccessTime(123456).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).build(this.metaStore.getConf());
        return partition;
    }

    private static List<FieldSchema> getYearAndMonthPartCols() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, DEFAULT_COL_TYPE, "month part col"));
        return cols;
    }

    private static List<FieldSchema> getYearPartCol() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        return cols;
    }

    private void verifyPartition(Table table, String name, List<String> values, int index) throws Exception {
        Partition part = this.client.getPartition(table.getDbName(), table.getTableName(), name);
        Assert.assertNotNull((String)"The partition should not be null.", (Object)part);
        Assert.assertEquals((String)"The table name in the partition is not correct.", (Object)table.getTableName(), (Object)part.getTableName());
        List partValues = part.getValues();
        Assert.assertEquals((long)values.size(), (long)partValues.size());
        Assert.assertTrue((String)"The partition has wrong values.", (boolean)partValues.containsAll(values));
        Assert.assertEquals((String)"The DB name in the partition is not correct.", (Object)table.getDbName(), (Object)part.getDbName());
        Assert.assertEquals((String)"The last access time is not correct.", (long)123456L, (long)part.getLastAccessTime());
        Assert.assertNotEquals((long)123456L, (long)part.getCreateTime());
        Assert.assertEquals((String)"The partition's parameter map should contain the partparamkey - partparamvalue pair.", (Object)(DEFAULT_PARAM_VALUE + index), part.getParameters().get(DEFAULT_PARAM_KEY + index));
        StorageDescriptor sd = part.getSd();
        Assert.assertNotNull((String)"The partition's storage descriptor must not be null.", (Object)sd);
        Assert.assertEquals((String)"The input format is not correct.", (Object)("TestInputFormat" + index), (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format is not correct.", (Object)("TestOutputFormat" + index), (Object)sd.getOutputFormat());
        Assert.assertEquals((String)"The serdeInfo name is not correct.", (Object)("partserde" + index), (Object)sd.getSerdeInfo().getName());
        Assert.assertEquals((String)"The parameter map of the partition's storage descriptor should contain the partsdkey - partsdvalue pair.", (Object)("partsdvalue" + index), sd.getParameters().get("partsdkey" + index));
        Assert.assertEquals((String)"The parameter's location is not correct.", (Object)(this.metaStore.getWarehouseRoot() + "/test_partition_table/" + name), (Object)sd.getLocation());
        Assert.assertTrue((String)"The parameter's location should exist on the file system.", (boolean)this.metaStore.isPathExists(new Path(sd.getLocation())));
        Assert.assertFalse((String)"The partition should not inherit the table parameters.", (boolean)part.getParameters().keySet().contains(table.getParameters().keySet()));
    }

    private PartitionWithoutSD buildPartitionWithoutSD(List<String> values, int index) throws MetaException {
        PartitionWithoutSD partition = new PartitionWithoutSD();
        partition.setCreateTime(123456);
        partition.setLastAccessTime(123456);
        partition.setValues(values);
        HashMap<CallSite, CallSite> parameters = new HashMap<CallSite, CallSite>();
        parameters.put((CallSite)((Object)(DEFAULT_PARAM_KEY + index)), (CallSite)((Object)(DEFAULT_PARAM_VALUE + index)));
        partition.setParameters(parameters);
        partition.setRelativePath("partwithoutsd" + index);
        return partition;
    }

    private PartitionSpecProxy buildPartitionSpec(String dbName, String tableName, String rootPath, List<Partition> partitions) {
        PartitionSpec partitionSpec = new PartitionSpec();
        partitionSpec.setDbName(dbName);
        partitionSpec.setRootPath(rootPath);
        partitionSpec.setTableName(tableName);
        PartitionListComposingSpec partitionListComposingSpec = new PartitionListComposingSpec();
        partitionListComposingSpec.setPartitions(partitions);
        partitionSpec.setPartitionList(partitionListComposingSpec);
        return PartitionSpecProxy.Factory.get((PartitionSpec)partitionSpec);
    }

    private StorageDescriptor buildSD(String location) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setInputFormat("TestInputFormat");
        sd.setOutputFormat("TestOutputFormat");
        sd.setCols(TestAddPartitionsFromPartSpec.getYearPartCol());
        sd.setCompressed(false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("testSDParamKey", "testSDParamValue");
        sd.setParameters(parameters);
        sd.setLocation(location);
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName("sharedSDPartSerde");
        sd.setSerdeInfo(serdeInfo);
        return sd;
    }

    private PartitionSpecProxy buildPartitionSpecWithSharedSD(List<PartitionWithoutSD> partitions, StorageDescriptor sd) {
        PartitionSpec partitionSpec = new PartitionSpec();
        partitionSpec.setDbName(DB_NAME);
        partitionSpec.setTableName(TABLE_NAME);
        PartitionSpecWithSharedSD partitionList = new PartitionSpecWithSharedSD();
        partitionList.setPartitions(partitions);
        partitionList.setSd(sd);
        partitionSpec.setSharedSDPartitionSpec(partitionList);
        return PartitionSpecProxy.Factory.get((PartitionSpec)partitionSpec);
    }

    private PartitionSpecProxy buildPartitionSpec(List<Partition> partitions, List<PartitionWithoutSD> partitionsWithoutSD) throws MetaException {
        ArrayList<PartitionSpec> partitionSpecs = new ArrayList<PartitionSpec>();
        PartitionSpec partitionSpec = new PartitionSpec();
        partitionSpec.setDbName(DB_NAME);
        partitionSpec.setTableName(TABLE_NAME);
        PartitionListComposingSpec partitionListComposingSpec = new PartitionListComposingSpec();
        partitionListComposingSpec.setPartitions(partitions);
        partitionSpec.setPartitionList(partitionListComposingSpec);
        PartitionSpec partitionSpecSharedSD = new PartitionSpec();
        partitionSpecSharedSD.setDbName(DB_NAME);
        partitionSpecSharedSD.setTableName(TABLE_NAME);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = new PartitionSpecWithSharedSD();
        partitionSpecWithSharedSD.setPartitions(partitionsWithoutSD);
        partitionSpecWithSharedSD.setSd(this.buildSD(this.metaStore.getWarehouseRoot() + "/test_partition_table/sharedSDTest/"));
        partitionSpecSharedSD.setSharedSDPartitionSpec(partitionSpecWithSharedSD);
        partitionSpecs.add(partitionSpec);
        partitionSpecs.add(partitionSpecSharedSD);
        return PartitionSpecProxy.Factory.get(partitionSpecs);
    }

    private void verifyPartitionSharedSD(Table table, String name, List<String> values, int index) throws Exception {
        Partition part = this.client.getPartition(table.getDbName(), table.getTableName(), name);
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)table.getTableName(), (Object)part.getTableName());
        List partValues = part.getValues();
        Assert.assertEquals((long)values.size(), (long)partValues.size());
        Assert.assertTrue((boolean)partValues.containsAll(values));
        Assert.assertEquals((Object)table.getDbName(), (Object)part.getDbName());
        Assert.assertEquals((long)123456L, (long)part.getLastAccessTime());
        Assert.assertEquals((Object)(DEFAULT_PARAM_VALUE + index), part.getParameters().get(DEFAULT_PARAM_KEY + index));
        Assert.assertFalse((boolean)part.getParameters().keySet().contains(table.getParameters().keySet()));
        StorageDescriptor sd = part.getSd();
        Assert.assertNotNull((Object)sd);
        Assert.assertEquals((Object)"TestInputFormat", (Object)sd.getInputFormat());
        Assert.assertEquals((Object)"TestOutputFormat", (Object)sd.getOutputFormat());
        Assert.assertEquals((Object)"sharedSDPartSerde", (Object)sd.getSerdeInfo().getName());
        Assert.assertEquals((Object)"testSDParamValue", sd.getParameters().get("testSDParamKey"));
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/test_partition_table/sharedSDTest/partwithoutsd" + index), (Object)sd.getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(sd.getLocation())));
    }
}

