/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.fm;

import java.io.IOException;
import javolution.util.FastBitSet;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestFMSketchSerialization {
    private FastBitSet[] deserialize(String s, int numBitVectors) {
        FastBitSet[] b = new FastBitSet[numBitVectors];
        for (int j = 0; j < numBitVectors; ++j) {
            b[j] = new FastBitSet(31);
            b[j].clear();
        }
        int vectorIndex = 0;
        int i = 1;
        while (i < s.length() - 1) {
            char c = s.charAt(i);
            ++i;
            if (c == '}') {
                ++vectorIndex;
            }
            if (c < '0' || c > '9') continue;
            Object t = new String();
            t = (String)t + c;
            c = s.charAt(i);
            ++i;
            while (c != ',' && c != '}') {
                t = (String)t + c;
                c = s.charAt(i);
                ++i;
            }
            int bitIndex = Integer.parseInt((String)t);
            assert (bitIndex >= 0);
            assert (vectorIndex < numBitVectors);
            b[vectorIndex].set(bitIndex);
            if (c != '}') continue;
            ++vectorIndex;
        }
        return b;
    }

    @Test
    public void testSerDe() throws IOException {
        String bitVectors = "{0, 4, 5, 7}{0, 1}{0, 1, 2}{0, 1, 4}{0}{0, 2}{0, 3}{0, 2, 3, 4}{0, 1, 4}{0, 1}{0}{0, 1, 3, 8}{0, 2}{0, 2}{0, 9}{0, 1, 4}";
        FastBitSet[] fastBitSet = this.deserialize(bitVectors, 16);
        FMSketch sketch = new FMSketch(16);
        for (int i = 0; i < 16; ++i) {
            sketch.setBitVector(fastBitSet[i], i);
        }
        Assert.assertEquals((long)sketch.estimateNumDistinctValues(), (long)3L);
        byte[] buf = sketch.serialize();
        FMSketch newSketch = (FMSketch)NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
        sketch.equals(newSketch);
        Assert.assertEquals((long)newSketch.estimateNumDistinctValues(), (long)3L);
        Assert.assertArrayEquals((byte[])newSketch.serialize(), (byte[])buf);
    }
}

