/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;

public class JSONOpenTxnMessage
extends OpenTxnMessage {
    @JsonProperty
    private List<Long> txnIds;
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private Long fromTxnId;
    @JsonProperty
    private Long toTxnId;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;

    public JSONOpenTxnMessage() {
    }

    public JSONOpenTxnMessage(String server, String servicePrincipal, List<Long> txnIds, Long timestamp) {
        this.timestamp = timestamp;
        this.txnIds = txnIds;
        this.server = server;
        this.servicePrincipal = servicePrincipal;
    }

    public JSONOpenTxnMessage(String server, String servicePrincipal, Long fromTxnId, Long toTxnId, Long timestamp) {
        this.timestamp = timestamp;
        this.txnIds = null;
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.fromTxnId = fromTxnId;
        this.toTxnId = toTxnId;
    }

    @Override
    public List<Long> getTxnIds() {
        if (this.txnIds != null) {
            return this.txnIds;
        }
        return LongStream.rangeClosed(this.fromTxnId, this.toTxnId).boxed().collect(Collectors.toList());
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

