/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.cli.HiveFileProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetCrossReferenceOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetPrimaryKeysOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.server.KillQueryImpl;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSessionImpl
implements HiveSession {
    private final SessionHandle sessionHandle;
    private String username;
    private final String password;
    private final HiveConf sessionConf;
    private final long creationTime;
    private SessionState sessionState;
    private String ipAddress;
    private List<String> forwardedAddresses;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final Logger LOG = LoggerFactory.getLogger(HiveSessionImpl.class);
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private final Set<OperationHandle> opHandleSet = new HashSet<OperationHandle>();
    private boolean isOperationLogEnabled;
    private File sessionLogDir;
    private Hive sessionHive;
    private volatile long lastAccessTime = System.currentTimeMillis();
    private volatile boolean lockedByUser;
    private final Semaphore operationLock;
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)(HiveSessionImpl.class.getName() + ".audit"));
    private static final Set<String> ODBC_KEYWORDS = Collections.unmodifiableSet(new HashSet(Lists.newArrayList((Object[])new String[]{"ABSOLUTE", "ACTION", "ADA", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT_LENGTH", "BIT", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR_LENGTH", "CHAR", "CHARACTER_LENGTH", "CHARACTER", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURRENT", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FORTRAN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INCLUDE", "INDEX", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PASCAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION_USER", "SESSION", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCA", "SQLCODE", "SQLERROR", "SQLSTATE", "SQLWARNING", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"})));

    public HiveSessionImpl(SessionHandle sessionHandle, TProtocolVersion protocol, String username, String password, HiveConf serverConf, String ipAddress, List<String> forwardedAddresses) {
        this.username = username;
        this.password = password;
        this.creationTime = System.currentTimeMillis();
        this.sessionHandle = sessionHandle != null ? sessionHandle : new SessionHandle(protocol);
        this.sessionConf = new HiveConf(serverConf);
        this.ipAddress = ipAddress;
        this.forwardedAddresses = forwardedAddresses;
        this.operationLock = serverConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_OPS_IN_SESSION) ? null : new Semaphore(1);
        this.sessionConf.set(HiveConf.ConfVars.HIVESESSIONID.varname, this.sessionHandle.getHandleIdentifier().toString());
        this.sessionConf.set("list.sink.output.formatter", ThriftFormatter.class.getName());
        this.sessionConf.setInt("list.sink.output.protocol", protocol.getValue());
    }

    @Override
    public void open(Map<String, String> sessionConfMap) throws HiveSQLException {
        this.sessionState = new SessionState(this.sessionConf, this.username);
        this.sessionState.setUserIpAddress(this.ipAddress);
        this.sessionState.setIsHiveServerQuery(true);
        this.sessionState.setForwardedAddresses(SessionManager.getForwardedAddresses());
        this.sessionState.setIsUsingThriftJDBCBinarySerDe(this.updateIsUsingThriftJDBCBinarySerDe());
        try {
            if (this.sessionManager != null) {
                this.sessionState.setHiveServer2Host(this.sessionManager.getHiveServer2HostName());
            }
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        this.sessionState.setKillQuery((KillQuery)new KillQueryImpl(this.operationManager));
        SessionState.start((SessionState)this.sessionState);
        try {
            this.sessionState.loadAuxJars();
            this.sessionState.loadReloadableAuxJars();
        }
        catch (IOException e) {
            String msg = "Failed to load reloadable jar file path: " + e;
            LOG.error(msg, (Throwable)e);
            throw new HiveSQLException(msg, e);
        }
        try {
            this.sessionHive = Hive.get((HiveConf)this.getHiveConf());
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to get metastore connection", e);
        }
        this.processGlobalInitFile();
        sessionConfMap = this.setFetchSize(sessionConfMap);
        if (sessionConfMap != null) {
            this.configureSession(sessionConfMap);
        }
        this.lastAccessTime = System.currentTimeMillis();
        AUDIT_LOG.info("Connected: sessionId={} user={} ip={}  auth={}", new Object[]{this.getSessionConf().getVar(HiveConf.ConfVars.HIVESESSIONID), this.getUserName(), this.getIpAddress(), this.getSessionConf().getVar(HiveConf.ConfVars.HIVE_JDBC_CLIENT_AUTHENTICATION)});
    }

    private void processGlobalInitFile() {
        GlobalHivercFileProcessor processor = new GlobalHivercFileProcessor();
        try {
            String hiverc = this.sessionConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_GLOBAL_INIT_FILE_LOCATION);
            if (hiverc != null) {
                File hivercFile = new File(hiverc);
                if (hivercFile.isDirectory()) {
                    hivercFile = new File(hivercFile, ".hiverc");
                }
                if (hivercFile.isFile()) {
                    LOG.info("Running global init file: " + hivercFile);
                    int rc = processor.processFile(hivercFile.getAbsolutePath());
                    if (rc != 0) {
                        LOG.error("Failed on initializing global .hiverc file");
                    }
                } else {
                    LOG.debug("Global init file " + hivercFile + " does not exist");
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed on initializing global .hiverc file", (Throwable)e);
        }
    }

    private Map<String, String> setFetchSize(Map<String, String> sessionConfMap) {
        String confFetchSize;
        int maxFetchSize = this.sessionConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_MAX_FETCH_SIZE);
        String string = confFetchSize = sessionConfMap != null ? sessionConfMap.get("set:hiveconf:" + HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE.varname) : null;
        if (confFetchSize != null && !confFetchSize.isEmpty()) {
            int fetchSize = Integer.parseInt(confFetchSize);
            sessionConfMap.put("set:hiveconf:" + HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE.varname, Integer.toString(fetchSize > maxFetchSize ? maxFetchSize : fetchSize));
        }
        return sessionConfMap;
    }

    private void configureSession(Map<String, String> sessionConfMap) throws HiveSQLException {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        for (Map.Entry<String, String> entry : sessionConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("set:")) {
                try {
                    SetProcessor.setVariable((String)key.substring(4), (String)entry.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new HiveSQLException(e);
                }
            }
            if (key.startsWith("use:")) {
                try {
                    if (this.sessionHive.getDatabase(entry.getValue()) == null) {
                        throw new HiveSQLException("Database " + entry.getValue() + " does not exist");
                    }
                }
                catch (HiveException e) {
                    throw new HiveSQLException(e);
                }
                SessionState.get().setCurrentDatabase(entry.getValue());
                continue;
            }
            this.sessionConf.verifyAndSet(key, entry.getValue());
        }
    }

    private boolean updateIsUsingThriftJDBCBinarySerDe() {
        return 8 <= this.getProtocolVersion().getValue() && this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS);
    }

    @Override
    public void setOperationLogSessionDir(File operationLogRootDir) {
        if (!operationLogRootDir.exists()) {
            LOG.warn("The operation log root directory is removed, recreating:" + operationLogRootDir.getAbsolutePath());
            if (!operationLogRootDir.mkdirs()) {
                LOG.warn("Unable to create operation log root directory: " + operationLogRootDir.getAbsolutePath());
            }
        }
        if (!operationLogRootDir.canWrite()) {
            LOG.warn("The operation log root directory is not writable: " + operationLogRootDir.getAbsolutePath());
        }
        this.sessionLogDir = new File(operationLogRootDir, this.sessionHandle.getHandleIdentifier().toString());
        this.isOperationLogEnabled = true;
        if (!this.sessionLogDir.exists() && !this.sessionLogDir.mkdir()) {
            LOG.warn("Unable to create operation log session directory: " + this.sessionLogDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (this.isOperationLogEnabled) {
            LOG.info("Operation log session directory is created: " + this.sessionLogDir.getAbsolutePath());
        }
    }

    @Override
    public boolean isOperationLogEnabled() {
        return this.isOperationLogEnabled;
    }

    @Override
    public File getOperationLogSessionDir() {
        return this.sessionLogDir;
    }

    @Override
    public TProtocolVersion getProtocolVersion() {
        return this.sessionHandle.getProtocolVersion();
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire(boolean userAccess, boolean isOperation) {
        if (isOperation && this.operationLock != null) {
            try {
                this.operationLock.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        boolean success = false;
        try {
            this.acquireAfterOpLock(userAccess);
            success = true;
        }
        finally {
            if (!success && isOperation && this.operationLock != null) {
                this.operationLock.release();
            }
        }
    }

    private synchronized void acquireAfterOpLock(boolean userAccess) {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        this.sessionState.setForwardedAddresses(SessionManager.getForwardedAddresses());
        this.sessionState.setIsUsingThriftJDBCBinarySerDe(this.updateIsUsingThriftJDBCBinarySerDe());
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
            this.lockedByUser = true;
        }
        this.sessionState.updateThreadName();
        Hive.set((Hive)this.sessionHive);
    }

    protected void release(boolean userAccess, boolean isOperation) {
        try {
            this.releaseBeforeOpLock(userAccess);
        }
        finally {
            if (isOperation && this.operationLock != null) {
                this.operationLock.release();
            }
        }
    }

    private synchronized void releaseBeforeOpLock(boolean userAccess) {
        if (this.sessionState != null) {
            this.sessionState.resetThreadName();
        }
        SessionState.detachSession();
        if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
            ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
            currentThread.cacheThreadLocalRawStore();
        }
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
            this.lockedByUser = false;
        }
    }

    @Override
    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public HiveConf getHiveConf() {
        this.sessionConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.sessionConf;
    }

    @Override
    public Hive getSessionHive() {
        return this.sessionHive;
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        try {
            return this.getSessionHive().getMSC();
        }
        catch (MetaException e) {
            throw new HiveSQLException("Failed to get metastore connection: " + e, e);
        }
    }

    @Override
    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire(true, true);
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue(HiveVersionInfo.getVersion());
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_ODBC_KEYWORDS: {
                    GetInfoValue getInfoValue = new GetInfoValue(ParseUtils.getKeywords(ODBC_KEYWORDS));
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public HiveConf getSessionConf() {
        return this.sessionConf;
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, false, 0L);
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, false, queryTimeout);
    }

    @Override
    public OperationHandle executeStatementAsync(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, true, 0L);
    }

    @Override
    public OperationHandle executeStatementAsync(String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, true, queryTimeout);
    }

    private OperationHandle executeStatementInternal(String statement, Map<String, String> confOverlay, boolean runAsync, long queryTimeout) throws HiveSQLException {
        this.acquire(true, true);
        Operation operation = null;
        OperationHandle opHandle = null;
        try {
            operation = this.getOperationManager().newExecuteStatementOperation(this.getSession(), statement, confOverlay, runAsync, queryTimeout);
            opHandle = operation.getHandle();
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            if (opHandle != null) {
                this.removeOpHandle(opHandle);
                this.getOperationManager().closeOperation(opHandle);
            }
            throw e;
        }
        finally {
            if (operation == null || operation.getBackgroundHandle() == null) {
                this.release(true, true);
            } else {
                this.releaseBeforeOpLock(true);
            }
        }
    }

    @Override
    public Future<?> submitBackgroundOperation(Runnable work) {
        return this.getSessionManager().submitBackgroundOperation(this.operationLock == null ? work : new FutureTask<Void>(work, null){

            @Override
            protected void done() {
                HiveSessionImpl.this.operationLock.release();
            }
        });
    }

    @Override
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetTypeInfoOperation operation = operationManager.newGetTypeInfoOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetCatalogsOperation operation = operationManager.newGetCatalogsOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetSchemasOperation operation = operationManager.newGetSchemasOperation(this.getSession(), catalogName, schemaName);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        MetadataOperation operation = operationManager.newGetTablesOperation(this.getSession(), catalogName, schemaName, tableName, tableTypes);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetTableTypesOperation operation = operationManager.newGetTableTypesOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire(true, true);
        String addedJars = Utilities.getResourceFiles((Configuration)this.sessionConf, (SessionState.ResourceType)SessionState.ResourceType.JAR);
        if (StringUtils.isNotBlank((String)addedJars)) {
            IMetaStoreClient metastoreClient = this.getSession().getMetaStoreClient();
            metastoreClient.setHiveAddedJars(addedJars);
        }
        OperationManager operationManager = this.getOperationManager();
        GetColumnsOperation operation = operationManager.newGetColumnsOperation(this.getSession(), catalogName, schemaName, tableName, columnName);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpHandle(OperationHandle opHandle) {
        Set<OperationHandle> set = this.opHandleSet;
        synchronized (set) {
            this.opHandleSet.add(opHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpHandle(OperationHandle opHandle) {
        Set<OperationHandle> set = this.opHandleSet;
        synchronized (set) {
            this.opHandleSet.remove(opHandle);
        }
    }

    @Override
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetFunctionsOperation operation = operationManager.newGetFunctionsOperation(this.getSession(), catalogName, schemaName, functionName);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire(true, false);
            ArrayList<OperationHandle> ops = null;
            Set<OperationHandle> set = this.opHandleSet;
            synchronized (set) {
                ops = new ArrayList<OperationHandle>(this.opHandleSet);
                this.opHandleSet.clear();
            }
            for (OperationHandle opHandle : ops) {
                this.operationManager.closeOperation(opHandle);
            }
            this.cleanupSessionLogDir();
            HiveHistory hiveHist = this.sessionState.getHiveHistory();
            if (null != hiveHist) {
                hiveHist.closeStream();
            }
            try {
                this.sessionState.resetThreadName();
                this.sessionState.close();
            }
            catch (Throwable throwable) {
                AUDIT_LOG.info("Disconnected: sessionId={} user={} ip={}  auth={}", new Object[]{this.getSessionConf().getVar(HiveConf.ConfVars.HIVESESSIONID), this.getUserName(), this.getIpAddress(), this.getSessionConf().getVar(HiveConf.ConfVars.HIVE_JDBC_CLIENT_AUTHENTICATION)});
                this.sessionState = null;
                throw throwable;
            }
            AUDIT_LOG.info("Disconnected: sessionId={} user={} ip={}  auth={}", new Object[]{this.getSessionConf().getVar(HiveConf.ConfVars.HIVESESSIONID), this.getUserName(), this.getIpAddress(), this.getSessionConf().getVar(HiveConf.ConfVars.HIVE_JDBC_CLIENT_AUTHENTICATION)});
            this.sessionState = null;
        }
        catch (IOException ioe) {
            throw new HiveSQLException("Failure to close", ioe);
        }
        finally {
            if (this.sessionState != null) {
                try {
                    this.sessionState.resetThreadName();
                    this.sessionState.close();
                }
                catch (Throwable t) {
                    LOG.warn("Error closing session", t);
                }
                this.sessionState = null;
            }
            if (this.sessionHive != null) {
                try {
                    Hive.closeCurrent();
                }
                catch (Throwable t) {
                    LOG.warn("Error closing sessionHive", t);
                }
                this.sessionHive = null;
            }
            this.release(true, false);
        }
    }

    private void cleanupSessionLogDir() {
        if (this.isOperationLogEnabled && this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVE_TESTING_REMOVE_LOGS)) {
            try {
                FileUtils.forceDelete((File)this.sessionLogDir);
                LOG.info("Operation log session directory is deleted: " + this.sessionLogDir.getAbsolutePath());
            }
            catch (Exception e) {
                LOG.error("Failed to cleanup session log dir: " + this.sessionHandle, (Throwable)e);
            }
        }
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeExpiredOperations() {
        List<Operation> operations;
        OperationHandle[] handles;
        Set<OperationHandle> set = this.opHandleSet;
        synchronized (set) {
            handles = this.opHandleSet.toArray(new OperationHandle[this.opHandleSet.size()]);
        }
        if (handles.length > 0 && !(operations = this.operationManager.removeExpiredOperations(handles)).isEmpty()) {
            this.closeTimedOutOperations(operations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNoOperationTime() {
        boolean noMoreOpHandle = false;
        Set<OperationHandle> set = this.opHandleSet;
        synchronized (set) {
            noMoreOpHandle = this.opHandleSet.isEmpty();
        }
        return noMoreOpHandle && !this.lockedByUser ? System.currentTimeMillis() - this.lastAccessTime : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTimedOutOperations(List<Operation> operations) {
        this.acquire(false, false);
        try {
            for (Operation operation : operations) {
                this.removeOpHandle(operation.getHandle());
                try {
                    operation.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception is thrown closing timed-out operation, reported open_operations metrics may be incorrect " + operation.getHandle(), (Throwable)e);
                }
            }
        }
        finally {
            this.release(false, false);
        }
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true, false);
        try {
            this.sessionManager.getOperationManager().cancelOperation(opHandle);
        }
        finally {
            this.release(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true, false);
        try {
            this.operationManager.closeOperation(opHandle);
            Set<OperationHandle> set = this.opHandleSet;
            synchronized (set) {
                this.opHandleSet.remove(opHandle);
            }
        }
        finally {
            this.release(true, false);
        }
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true, true);
        try {
            TableSchema tableSchema = this.sessionManager.getOperationManager().getOperationResultSetSchema(opHandle);
            return tableSchema;
        }
        finally {
            this.release(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        this.acquire(true, false);
        try {
            if (fetchType == FetchType.QUERY_OUTPUT) {
                RowSet rowSet = this.operationManager.getOperationNextRowSet(opHandle, orientation, maxRows);
                return rowSet;
            }
            RowSet rowSet = this.operationManager.getOperationLogRowSet(opHandle, orientation, maxRows, this.sessionConf);
            return rowSet;
        }
        finally {
            this.release(true, false);
        }
    }

    protected HiveSession getSession() {
        return this;
    }

    @Override
    public int getOpenOperationCount() {
        return this.opHandleSet.size();
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    @Override
    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUserName(), owner, this.getIpAddress(), this.getHiveConf());
        return authFactory.getDelegationToken(owner, renewer, this.getIpAddress());
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUserName(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUserName(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.renewDelegationToken(tokenStr);
    }

    private String getUserFromToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        return authFactory.getUserFromToken(tokenStr);
    }

    @Override
    public OperationHandle getPrimaryKeys(String catalog, String schema, String table) throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetPrimaryKeysOperation operation = operationManager.newGetPrimaryKeysOperation(this.getSession(), catalog, schema, table);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public OperationHandle getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws HiveSQLException {
        this.acquire(true, true);
        OperationManager operationManager = this.getOperationManager();
        GetCrossReferenceOperation operation = operationManager.newGetCrossReferenceOperation(this.getSession(), primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        OperationHandle opHandle = operation.getHandle();
        try {
            this.addOpHandle(opHandle);
            operation.run();
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            this.removeOpHandle(opHandle);
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true, true);
        }
    }

    @Override
    public void setApplicationName(String value) {
        String oldName = this.sessionState.getHiveVariables().put("wmapp", value);
        if (oldName != null && !oldName.equals(value)) {
            LOG.info("ApplicationName changed from " + oldName + " to " + value);
        }
    }

    private class GlobalHivercFileProcessor
    extends HiveFileProcessor {
        private GlobalHivercFileProcessor() {
        }

        protected BufferedReader loadFile(String fileName) throws IOException {
            FileInputStream initStream = null;
            BufferedReader bufferedReader = null;
            initStream = new FileInputStream(fileName);
            bufferedReader = new BufferedReader(new InputStreamReader(initStream));
            return bufferedReader;
        }

        protected int processCmd(String cmd) {
            int rc = 0;
            String cmd_trimed = cmd.trim();
            OperationHandle opHandle = null;
            try {
                opHandle = HiveSessionImpl.this.executeStatementInternal(cmd_trimed, null, false, 0L);
            }
            catch (HiveSQLException e) {
                LOG.warn("Failed to execute command in global .hiverc file.", (Throwable)e);
                return -1;
            }
            if (opHandle != null) {
                try {
                    HiveSessionImpl.this.closeOperation(opHandle);
                }
                catch (HiveSQLException e) {
                    LOG.warn("Failed to close operation for command in .hiverc file.", (Throwable)e);
                }
            }
            return rc;
        }
    }
}

