/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.junit.Assert;
import org.junit.Test;

public class TestCLIServiceRestore {
    CLIService service = this.getService();

    @Test
    public void testRestore() throws HiveSQLException {
        SessionHandle session = this.service.openSession("foo", "bar", null);
        this.service.stop();
        this.service = this.getService();
        try {
            this.service.getSessionManager().getSession(session);
            Assert.fail((String)"session already exists before restore");
        }
        catch (HiveSQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid SessionHandle"));
        }
        this.service.createSessionWithSessionHandle(session, "foo", "bar", null);
        Assert.assertNotNull((Object)this.service.getSessionManager().getSession(session));
        this.service.stop();
    }

    public CLIService getService() {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        CLIService service = new CLIService(null);
        service.init(conf);
        service.start();
        return service;
    }
}

