/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContext;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.Before;
import org.junit.Test;

public class TestSessionHooks
extends TestCase {
    private static String sessionUserName = "user1";
    private EmbeddedThriftBinaryCLIService service;
    private ThriftCLIServiceClient client;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        SessionHookTest.runCount.set(0);
        System.setProperty(HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK.varname, SessionHookTest.class.getName());
        this.service = new EmbeddedThriftBinaryCLIService();
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.service.init(hiveConf);
        this.client = new ThriftCLIServiceClient((TCLIService.Iface)this.service);
    }

    @Test
    public void testSessionHook() throws Exception {
        SessionHandle sessionHandle = this.client.openSession(sessionUserName, "foobar", Collections.emptyMap());
        Assert.assertEquals((int)1, (int)SessionHookTest.runCount.get());
        this.client.closeSession(sessionHandle);
    }

    @Test
    public void testProxyUser() throws Exception {
        String connectingUser = "user1";
        String proxyUser = System.getProperty("user.name");
        HashMap<String, String> sessConf = new HashMap<String, String>();
        sessConf.put("hive.server2.proxy.user", proxyUser);
        sessionUserName = proxyUser;
        SessionHandle sessionHandle = this.client.openSession(connectingUser, "foobar", sessConf);
        Assert.assertEquals((int)1, (int)SessionHookTest.runCount.get());
        this.client.closeSession(sessionHandle);
    }

    public static class SessionHookTest
    implements HiveSessionHook {
        public static AtomicInteger runCount = new AtomicInteger(0);

        public void run(HiveSessionHookContext sessionHookContext) throws HiveSQLException {
            Assert.assertEquals((String)sessionHookContext.getSessionUser(), (String)sessionUserName);
            String sessionHook = sessionHookContext.getSessionConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK);
            Assert.assertTrue((boolean)sessionHook.contains(this.getClass().getName()));
            Assert.assertEquals((int)0, (int)runCount.getAndIncrement());
        }
    }
}

