/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.Assert;
import org.junit.Test;

public class TestSessionCleanup
extends TestCase {
    @Test
    public void testTempSessionFileCleanup() throws Exception {
        EmbeddedThriftBinaryCLIService service = new EmbeddedThriftBinaryCLIService();
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        service.init(hiveConf);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        HashSet<String> existingPipeoutFiles = new HashSet<String>(Arrays.asList(this.getPipeoutFiles()));
        SessionHandle sessionHandle = client.openSession("user1", "foobar", Collections.emptyMap());
        client.executeStatement(sessionHandle, "set a=b", null);
        File operationLogRootDir = new File(new HiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION));
        Assert.assertNotEquals((long)operationLogRootDir.list().length, (long)0L);
        client.closeSession(sessionHandle);
        Assert.assertEquals((long)operationLogRootDir.list().length, (long)0L);
        HashSet<String> finalPipeoutFiles = new HashSet<String>(Arrays.asList(this.getPipeoutFiles()));
        finalPipeoutFiles.removeAll(existingPipeoutFiles);
        Assert.assertTrue((boolean)finalPipeoutFiles.isEmpty());
    }

    private String[] getPipeoutFiles() {
        File localScratchDir = new File(new HiveConf().getVar(HiveConf.ConfVars.LOCALSCRATCHDIR));
        String[] pipeoutFiles = localScratchDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("pipeout");
            }
        });
        return pipeoutFiles;
    }
}

